/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.home;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import open.batoru.Main;
import open.batoru.Settings;
import open.batoru.core.Player;
import open.batoru.networking.HTTPPostRequest;
import open.batoru.networking.connection.RunnableConnection;
import open.batoru.networking.service.UpdateProcedureService;
import open.batoru.networking.service.UserLoginService;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.ThemeController;
import open.batoru.ui.Throbber;
import open.batoru.ui.UI;
import open.batoru.ui.home.HomePanelOnline;

public class HomePanelAuth
extends HomePanelOnline {
    private static final String SV_AUTH_URL_LOGIN = "https://open.batoru.moe/game/auth/auth2.php";
    private static final String PATTERN_VALID_USERNAME = "[A-Za-z0-9_\\-]+";
    private static final int MIN_USERNAME_LENGTH = 4;
    private static final int MAX_USERNAME_LENGTH = 20;
    private static final int MIN_PASSWORD_LENGTH = 6;
    private static final int MAX_PASSWORD_LENGTH = 32;
    private final TextField fieldUsername;
    private final TextField fieldPassword;
    private final CheckBox checkBoxRememberMe;
    private final Button buttonSubmit;
    private final Throbber throbber = new Throbber();
    private boolean isWaiting;
    private boolean isRegisterEnabled;

    public HomePanelAuth() {
        this.fieldUsername = new TextField(Settings.INSTANCE.getLastRememberedLoginUsername());
        this.fieldUsername.setPromptText(LanguageParser.getString("UI_AUTH_USERNAME"));
        this.fieldUsername.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (double)14.0));
        this.fieldUsername.setMaxWidth(220.0);
        this.fieldUsername.textProperty().addListener((ov, oldValue, newValue) -> {
            if (!this.isRegisterEnabled) {
                return;
            }
            ThemeController.toggleStyleClass((Node)this.fieldUsername, "ui_home_panel_register_form_invalid", !newValue.isEmpty() && HomePanelAuth.isUsernameInvalid(newValue));
        });
        this.fieldPassword = new PasswordField();
        this.fieldPassword.setText(Settings.INSTANCE.getLastRememberedLoginKey());
        this.fieldPassword.setPromptText(LanguageParser.getString("UI_AUTH_PASSWORD"));
        this.fieldPassword.setFont(this.fieldUsername.getFont());
        this.fieldPassword.setMaxWidth(this.fieldUsername.getMaxWidth());
        this.fieldPassword.textProperty().addListener((ov, oldValue, newValue) -> {
            if (!this.isRegisterEnabled) {
                return;
            }
            ThemeController.toggleStyleClass((Node)this.fieldPassword, "ui_home_panel_register_form_invalid", !newValue.isEmpty() && HomePanelAuth.isPasswordInvalid(newValue));
        });
        this.checkBoxRememberMe = new CheckBox(LanguageParser.getString("UI_AUTH_CHECKBOX_REMEMBER"));
        this.checkBoxRememberMe.setFont(this.fieldUsername.getFont());
        if (!this.fieldPassword.getText().isEmpty()) {
            this.checkBoxRememberMe.setSelected(true);
        }
        this.buttonSubmit = new Button(LanguageParser.getString("UI_AUTH_BUTTON_LOGIN"));
        this.buttonSubmit.setFont(this.fieldUsername.getFont());
        this.buttonSubmit.setPrefWidth(120.0);
        this.buttonSubmit.setDefaultButton(true);
        VBox.setMargin((Node)this.fieldUsername, (Insets)new Insets(0.0, 0.0, -5.0, 0.0));
        VBox.setMargin((Node)this.checkBoxRememberMe, (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
        this.getContent().getChildren().addAll((Object[])new Node[]{this.fieldUsername, this.fieldPassword, this.checkBoxRememberMe, this.buttonSubmit});
        StackPane.setMargin((Node)this.throbber, (Insets)new Insets(45.0, 0.0, 0.0, 0.0));
        this.throbber.setVisible(false);
        this.getChildren().add((Object)this.throbber);
        this.installActions();
    }

    private void installActions() {
        this.buttonSubmit.setOnAction(e -> {
            if (HomePanelAuth.isUsernameInvalid(this.fieldUsername.getText()) || HomePanelAuth.isPasswordInvalid(this.fieldPassword.getText())) {
                this.showFailAlert(LanguageParser.getString("UI_ALERT_AUTH_LOGIN"));
                return;
            }
            this.isWaiting = true;
            String data = "username=" + URLEncoder.encode(this.fieldUsername.getText(), StandardCharsets.UTF_8) + "&password=" + URLEncoder.encode(this.fieldPassword.getText(), StandardCharsets.UTF_8) + "&update_hash=" + URLEncoder.encode(Settings.INSTANCE.getAutoUpdateServiceHash(), StandardCharsets.UTF_8) + "&version=" + URLEncoder.encode(Settings.INSTANCE.getGameVersionClient(), StandardCharsets.UTF_8) + (this.checkBoxRememberMe.isSelected() ? "&remember" : "") + (this.isRegisterEnabled ? "&register" : "");
            this.setControlsVisible(false);
            this.throbber.setVisible(true);
            this.throbber.playAnimation();
            new Thread(() -> {
                HTTPPostRequest request = new HTTPPostRequest();
                try {
                    Properties props = request.send(SV_AUTH_URL_LOGIN, data);
                    String responseCode = props.getProperty("response");
                    Platform.runLater(() -> {
                        if (responseCode == null) {
                            this.showFailAlert(LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY") + "\n\nResponse code: null");
                            return;
                        }
                        switch (responseCode) {
                            case "!1": {
                                String keyHash = props.getProperty("key_hash");
                                if (keyHash == null) {
                                    this.showFailAlert(LanguageParser.getString("UI_ALERT_AUTH_LOGIN") + "\n\nUnknown key hash.");
                                    return;
                                }
                                if (this.checkBoxRememberMe.isSelected()) {
                                    String keyRemember = props.getProperty("key_remember");
                                    if (keyRemember != null) {
                                        Settings.INSTANCE.setLastRememberedLoginInfo(this.fieldUsername.getText(), keyRemember);
                                    }
                                } else {
                                    Settings.INSTANCE.forgetRememberedLoginInfo();
                                }
                                Player.setUsername(this.fieldUsername.getText());
                                Player.setKeyHash(keyHash);
                                UserLoginService service = new UserLoginService(status -> {
                                    if (status != RunnableConnection.ResponseStatus.SUCCESS) {
                                        Player.setUsername(null);
                                        Player.setKeyHash(null);
                                        this.showFailAlert(LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY") + "\n\nResponse status: " + String.valueOf((Object)status));
                                    } else {
                                        this.throbber.stopAnimation();
                                        this.throbber.setVisible(false);
                                        this.fieldUsername.setText("");
                                        this.fieldPassword.setText("");
                                        UI.getTabHome().toggleHomePanels(true);
                                        Main.updateWindowTitle("");
                                    }
                                });
                                service.start();
                                break;
                            }
                            case "!2": {
                                this.showFailAlert(LanguageParser.getString("UI_ALERT_AUTH_REGISTER"));
                                break;
                            }
                            case "!5": {
                                if (this.checkBoxRememberMe.isSelected()) {
                                    Settings.INSTANCE.forgetRememberedLoginInfo();
                                    this.fieldPassword.setText("");
                                }
                                this.showFailAlert(LanguageParser.getString("UI_ALERT_AUTH_LOGIN"));
                                break;
                            }
                            case "!6": {
                                String expectedAutoUpdateServiceHash = props.getProperty("update_hash");
                                if (expectedAutoUpdateServiceHash == null) {
                                    this.showFailAlert(LanguageParser.getString("UI_ALERT_UPDATE_HEADER") + "\n\nInvalid response.");
                                    return;
                                }
                                Alert alert = new Alert(Alert.AlertType.CONFIRMATION, LanguageParser.getString("UI_ALERT_UPDATE"), new ButtonType[]{ButtonType.YES, ButtonType.NO});
                                alert.setHeaderText(LanguageParser.getString("UI_ALERT_UPDATE_HEADER"));
                                alert.showAndWait().ifPresent(result -> {
                                    if (result.getButtonData() == ButtonBar.ButtonData.YES) {
                                        UpdateProcedureService updateProcedure = new UpdateProcedureService(expectedAutoUpdateServiceHash);
                                        if (Settings.INSTANCE.getAutoUpdateServiceHash().equalsIgnoreCase(expectedAutoUpdateServiceHash)) {
                                            updateProcedure.runAutoUpdater();
                                        } else {
                                            updateProcedure.startDownload();
                                        }
                                    } else {
                                        this.showFailAlert(null);
                                    }
                                });
                                break;
                            }
                            default: {
                                this.showFailAlert(LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY") + "\n\nResponse code: " + responseCode);
                            }
                        }
                    });
                }
                catch (IOException | InterruptedException ex) {
                    Platform.runLater(() -> this.showFailAlert(LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY")));
                }
            }).start();
        });
    }

    private void showFailAlert(String message) {
        if (message != null) {
            new Alert(Alert.AlertType.ERROR, message, new ButtonType[0]).showAndWait();
        }
        this.throbber.stopAnimation();
        this.throbber.setVisible(false);
        this.setControlsVisible(true);
        this.isWaiting = false;
    }

    private void setControlsVisible(boolean set) {
        this.buttonSubmit.setVisible(set);
        this.fieldUsername.setVisible(set);
        this.fieldPassword.setVisible(set);
        this.checkBoxRememberMe.setVisible(set);
        if (!set && !this.isRegisterEnabled) {
            this.fieldPassword.setText("");
        }
    }

    public void toggleRegisterControls() {
        boolean bl = this.isRegisterEnabled = !this.isRegisterEnabled;
        if (this.isRegisterEnabled) {
            this.buttonSubmit.setText(LanguageParser.getString("UI_AUTH_BUTTON_REGISTER"));
            this.getContent().getStyleClass().add((Object)"ui_home_panel_register");
            if (!this.fieldUsername.getText().isEmpty() && HomePanelAuth.isUsernameInvalid(this.fieldUsername.getText())) {
                this.fieldUsername.getStyleClass().add((Object)"ui_home_panel_register_form_invalid");
            }
            if (!this.fieldPassword.getText().isEmpty() && HomePanelAuth.isPasswordInvalid(this.fieldPassword.getText())) {
                this.fieldPassword.getStyleClass().add((Object)"ui_home_panel_register_form_invalid");
            }
        } else {
            this.buttonSubmit.setText(LanguageParser.getString("UI_AUTH_BUTTON_LOGIN"));
            this.getContent().getStyleClass().remove((Object)"ui_home_panel_register");
            this.fieldUsername.getStyleClass().remove((Object)"ui_home_panel_register_form_invalid");
            this.fieldPassword.getStyleClass().remove((Object)"ui_home_panel_register_form_invalid");
        }
    }

    public boolean isWaiting() {
        return this.isWaiting;
    }

    public boolean isRegisterEnabled() {
        return this.isRegisterEnabled;
    }

    private static boolean isUsernameInvalid(String username) {
        return username.length() < 4 || username.length() > 20 || !username.matches(PATTERN_VALID_USERNAME);
    }

    private static boolean isPasswordInvalid(String password) {
        return password.length() < 6 || password.length() > 32;
    }
}

