/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.home;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import open.batoru.Main;
import open.batoru.Settings;
import open.batoru.parsers.LanguageParser;
import open.batoru.replays.ReplayDataParser;
import open.batoru.replays.ReplayStartProcedure;
import open.batoru.replays.UtilReplays;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;
import open.batoru.ui.UITab;
import open.batoru.ui.home.HomePanelAuth;
import open.batoru.ui.home.HomePanelLogout;
import open.batoru.ui.home.HomePanelRegister;

public class UITabHome
extends UITab
implements UI.Selectable {
    private WebView webViewHome;
    private final HomePanelAuth panelAuth = new HomePanelAuth();
    private final HomePanelRegister panelRegister = new HomePanelRegister(this.panelAuth);
    private final HomePanelLogout panelLogout = new HomePanelLogout();

    public UITabHome() {
        this.showHomePage();
        this.showDisclaimerNotice();
        VBox content = new VBox();
        content.setSpacing(10.0);
        content.setPrefWidth(300.0);
        VBox contentPanels = new VBox();
        contentPanels.setSpacing(10.0);
        contentPanels.getChildren().addAll((Object[])new Node[]{this.panelAuth, this.panelLogout, this.panelRegister});
        this.panelLogout.setVisible(false);
        this.panelLogout.setManaged(false);
        content.getChildren().addAll((Object[])new Node[]{contentPanels, this.showOfflineSubPanel()});
        this.addToTab((Node)content, UITab.Position.RIGHT, new Insets(10.0, 20.0, 0.0, 0.0));
    }

    private void showHomePage() {
        this.webViewHome = new WebView();
        this.webViewHome.getEngine().setJavaScriptEnabled(false);
        this.webViewHome.getEngine().getLoadWorker().stateProperty().addListener((ov, oldValue, newValue) -> {
            if (newValue == Worker.State.FAILED) {
                this.webViewHome.getEngine().loadContent("<p style=\"color: red;\">" + LanguageParser.getString("UI_HOME_WEB_ERROR") + "</p>");
            }
        });
        this.loadHomePage();
        StackPane container = new StackPane();
        container.getChildren().add((Object)this.webViewHome);
        container.setBorder(UIConst.Style.BORDER_SILVER);
        this.addToTab((Node)container, UITab.Position.CENTER, new Insets(10.0, 20.0, 0.0, 20.0));
    }

    private void showDisclaimerNotice() {
        HBox container = new HBox();
        container.setAlignment(Pos.CENTER_LEFT);
        container.setSpacing(5.0);
        Text noticeIcon = new Text("\ud83d\udec8");
        noticeIcon.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)21.0));
        noticeIcon.getStyleClass().add((Object)"disclaimer");
        HBox.setMargin((Node)noticeIcon, (Insets)new Insets(0.0, 0.0, 2.0, 0.0));
        Text notice = new Text(LanguageParser.getString("UI_HOME_DISCLAIMER"));
        notice.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)8.0));
        notice.getStyleClass().add((Object)"disclaimer");
        notice.wrappingWidthProperty().bind((ObservableValue)this.webViewHome.widthProperty());
        container.getChildren().addAll((Object[])new Node[]{noticeIcon, notice});
        this.addToTab((Node)container, UITab.Position.BOTTOM, new Insets(5.0, 0.0, 5.0, 20.0));
    }

    @Override
    public void onSelected() {
        this.loadHomePage();
    }

    @Override
    public void onDeselected() {
    }

    private void loadHomePage() {
        this.webViewHome.getEngine().load("https://open.batoru.moe/blog/index.php?lang=" + Settings.INSTANCE.getGameLanguage() + (Settings.INSTANCE.isUsingDarkTheme() ? "&theme=dark" : ""));
    }

    private VBox showOfflineSubPanel() {
        VBox subPanel = new VBox();
        subPanel.setPadding(new Insets(10.0));
        subPanel.setAlignment(Pos.CENTER);
        subPanel.setSpacing(10.0);
        subPanel.getStyleClass().add((Object)"ui_home_panel_offline");
        Label labelTitle = new Label(LanguageParser.getString("UI_HOME_OFFLINE"));
        Button buttonWatchReplay = new Button(LanguageParser.getString("UI_HOME_OFFLINE_BUTTON_REPLAY"));
        buttonWatchReplay.setPrefWidth(200.0);
        buttonWatchReplay.setPrefHeight(28.0);
        buttonWatchReplay.setOnAction(e -> {
            if (!UtilReplays.canWatchGames()) {
                return;
            }
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Load Replay");
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Open!batoru Replay Data", new String[]{"*.replay"}));
            try {
                Path directory = Path.of("replays/", new String[0]);
                if (!Files.exists(directory, new LinkOption[0])) {
                    Files.createDirectory(directory, new FileAttribute[0]);
                }
                fileChooser.setInitialDirectory(directory.toFile());
            }
            catch (IOException ex) {
                fileChooser.setInitialDirectory(new File("."));
            }
            File file = fileChooser.showOpenDialog((Window)Main.getStage());
            if (file == null || !file.isFile() || !file.exists()) {
                return;
            }
            ReplayDataParser parser = new ReplayDataParser(file.toPath());
            parser.parse();
            ReplayStartProcedure.play(parser);
        });
        subPanel.getChildren().addAll((Object[])new Node[]{labelTitle, buttonWatchReplay});
        return subPanel;
    }

    private void addTestButtons(VBox subPanel) {
        Button buttonSandbox = new Button("Sandbox");
        buttonSandbox.setPrefWidth(100.0);
        buttonSandbox.setPrefHeight(28.0);
        buttonSandbox.setOnAction(e -> {});
        subPanel.getChildren().addAll((Object[])new Node[]{buttonSandbox});
    }

    public void toggleHomePanels(boolean isLogged) {
        this.panelAuth.setVisible(!isLogged);
        this.panelAuth.setManaged(!isLogged);
        this.panelRegister.setVisible(!isLogged);
        this.panelRegister.setManaged(!isLogged);
        this.panelLogout.setVisible(isLogged);
        this.panelLogout.setManaged(isLogged);
        if (isLogged) {
            this.panelLogout.update();
        }
    }
}

