/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.ui.Throbber;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;
import open.batoru.ui.rooms.RoomListEntry;

public class RoomList
extends StackPane {
    private final VBox content = new VBox();
    private final Throbber throbber = new Throbber();
    private final Map<Integer, RoomListEntry> entries = new HashMap<Integer, RoomListEntry>();
    private boolean isLocked;

    public RoomList() {
        this.throbber.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT_OVERLAY);
        this.content.setSpacing(-1.0);
        this.getChildren().add((Object)this.content);
    }

    public void addEntry(RoomListEntry entry) {
        this.addEntry(entry, true);
    }

    public void addEntry(RoomListEntry entry, boolean shouldPrioritizePlayer) {
        if (entry == null) {
            return;
        }
        this.entries.put(entry.getRoom().getRoomId(), entry);
        this.content.getChildren().add(shouldPrioritizePlayer && !entry.getRoom().getPlayerData(Game.GamePlayerRole.HOST).getPlayerName().equals(Player.getUsername()) ? this.content.getChildren().size() : 0, (Object)entry);
    }

    public void removeEntry(int roomId) {
        RoomListEntry entry = this.entries.get(roomId);
        this.content.getChildren().remove((Object)entry);
        this.entries.remove(roomId);
    }

    public RoomListEntry getEntry(int roomId) {
        return this.entries.get(roomId);
    }

    public void sortEntries(Comparator<RoomListEntry> comparator) {
        List<RoomListEntry> sortedEntries = this.entries.values().stream().sorted(comparator).toList();
        UtilDispose.PERM.suppressDispose(() -> this.content.getChildren().setAll((Collection)sortedEntries));
    }

    public int getTotalEntries() {
        return this.entries.size();
    }

    public void clearAllEntries() {
        this.entries.clear();
        this.content.getChildren().clear();
    }

    public boolean containsEntry(int roomId) {
        return this.entries.containsKey(roomId);
    }

    public void setLock(boolean set) {
        if (set && !this.getChildren().contains((Object)this.throbber)) {
            this.getChildren().add((Object)this.throbber);
            this.throbber.playAnimation();
            this.content.setOpacity(0.75);
        } else if (!set && this.getChildren().contains((Object)this.throbber)) {
            this.getChildren().remove((Object)this.throbber);
            this.throbber.stopAnimation();
            this.content.setOpacity(1.0);
        }
        this.isLocked = set;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public final VBox getContent() {
        return this.content;
    }
}

