/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import open.batoru.core.Disposable;
import open.batoru.core.Player;
import open.batoru.core.rooms.Room;

public abstract class RoomListEntry
extends BorderPane
implements Disposable {
    private final Room room;
    private boolean isSelected;
    private final StackPane content = new StackPane();
    private final StackPane contentExtra = new StackPane();

    public RoomListEntry(Room room) {
        this.room = room;
        this.setPadding(new Insets(4.0));
        this.getStyleClass().add((Object)"ui_rooms_panel_list_entry");
        this.setOnMouseEntered(e -> this.onMouseEntered());
        this.setOnMouseExited(e -> this.onMouseExited());
        this.setCenter((Node)this.content);
        this.setBottom((Node)this.contentExtra);
    }

    public StackPane getContent() {
        return this.content;
    }

    public StackPane getContentExtra() {
        return this.contentExtra;
    }

    public void onMouseEntered() {
        if (Player.getCurrentRoom() == null) {
            this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), true);
        }
    }

    public void onMouseExited() {
        this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), false);
    }

    public void select() {
        if (this.isSelected) {
            return;
        }
        this.isSelected = true;
        this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"selected"), true);
        Player.setCurrentRoom(this.room);
    }

    public void deselect() {
        if (!this.isSelected) {
            return;
        }
        this.isSelected = false;
        this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), false);
        this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"selected"), false);
        Player.setCurrentRoom(null);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void hide() {
        this.setManaged(false);
        this.setVisible(false);
    }

    public void show() {
        this.setManaged(true);
        this.setVisible(true);
    }

    public Room getRoom() {
        return this.room;
    }

    @Override
    public void dispose() {
        this.setOnMouseEntered(null);
        this.setOnMouseExited(null);
        this.setOnMouseClicked(null);
    }
}

