/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.Settings;
import open.batoru.core.Player;
import open.batoru.networking.HTTPPostRequest;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UIConst;

public class RoomPanelSurvey
extends VBox {
    public RoomPanelSurvey(ToggleButton sourceButton) {
        this.getStyleClass().add((Object)"ui_deck_panel");
        this.getStyleClass().add((Object)"ui_deck_panel_window_advanced_filters");
        this.setBorder(UIConst.Style.BORDER_SILVER);
        this.setMinSize(620.0, 480.0);
        this.setMaxSize(this.getMinWidth(), this.getMinHeight());
        this.setPadding(new Insets(10.0));
        this.setSpacing(10.0);
        Text textTitle = new Text(LanguageParser.getString("UI_ROOM_SURVEY_TITLE"));
        textTitle.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)16.0));
        textTitle.setWrappingWidth(600.0);
        TextArea textArea1 = new TextArea();
        Label label1 = new Label(LanguageParser.getString("UI_ROOM_SURVEY_QUESTION1"));
        textArea1.setPrefRowCount(2);
        textArea1.setWrapText(true);
        TextArea textArea2 = new TextArea();
        Label label2 = new Label(LanguageParser.getString("UI_ROOM_SURVEY_QUESTION2"));
        textArea2.setPrefRowCount(2);
        textArea2.setWrapText(true);
        TextArea textArea3 = new TextArea();
        Label label3 = new Label(LanguageParser.getString("UI_ROOM_SURVEY_QUESTION3"));
        textArea3.setPrefRowCount(4);
        textArea3.setWrapText(true);
        Button buttonSend = new Button(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_SEND"));
        buttonSend.setPrefSize(600.0, 40.0);
        buttonSend.getStyleClass().add((Object)"ui_deck_panel_button_art");
        this.getChildren().addAll((Object[])new Node[]{textTitle, new Separator(), label1, textArea1, new Separator(), label2, textArea2, new Separator(), label3, textArea3, new Separator(), buttonSend});
        buttonSend.setOnAction(e -> {
            if (textArea1.getLength() == 0 && textArea2.getLength() == 0 && textArea3.getLength() == 0) {
                sourceButton.fire();
                return;
            }
            buttonSend.setDisable(true);
            String message = textArea1.getText(0, Math.min(4096, textArea1.getLength())) + "\n[2]\n" + textArea2.getText(0, Math.min(4096, textArea2.getLength())) + "\n[3]\n" + textArea3.getText(0, Math.min(8192, textArea3.getLength()));
            String data = "username=" + URLEncoder.encode(Player.getUsername(), StandardCharsets.UTF_8) + "&message=" + URLEncoder.encode(message, StandardCharsets.UTF_8);
            new Thread(() -> {
                HTTPPostRequest request = new HTTPPostRequest();
                try {
                    Properties props = request.send("https://open.batoru.moe/game/service/survey.php", data);
                    String responseCode = props.getProperty("response");
                    Platform.runLater(() -> {
                        if (responseCode == null || !responseCode.equals("!1")) {
                            new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_REPORT_FAIL") + "\n\nResponse code: " + responseCode, new ButtonType[0]).show();
                            return;
                        }
                        new Alert(Alert.AlertType.INFORMATION, LanguageParser.getString("UI_ALERT_REPORT_SUCCESS"), new ButtonType[0]).show();
                        sourceButton.fire();
                        sourceButton.setDisable(true);
                        sourceButton.setText(LanguageParser.getString("UI_ROOM_SURVEY_BUTTON_USED"));
                        Settings.INSTANCE.getParser().updateValue("SURVEY_DONE", "1");
                        Settings.INSTANCE.getParser().writeSettings();
                    });
                }
                catch (IOException | InterruptedException ex) {
                    Platform.runLater(() -> new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_REPORT_FAIL"), new ButtonType[0]).show());
                }
                finally {
                    Platform.runLater(() -> buttonSend.setDisable(false));
                }
            }).start();
        });
    }
}

