/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import open.batoru.Settings;
import open.batoru.core.Player;
import open.batoru.core.rooms.Room;
import open.batoru.data.CardConst;
import open.batoru.networking.connection.RoomCreateAttempt;
import open.batoru.networking.connection.RunnableConnection;
import open.batoru.networking.service.UpdateProcedureService;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.deck.DeckCompatibilityService;
import open.batoru.ui.deck.OptionFilters;
import open.batoru.ui.rooms.OpenRoomEntry;

public class RoomsControlsCreate
extends VBox {
    private final Button buttonCreate;
    private final TextField fieldDescription;
    private final ComboBox<String> boxFormat;
    private final ComboBox<String> boxStartingPlayer;
    private final CheckBox checkAllowSpectators;
    private final CheckBox checkAllowUnreleased;
    private final CheckBox checkAllowUnrestricted;

    public RoomsControlsCreate() {
        this.setSpacing(10.0);
        this.buttonCreate = new Button(LanguageParser.getString("UI_ROOM_CREATE_BUTTON"));
        this.buttonCreate.setPrefHeight(25.0);
        this.buttonCreate.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.buttonCreate.setOnAction(e -> this.onActionRoomCreate());
        this.fieldDescription = new TextField(Settings.INSTANCE.getParser().getValue("LAST_ROOM_DESC"));
        this.fieldDescription.setPromptText(LanguageParser.getString("UI_ROOM_CREATE_DESC"));
        HBox containerFormat = new HBox();
        containerFormat.setAlignment(Pos.CENTER_LEFT);
        containerFormat.setSpacing(5.0);
        Label labelFormat = new Label(LanguageParser.getString("UI_ROOM_CREATE_FORMAT"));
        this.boxFormat = new ComboBox(OptionFilters.getFormatList());
        this.boxFormat.getItems().removeFirst();
        this.boxFormat.getSelectionModel().select(CardConst.PlayFormat.getPlayFormatById(Integer.parseInt(Settings.INSTANCE.getParser().getValue("LAST_ROOM_FORMAT"))).ordinal());
        containerFormat.getChildren().addAll((Object[])new Node[]{labelFormat, this.boxFormat});
        HBox containerStartingPlayer = new HBox();
        containerStartingPlayer.setAlignment(Pos.CENTER_LEFT);
        containerStartingPlayer.setSpacing(5.0);
        Label labelStartingPlayer = new Label(LanguageParser.getString("UI_ROOM_CREATE_START_PLAYER"));
        this.boxStartingPlayer = new ComboBox();
        for (Room.StartingPlayer startingPlayer : Room.StartingPlayer.values()) {
            this.boxStartingPlayer.getItems().add((Object)startingPlayer.getLabel());
        }
        this.boxStartingPlayer.getSelectionModel().select(Integer.parseInt(Settings.INSTANCE.getParser().getValue("LAST_ROOM_START_PLAYER")));
        containerStartingPlayer.getChildren().addAll((Object[])new Node[]{labelStartingPlayer, this.boxStartingPlayer});
        this.checkAllowSpectators = new CheckBox(LanguageParser.getString("UI_ROOM_CREATE_ALLOW_SPEC"));
        this.checkAllowUnreleased = new CheckBox(LanguageParser.getString("UI_ROOM_CREATE_ALLOW_UNRELEASED"));
        this.checkAllowUnrestricted = new CheckBox(LanguageParser.getString("UI_ROOM_CREATE_ALLOW_RESTRICTED"));
        int lastRoomFlags = Integer.parseInt(Settings.INSTANCE.getParser().getValue("LAST_ROOM_FLAGS"));
        this.checkAllowSpectators.setSelected((lastRoomFlags & 1) != 0);
        this.checkAllowUnreleased.setSelected((lastRoomFlags & 2) != 0);
        this.checkAllowUnrestricted.setSelected((lastRoomFlags & 4) != 0);
        this.getChildren().addAll((Object[])new Node[]{this.buttonCreate, this.fieldDescription, containerFormat, containerStartingPlayer, this.checkAllowSpectators, this.checkAllowUnreleased, this.checkAllowUnrestricted});
    }

    private void onActionRoomCreate() {
        CardConst.PlayFormat playFormat = CardConst.PlayFormat.getPlayFormatByLabel((String)this.boxFormat.getValue());
        DeckCompatibilityService service = new DeckCompatibilityService();
        Optional<String> message = service.getCompatibilityMessage(Settings.INSTANCE.getCurrentPlayDeck(), this.checkAllowUnreleased.isSelected(), this.checkAllowUnrestricted.isSelected(), playFormat);
        if (message.isPresent()) {
            new Alert(Alert.AlertType.WARNING, message.get(), new ButtonType[0]).showAndWait();
            return;
        }
        Room.StartingPlayer startingPlayer = Room.StartingPlayer.getStartingPlayerById(this.boxStartingPlayer.getSelectionModel().getSelectedIndex());
        this.sendRoomCreateAttempt(this.getDescriptionText(), this.getRoomFlags(), playFormat, startingPlayer);
    }

    private void sendRoomCreateAttempt(String description, int roomFlags, CardConst.PlayFormat playFormat, Room.StartingPlayer startingPlayer) {
        this.setRoomCreationEnabled(false);
        RunnableConnection connection = new RunnableConnection(() -> new RoomCreateAttempt(description, roomFlags, playFormat, startingPlayer), (socketReceiver, pp, status) -> {
            if (status != RunnableConnection.ResponseStatus.SUCCESS) {
                if (status == RunnableConnection.ResponseStatus.TIMEOUT) {
                    new Alert(Alert.AlertType.ERROR, LanguageParser.getString("UI_ALERT_CONNECT_TIMEOUT_RETRY"), new ButtonType[0]).showAndWait();
                }
                this.setRoomCreationEnabled(true);
                if (pp != null && pp.getPacketData().equals("!6")) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, LanguageParser.getString("UI_ALERT_UPDATE"), new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    alert.setHeaderText(LanguageParser.getString("UI_ALERT_UPDATE_HEADER"));
                    alert.showAndWait();
                    if (((ButtonType)alert.getResult()).getButtonData() != ButtonBar.ButtonData.YES) {
                        return;
                    }
                    UpdateProcedureService updateProcedure = new UpdateProcedureService(null);
                    updateProcedure.runAutoUpdater();
                }
                return;
            }
            int roomId = Integer.parseInt(pp.getDataArgument(0));
            Room room = UI.getTabRooms().getRoomCoordinator().getRoomOrDefault(roomId, roomFlags, playFormat, startingPlayer, Player.getUsername());
            OpenRoomEntry entry = new OpenRoomEntry(room, description);
            UI.getTabRooms().getRoomListOpen().addEntry(entry);
            entry.select();
            UI.getTabRooms().getControls().toggleRoomControls(true);
            UI.getTabRooms().getControls().getControlsOpen().startTextAnimation();
            this.updateDefaultRoomSettings(description, roomFlags, playFormat.getId(), startingPlayer.getId());
        });
        new Thread(connection).start();
    }

    private void updateDefaultRoomSettings(String description, int roomFlags, int idPlayFormat, int idStartingPlayer) {
        Settings.INSTANCE.getParser().updateValue("LAST_ROOM_DESC", description);
        Settings.INSTANCE.getParser().updateValue("LAST_ROOM_FORMAT", String.valueOf(idPlayFormat));
        Settings.INSTANCE.getParser().updateValue("LAST_ROOM_START_PLAYER", String.valueOf(idStartingPlayer));
        Settings.INSTANCE.getParser().updateValue("LAST_ROOM_FLAGS", String.valueOf(roomFlags));
        Settings.INSTANCE.getParser().writeSettings();
    }

    public void setRoomCreationEnabled(boolean isEnabled) {
        this.buttonCreate.setDisable(!isEnabled);
    }

    public String getDescriptionText() {
        return this.fieldDescription.getText().substring(0, Math.min(this.fieldDescription.getText().length(), 32)).replaceAll("\\|", "").replaceAll("~", "");
    }

    private int getRoomFlags() {
        int roomFlags = 0;
        if (this.checkAllowSpectators.isSelected()) {
            roomFlags |= 1;
        }
        if (this.checkAllowUnreleased.isSelected()) {
            roomFlags |= 2;
        }
        if (this.checkAllowUnrestricted.isSelected()) {
            roomFlags |= 4;
        }
        return roomFlags;
    }
}

