/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.ui.rooms;

import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import open.batoru.core.Game;
import open.batoru.core.rooms.Room;
import open.batoru.replays.ReplayDataParser;
import open.batoru.replays.ReplayStartProcedure;
import open.batoru.replays.UtilReplays;
import open.batoru.ui.rooms.LiveGameEntry;

public class SavedGameEntry
extends LiveGameEntry {
    private final int gameId;

    public SavedGameEntry(ReplayDataParser parser, Room room) {
        super(room);
        this.gameId = parser.getGameId();
        HBox content = new HBox();
        content.setSpacing(5.0);
        Text textGameId = new Text("#" + this.gameId);
        Text textFileName = new Text(parser.getFileName());
        textFileName.getStyleClass().add((Object)(parser.getLastParseResult() == ReplayDataParser.ParseResult.SUCCESS ? "ui_rooms_panel_saved_list_entry_info_text" : "ui_rooms_panel_saved_list_entry_warn_text"));
        content.getChildren().addAll((Object[])new Node[]{textGameId, textFileName});
        StackPane.setAlignment((Node)content, (Pos)Pos.TOP_LEFT);
        this.getContent().getChildren().addFirst((Object)content);
        Text textVersion = new Text("(" + parser.getReplayVersionAsString() + ")");
        textVersion.getStyleClass().add((Object)((String)textFileName.getStyleClass().getFirst()));
        StackPane.setAlignment((Node)textVersion, (Pos)Pos.BOTTOM_RIGHT);
        this.getContent().getChildren().addFirst((Object)textVersion);
        this.getContent().getChildren().addFirst((Object)UtilReplays.createReplayEntryGradientBackground(parser.isWin()));
        room.getTurnCountProperty().set(parser.getTotalTurns());
        room.getPlayerData(Game.GamePlayerRole.HOST).getLRIGCenterImageProperty().set((Object)parser.getOwnCenterLRIGImageSet());
        room.getPlayerData(Game.GamePlayerRole.HOST).getLRIGAssistLeftImageProperty().set((Object)parser.getOwnAssistLeftLRIGImageSet());
        room.getPlayerData(Game.GamePlayerRole.HOST).getLRIGAssistRightImageProperty().set((Object)parser.getOwnAssistRightLRIGImageSet());
        room.getPlayerData(Game.GamePlayerRole.GUEST).getLRIGCenterImageProperty().set((Object)parser.getOPCenterLRIGImageSet());
        room.getPlayerData(Game.GamePlayerRole.GUEST).getLRIGAssistLeftImageProperty().set((Object)parser.getOPAssistLeftLRIGImageSet());
        room.getPlayerData(Game.GamePlayerRole.GUEST).getLRIGAssistRightImageProperty().set((Object)parser.getOPAssistRightLRIGImageSet());
        room.getPlayerData(Game.GamePlayerRole.HOST).getLifeClothCountProperty().set(parser.getOwnLifeClothCount());
        room.getPlayerData(Game.GamePlayerRole.GUEST).getLifeClothCountProperty().set(parser.getOPLifeClothCount());
        room.getPlayerData(Game.GamePlayerRole.HOST).getKeysImagesProperty().set((Object)parser.getOwnKeysImageSets());
        room.getPlayerData(Game.GamePlayerRole.GUEST).getKeysImagesProperty().set((Object)parser.getOPKeysImageSets());
        this.setOnMouseClicked(e -> {
            if (UtilReplays.canWatchGames()) {
                ReplayStartProcedure.play(parser);
            }
        });
        if (parser.getLastParseResult() != ReplayDataParser.ParseResult.SUCCESS) {
            this.setOpacity(0.5);
        }
        this.setOnMouseEntered(e -> {
            if (UtilReplays.canWatchGames()) {
                this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), true);
            }
        });
        this.setOnMouseExited(e -> this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"highlight"), false));
    }

    public int getGameId() {
        return this.gameId;
    }

    public static Room prepareFakeRoom(ReplayDataParser parser) {
        Room room = new Room(0, 0, parser.getPlayFormat(), Room.StartingPlayer.RANDOM, parser.getUsername());
        room.getPlayerData(Game.GamePlayerRole.GUEST).setPlayerName(parser.getUsernameOP());
        return room;
    }
}

