package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler.ChronoRecord;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.actions.override.OverrideAction.OverrideScope;
import open.batoru.core.gameplay.actions.override.OverrideActionList;
import open.batoru.core.gameplay.actions.override.OverrideActionList.OverrideFlag;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry.CardRuleCheckType;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.Cost;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition.ConditionState;
import open.batoru.data.ability.AbilityConst.UseLimit;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.events.EventPowerChanged;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.data.ability.modifiers.RuleCheckModifier;
import open.batoru.game.gfx.GFX;
import open.batoru.game.gfx.GFXCardShatter;
import open.batoru.game.gfx.GFXZoneTopCardDecorator;

public final class LRIG_K3_HanareMournerOfEmptyFortune extends Card {

    public LRIG_K3_HanareMournerOfEmptyFortune()
    {
        setImageSets("WX25-P3-032");

        setOriginalName("虚幸の冥者　ハナレ");
        setAltNames("キョコウノメイシャハナレ Kyokou no Meisha Hanare");
        setDescription("jp",
                "@U $TO $T2：あなたの＜毒牙＞のシグニの効果によって対戦相手のシグニ１体のパワーが減ったとき、以下の２つから１つを選ぶ。\n" +
                "$$1対戦相手は手札を１枚捨てる。\n" +
                "$$2対戦相手のエナゾーンにカードが２枚以上ある場合、対戦相手は自分のエナゾーンからカード１枚を選びトラッシュに置く。\n" +
                "@A $G1 @[@|ルミナス|@]@ %K0：このターン、次にアタックによって対戦相手のライフクロスの一番上のカードがクラッシュされる場合、チェックゾーンに置かれる代わりにトラッシュに置かれる。そのカードのライフバーストは発動しない。"
        );

        setName("en", "Hanare, Mourner of Empty Fortune");
        setDescription("en",
                "@U $TO $T2: When the power of 1 of your opponent's SIGNI is reduced by the effect of your <<Venom Fang>> SIGNI, @[@|choose 1 of the following:|@]@\n" +
                "$$1 Your opponent discards 1 card from their hand.\n" +
                "$$2 If there are 2 or more cards in your opponent's ener zone, your opponent chooses 1 card from their ener zone, and puts it into the trash.\n" +
                "@A $G1 @[@|Luminous|@]@ %K0: This turn, the next time your attack crushes the top card of your opponent's life cloth, put that card into the trash instead of the check zone. That card's ## @[Life Burst]@ doesn't activate."
        );

        setType(CardType.LRIG);
        setLRIGType(CardLRIGType.HANARE);
        setColor(CardColor.BLACK);
        setCost(Cost.color(CardColor.BLACK, 2));
        setLevel(3);
        setLimit(6);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            AutoAbility auto = registerAutoAbility(GameEventId.POWER_CHANGED, this::onAutoEff);
            auto.setCondition(this::onAutoEffCond);
            auto.setUseLimit(UseLimit.TURN, 2);

            ActionAbility act = registerActionAbility(new EnerCost(Cost.color(CardColor.BLACK, 0)), this::onActionEff);
            act.setUseLimit(UseLimit.GAME, 1);
            act.setName("Luminous");
        }

        private ConditionState onAutoEffCond(CardIndex caller)
        {
            return isOwnTurn() && !isOwnCard(caller) && getEvent().getSourceAbility() != null && EventPowerChanged.getDataAddedValue() < 0 &&
                   isOwnCard(getEvent().getSource()) && CardType.isSIGNI(getEvent().getSource().getCardReference().getType()) &&
                   getEvent().getSource().getSIGNIClass().matches(CardSIGNIClass.VENOM_FANG) ? ConditionState.OK : ConditionState.BAD;
        }
        private void onAutoEff(CardIndex caller)
        {
            if(playerChoiceMode() == 1)
            {
                discard(getOpponent(), 1);
            } else if(getEnerCount(getOpponent()) >= 2)
            {
                CardIndex cardIndex = playerTargetCard(getOpponent(), new TargetFilter(TargetHint.BURN).own().fromEner()).get();
                trash(cardIndex);
            }
        }
        
        private ChronoRecord record;
        private void onActionEff()
        {
            record = new ChronoRecord(ChronoDuration.turnEnd());
            ConstantAbility attachedConst = new ConstantAbility(new RuleCheckModifier<>(CardRuleCheckType.ACTION_OVERRIDE, data ->
                new OverrideAction(GameEventId.CRUSH, OverrideScope.GLOBAL, OverrideFlag.MANDATORY | OverrideFlag.PRESERVE_SOURCES, this::onActionEffRuleCheckOverrideCond, this::onActionEffRuleCheckOverrideHandler)
            ));
            GFX.attachToAbility(attachedConst, new GFXZoneTopCardDecorator(getOpponent(), CardLocation.LIFE_CLOTH, cardIndex -> new GFXCardShatter(cardIndex, 10)));
            attachPlayerAbility(getOwner(), attachedConst, record);
        }
        private boolean onActionEffRuleCheckOverrideCond(CardIndex cardIndex, GameEvent event, Ability sourceAbilityRC)
        {
            return !isOwnCard(event.getCaller()) && event.getSourceAbility() == null && isOwnCard(event.getSource());
        }
        private void onActionEffRuleCheckOverrideHandler(OverrideActionList list, Ability sourceAbilityRC)
        {
            list.addAction(new ActionTrash(list.getSourceEvent().getCallerCardIndex()));
            record.forceExpire();
        }
    }
}

