package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.GameConst.CardUnderType;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst.ActionHint;
import open.batoru.data.ability.AbilityConst.UseLimit;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.modifiers.AbilityGainModifier;

public final class LRIG_R1_ExOne extends Card {
    
    public LRIG_R1_ExOne()
    {
        setImageSets("WXDi-D07-002");
        
        setOriginalName("エクス・ワン");
        setAltNames("エクスワン Ekusu Wan");
        setDescription("jp",
                "@C：このカードが[[ソウル]]として付いているシグニは@>@U $T1：このシグニがアタックしたとき、カードを１枚引くか[[エナチャージ１]]をする。@@を得る。"
        );
        
        setName("en", "Ex One");
        setDescription("en",
                "@C: The SIGNI with this card attached to it as a [[Soul]] gains@>@U $T1: When this SIGNI attacks, draw a card or [[Ener Charge 1]]."
        );
        
        setName("en_fan", "Ex One");
        setDescription("en_fan",
                "@C: The SIGNI attached with this card as a [[Soul]] gains:" +
                "@>@U $T1: When this SIGNI attacks, draw 1 card or [[Ener Charge 1]]."
        );

        setName("zh_simplified", "艾克斯·壹");
        setDescription("zh_simplified", 
                "@C :被这张牌作为[[灵魂]]附加的精灵得到" +
                "@>@U $T1 :当这只精灵攻击时，抽1张牌或[[能量填充1]]。@@"
        );
        
        setType(CardType.LRIG);
        setLRIGType(CardLRIGType.EX);
        setLRIGTeam(CardLRIGTeam.DEUS_EX_MACHINA);
        setColor(CardColor.RED);
        setLevel(1);
        setLimit(2);
        
        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH, PlayFormat.CHINESE);
    }
    
    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            ConstantAbility cont = registerConstantAbility(new TargetFilter().SIGNI().over(cardId), new AbilityGainModifier(this::onConstEffModGetSample));
            cont.setActiveLocation(CardLocation.SIGNI_LEFT,CardLocation.SIGNI_CENTER,CardLocation.SIGNI_RIGHT, CardLocation.CHEER);
            cont.setActiveUnderFlags(CardUnderType.ATTACHED_SOUL);
        }
        
        private Ability onConstEffModGetSample(CardIndex cardIndex)
        {
            AutoAbility attachedAuto = cardIndex.getIndexedInstance().registerAutoAbility(GameEventId.ATTACK, this::onAttachedAutoEff);
            attachedAuto.setUseLimit(UseLimit.TURN, 1);
            
            return attachedAuto;
        }
        private void onAttachedAutoEff()
        {
            if(playerChoiceAction(ActionHint.DRAW, ActionHint.ENER) == 1)
            {
                draw(1);
            } else {
                enerCharge(1);
            }
        }
    }
}
