package open.batoru.data.cards;

import open.batoru.data.Card;
import open.batoru.data.CardConst.CardColor;
import open.batoru.data.CardConst.CardLRIGType;
import open.batoru.data.CardConst.CardType;
import open.batoru.data.CardConst.PlayFormat;
import open.batoru.data.Cost;
import open.batoru.data.ability.stock.StockAbilityRide;

public final class LRIG_R2_LaylaCurve extends Card {
    
    public LRIG_R2_LaylaCurve()
    {
        setImageSets("WXK01-009");
        
        setOriginalName("レイラ＝カーブ");
        setAltNames("レイラカーブ Reira Kaabu");
        setDescription("jp",
                "=I"
        );
        
        setName("en", "Layla-Curve");
        setDescription("en",
                "=I"
        );

        setName("es", "Layla =Curve=");
        setDescription("es",
                "=I"
        );

        setName("zh_simplified", "蕾拉=弯道");
        setDescription("zh_simplified", 
                "[[骑乘]]（直到回合结束时为止，这只分身在对象的你的<<乘机>>精灵1只搭乘。此是费用%R0的@A能力，$T1 ，这只分身不是驾驶状态的场合能使用。）"
        );
        
        setLRIGType(CardLRIGType.LAYLA);
        setType(CardType.LRIG);
        setColor(CardColor.RED);
        setCost(Cost.color(CardColor.RED, 1));
        setLevel(2);
        setLimit(5);
        
        setPlayFormat(PlayFormat.KEY);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            registerStockAbility(new StockAbilityRide());
        }
    }
}
