package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.GameConst.GamePhase;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.Cost;
import open.batoru.data.ability.AbilityCondition.ConditionState;
import open.batoru.data.ability.AbilityConst.UseLimit;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.cost.DiscardCost;
import open.batoru.data.ability.cost.DownCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.cost.TrashCost;

public final class LRIG_R3_HiranaOneStepTowardsHeavensBow extends Card {

    public LRIG_R3_HiranaOneStepTowardsHeavensBow()
    {
        setImageSets("WX25-P3-019");

        setOriginalName("天弓へ一歩　ヒラナ");
        setAltNames("テンキョウヘイッポヒラナ Oute he Ippo Hirana");
        setDescription("jp",
                "@U：あなたのアタックフェイズ開始時、あなたのアップ状態の＜天使＞のシグニ２体をダウンし%Rを支払ってもよい。そうした場合、ターン終了時まで、このルリグは@>@U $T1：このルリグがアタックしたとき、対戦相手が自分のルリグデッキからカード１枚をルリグトラッシュに置かなければならない。そうしなければ、対戦相手にダメージを与える。@@を得る。\n" +
                "@A $G1 @[@|行こう、てっぺん！|@]@ @[エナゾーンにあるすべてのカードをトラッシュに置き、手札をすべて捨てる]@：カードを３枚引き【エナチャージ３】をする。"
        );

        setName("en", "Hirana, One Step Towards Heaven's Bow");
        setDescription("en",
                "@U: At the beginning of your attack phase, you may down 2 of your upped <<Angel>> SIGNI and pay %R. If you do, until end of turn, this LRIG gains:" +
                "@>@U $T1: When this LRIG attacks, damage your opponent unless they put 1 card from their LRIG deck into the trash.@@" +
                "@A $G1 @[@|Let's go, to the top!|@]@ @[Put all cards from your ener zone into the trash, and discard all cards from your hand]@: Draw 3 cards, and [[Ener Charge 3]]."
        );

        setType(CardType.LRIG);
        setLRIGTeam(CardLRIGTeam.NO_LIMIT);
        setLRIGType(CardLRIGType.HIRANA);
        setColor(CardColor.RED);
        setCost(Cost.color(CardColor.RED, 2));
        setLevel(3);
        setLimit(6);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            AutoAbility auto = registerAutoAbility(GameEventId.PHASE_START, this::onAutoEff);
            auto.setCondition(this::onAutoEffCond);
            
            ActionAbility act = registerActionAbility(new AbilityCostList(
                new TrashCost(() -> getEnerCount(getOwner()), new TargetFilter().own().fromEner()),
                new DiscardCost(() -> getHandCount(getOwner()))
            ), this::onActionEff);
            act.setUseLimit(UseLimit.GAME, 1);
            act.setName("Teppen");
        }
        
        private ConditionState onAutoEffCond()
        {
            return isOwnTurn() && getCurrentPhase() == GamePhase.ATTACK_PRE ? ConditionState.OK : ConditionState.BAD;
        }
        private void onAutoEff(CardIndex caller)
        {
            if(payAll(new DownCost(2, new TargetFilter().SIGNI().withClass(CardSIGNIClass.ANGEL)), new EnerCost(Cost.color(CardColor.RED, 1))))
            {
                AutoAbility attachedAuto = new AutoAbility(GameEventId.ATTACK, this::onAttachedAutoEff);
                attachedAuto.setUseLimit(UseLimit.TURN, 1);
                
                attachAbility(getCardIndex(), attachedAuto, ChronoDuration.turnEnd());
            }
        }
        private void onAttachedAutoEff()
        {
            CardIndex cardIndex = playerTargetCard(getOpponent(), 0,1, new TargetFilter(TargetHint.TRASH).own().fromLocation(CardLocation.DECK_LRIG).anyCard()).get();
            
            if(!trash(cardIndex))
            {
                damage(getOpponent());
            }
        }
        
        private void onActionEff()
        {
            draw(3);
            enerCharge(3);
        }
    }
}

