package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.Cost;
import open.batoru.data.ability.AbilityConst.Enter;
import open.batoru.data.ability.AbilityConst.UseLimit;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.AbilityCondition.ConditionState;
import open.batoru.data.ability.CardAbilities;
import open.batoru.data.ability.PieceAbility;

public final class PIECE_W_SparklingMemories extends Card {
    
    public PIECE_W_SparklingMemories()
    {
        setImageSets("WXDi-P07-001");
        
        setOriginalName("キラキラ☆メモリーズ");
        setAltNames("キラキラメモリーズ Kirakira Memoriizu");
        setDescription("jp",
                "=U =E 合計３種類以上の色を持つ\n\n" +
                "あなたのレベル３のルリグ１体を対象とし、ターン終了時まで、それは以下の能力を得る。" +
                "@>@U $T1：このルリグがアタックしたとき、対戦相手のライフクロス１枚を手札に加えさせる。その後、あなたの手札からシグニを１枚まで場に出す。そのシグニの@E能力は発動しない。"
        );
        
        setName("en", "Sparkling☆Memories");
        setDescription("en",
                "=U =E You have the three LRIG on your field with three or more different colors among all members.\n\n" +
                "Target level three LRIG on your field gains the following ability until end of turn." +
                "@>@U $T1: When this LRIG attacks, add one of your opponent's Life Cloth to their hand. Then, put up to one SIGNI from your hand onto your field. The @E abilities of SIGNI put onto your field this way do not activate."
        );

        setName("es", "Memorias☆Brillantes");
        setDescription("es",
                "=U =E Tienes 3 LRIG de 3 colores distintos en tu campo.\n\n" +
                "Selecciona 1 LRIG propia de nivel 3 en tu campo y hasta el final del turno, esta gana:" +
                "@>@U $T1: Siempre que esta LRIG ataque, tu oponente devuelve 1 de sus Life Cloth a su mano. Entonces, pon hasta 1 SIGNi de tu mano al campo. Sus habilidades @E no se activan."
        );
        
        setName("en_fan", "Sparkling Memories");
        setDescription("en_fan",
                "=U =E with 3 or more colors among them\n\n" +
                "Target 1 of your level 3 LRIG, and until end of turn, it gains:" +
                "@>@U $T1: Whenever this LRIG attacks, your opponent returns 1 of their life cloth to their hand. Then, put up to 1 SIGNI from your hand onto the field. Its @E abilities don't activate."
        );

        setName("zh_simplified", "闪闪☆追想");
        setDescription("zh_simplified", 
                "=U=E持有合计3种类以上的颜色（你的场上的分身3只把这个条件满足）\n" +
                "你的等级3的分身1只作为对象，直到回合结束时为止，其得到以下的能力。" +
                "@>@U $T1 :当这只分身攻击时，对战对手的生命护甲1张加入手牌。然后，从你的手牌把精灵1张最多出场。那只精灵的@E能力不能发动。@@"
        );
        
        setType(CardType.PIECE);
        setLRIGTeam(CardLRIGTeam.DREAM_TEAM);
        setColor(CardColor.WHITE);
        setCost(Cost.color(CardColor.WHITE, 1) + Cost.colorless(2));
        setUseTiming(UseTiming.MAIN);
        
        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH, PlayFormat.CHINESE);
    }
    
    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        private final PieceAbility piece;
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            piece = registerPieceAbility(this::onPieceEffPreTarget, this::onPieceEff);
            piece.setCondition(this::onPieceEffCond);
        }
        
        private ConditionState onPieceEffCond()
        {
            if(CardAbilities.getColorsCount(getLRIGs(getOwner())) < 3) return ConditionState.BAD;
            
            return new TargetFilter().own().LRIG().withLevel(3).getValidTargetsCount() > 0 ? ConditionState.OK : ConditionState.WARN;
        }
        private void onPieceEffPreTarget()
        {
            piece.setTargets(playerTargetCard(new TargetFilter().own().LRIG().withLevel(3)));
        }
        private void onPieceEff()
        {
            if(piece.getTarget() != null)
            {
                AutoAbility attachedAuto = new AutoAbility(GameEventId.ATTACK, this::onAttachedAutoEff);
                attachedAuto.setUseLimit(UseLimit.TURN, 1);
                
                attachAbility(piece.getTarget(), attachedAuto, ChronoDuration.turnEnd());
            }
        }
        private void onAttachedAutoEff()
        {
            addToHand(getOpponent(), CardLocation.LIFE_CLOTH);
            
            CardIndex cardIndex = playerTargetCard(0,1, new TargetFilter(TargetHint.FIELD).own().SIGNI().fromHand().playable()).get();
            putOnField(cardIndex, Enter.DONT_ACTIVATE);
        }
    }
}
