package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.ability.AbilityConst.UseLimit;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.cost.DiscardCost;
import open.batoru.data.ability.stock.StockPlayerAbilityMikomikoBodyguard;

public final class SIGNI_B3_MDeathscytheNaturalBacteriaPrincess extends Card {

    public SIGNI_B3_MDeathscytheNaturalBacteriaPrincess()
    {
        setImageSets("WX25-P3-058");
        setLinkedImageSets(Token_MikomikoBodyguard.IMAGE_SET, "WX25-P3-023");

        setOriginalName("羅菌姫　Mデスサイズ");
        setAltNames("ラキンヒメエムデスサイズ Rakinhime Emu Desusaizu");
        setDescription("jp",
                "@U：このシグニがアタックしたとき、対戦相手のシグニ１体を対象とし、対戦相手の【みこみこ親衛隊】を好きな数取り除いてもよい。ターン終了時まで、それのパワーをこの方法で取り除いた【みこみこ親衛隊】１つにつき－8000する。\n" +
                "@A $T2 @[手札から＜微菌＞のシグニを１枚捨てる]@：あなたの場に《みこみこ☆さんさんおせおせ》がいる場合、対戦相手は【みこみこ親衛隊】１つを得る。"
        );

        setName("en", "M Deathscythe, Natural Bacteria Princess");
        setDescription("en",
                "@U: Whenever this SIGNI attacks, target 1 of your opponent's SIGNI, and you may remove any number of [[Mikomiko Bodyguard]] from your opponent's field. Until end of turn, it gets --8000 power for each [[Mikomiko Bodyguard]] removed this way.\n" +
                "@A $T2 @[Discard 1 <<Bacteria>> SIGNI from your hand]@: If your LRIG is \"Mikomiko☆Three Three Stan Stan\", your opponent gains 1 [[Mikomiko Bodyguard]]."
        );

        setType(CardType.SIGNI);
        setColor(CardColor.BLUE);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.BACTERIA);
        setLevel(3);
        setPower(10000);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            registerAutoAbility(GameEventId.ATTACK, this::onAutoEff);

            ActionAbility act = registerActionAbility(new DiscardCost(new TargetFilter().SIGNI().withClass(CardSIGNIClass.BACTERIA)), this::onActionEff);
            act.setUseLimit(UseLimit.TURN, 2);
        }
        
        private void onAutoEff()
        {
            CardIndex target = playerTargetCard(new TargetFilter(TargetHint.MINUS).OP().SIGNI()).get();
            
            if(target != null)
            {
                int count = playerChoiceRemoveTokens(StockPlayerAbilityMikomikoBodyguard.class, getOpponent());
                gainPower(target, -8000 * count, ChronoDuration.turnEnd());
            }
        }

        private void onActionEff()
        {
            if(getLRIG(getOwner()).getIndexedInstance().getName().getValue().contains("みこみこ☆さんさんおせおせ"))
            {
                attachPlayerAbility(getOpponent(), new StockPlayerAbilityMikomikoBodyguard(), ChronoDuration.permanent());
            }
        }
    }
}
