package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;

public final class SIGNI_G2_AmazonesVerdantGeneral extends Card {
    
    public SIGNI_G2_AmazonesVerdantGeneral()
    {
        setImageSets("WXDi-D04-014");
        
        setOriginalName("翠将　アマゾネス");
        setAltNames("スイショウアマゾネス Suishou Amazonesu");
        setDescription("jp",
                "~#：対戦相手のパワー7000以上のシグニ１体を対象とし、それをバニッシュする。"
        );
        
        setName("en", "Amazoness, Jade General");
        setDescription("en",
                "~#Vanish target SIGNI on your opponent's field with power 7000 or more."
        );

        setName("es", "Amazona, general esmeralda");
        setDescription("es",
                "~#Selecciona 1 SIGNI oponente con 7000 o menos poder y desvánecela."
        );
        
        setName("en_fan", "Amazones, Verdant General");
        setDescription("en_fan",
                "~#Target 1 of your opponent's SIGNI with power 7000 or more, and banish it."
        );

        setName("zh_simplified", "翠将 亚马逊");
        setDescription("zh_simplified", 
                "~#对战对手的力量7000以上的精灵1只作为对象，将其破坏。"
        );
        
        setCardFlags(CardFlag.LIFEBURST);
        
        setType(CardType.SIGNI);
        setColor(CardColor.GREEN);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.VALOR);
        setLevel(2);
        setPower(10000);
        
        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH, PlayFormat.CHINESE);
    }
    
    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            registerLifeBurstAbility(this::onLifeBurstEff);
        }
        
        private void onLifeBurstEff()
        {
            CardIndex target = playerTargetCard(new TargetFilter(TargetHint.BANISH).OP().SIGNI().withPower(7000,0)).get();
            banish(target);
        }
    }
}
