package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.data.DataTable;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.ability.stock.StockAbilityCantAttack;

public final class SIGNI_W2_CodeArtARmlight extends Card {
    
    public SIGNI_W2_CodeArtARmlight()
    {
        setImageSets("WXDi-P03-051");
        
        setOriginalName("コードアート　Ａムライト");
        setAltNames("コードアートエームライト Koodo Aato Ee Muraito Armlight Arm light");
        setDescription("jp",
                "~#：対戦相手のシグニを２体まで対象とし、ターン終了時まで、それらは@>@C@#：アタックできない。@@@@を得る。カードを１枚引く。"
        );
        
        setName("en", "R-Mlight, Code: Art");
        setDescription("en",
                "~#Up to two target SIGNI on your opponent's field gain@>@C@#: This SIGNI cannot attack.@@@@until end of turn. Draw a card."
        );
        
        setName("en_fan", "Code Art A Rmlight");
        setDescription("en_fan",
                "~#Target up to 2 of your opponent's SIGNI, and until end of turn, they gain:" +
                "@>@C@#: Can't attack.@@@@" +
                "Draw 1 card."
        );

        setName("zh_simplified", "必杀代号 长臂台灯");
        setDescription("zh_simplified", 
                "~#对战对手的精灵2只最多作为对象，直到回合结束时为止，这些得到" +
                "@>@C@# :不能攻击。@@@@" +
                "。抽1张牌。"
        );
        
        setCardFlags(CardFlag.LIFEBURST);
        
        setType(CardType.SIGNI);
        setColor(CardColor.WHITE);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.ELECTRIC_MACHINE);
        setLevel(2);
        setPower(10000);
        
        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH, PlayFormat.CHINESE);
    }
    
    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);
            
            registerLifeBurstAbility(this::onLifeBurstEff);
        }
        
        private void onLifeBurstEff()
        {
            DataTable<CardIndex> data = playerTargetCard(0,2, new TargetFilter(TargetHint.ABILITY).OP().SIGNI());
            if(data.get() != null) for(int i=0;i<data.size();i++) attachAbility(data.get(i), new StockAbilityCantAttack(), ChronoDuration.turnEnd());
            
            draw(1);
        }
    }
}
