package open.batoru.data.cards;

import open.batoru.core.Deck.DeckPosition;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.GameConst.CardLocation;
import open.batoru.core.gameplay.GameConst.CardUnderType;
import open.batoru.core.gameplay.GameConst.GameEventId;
import open.batoru.core.gameplay.GameConst.GamePhase;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.*;
import open.batoru.data.Cost;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition.ConditionState;
import open.batoru.data.ability.AbilityConst.AbilityGain;
import open.batoru.data.ability.AbilityConst.ActionHint;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.modifiers.AbilityGainModifier;
import open.batoru.data.ability.modifiers.PowerModifier;

public final class SIGNI_W2_CodeRideMachinaTHEDOOR extends Card {

    public SIGNI_W2_CodeRideMachinaTHEDOOR()
    {
        setImageSets("WXDi-P16-062");

        setOriginalName("コードライド　マキナ//THE DOOR");
        setAltNames("コードライドマキナザドアー Koodo Raido Makina Za Doaa");
        setDescription("jp",
                "@C：このシグニは同じシグニゾーンに【ゲート】があるかぎり、@>@U：各アタックフェイズ開始時、対戦相手のシグニ１体を対象とし、対戦相手が%Xを支払わないかぎり、ターン終了時まで、それは能力を失う。@@を得る。\n" +
                "@C：同じシグニゾーンに【ゲート】があるあなたのシグニのパワーを＋2000する。" +
                "~#：あなたのデッキの上からカードを３枚見る。その中からシグニ１枚を公開し手札に加えるか場に出し、残りを好きな順番でデッキの一番下に置く。"
        );

        setName("en", "Machina//THE DOOR, Code: Ride");
        setDescription("en",
                "@C: As long as this SIGNI is in the same SIGNI Zone as a [[Gate]], it gains@>@U: At the beginning of each attack phase, target SIGNI on your opponent's field loses its abilities until end of turn unless your opponent pays %X.@@@C: SIGNI on your field in the same SIGNI Zone as a [[Gate]] get +2000 power." +
                "~#Look at the top three cards of your deck. Reveal a SIGNI from among them and add it to your hand or put it onto your field. Put the rest on the bottom of your deck in any order."
        );

        setName("es", "Code Ride Machina//THE DOOR");
        setDescription("es",
                "@C: Mientras esta SIGNI este en una zona SIGNI con [[Gate]], esta gana:" +
                "@>@U: Al inicio de cada fase de ataque, selecciona 1 SIGNI oponente y hasta el final del turno, esta pierde todas sus habilidades a menos que tu oponente pague %X.@@" +
                "@C: Todas tus SIGNI en zonas SIGNI con <<Gate>> ganan +2000 poder." +
                "~#Mira 3 cartas del tope de tu mazo. Revela 1 SIGNI de entre ellas y agregala a tu mano o ponla en el campo, pon las demas cartas en el fondo de tu mazo en cualquier orden."
        );
        
        setName("en_fan", "Code Ride Machina//THE DOOR");
        setDescription("en_fan",
                "@C: As long as this SIGNI is on a SIGNI zone with a [[Gate]], it gains:" +
                "@>@U: At the beginning of each attack phase, target 1 of your opponent's SIGNI, and until end of turn, it loses its abilities unless your opponent pays %X.@@" +
                "@C: All of your SIGNI on SIGNI zones with a [[Gate]] get +2000 power." +
                "~#Look at the top 3 cards of your deck. Reveal 1 SIGNI from among them, and add it to your hand or put it onto the field, and put the rest on the bottom of your deck in any order."
        );

        setName("zh_simplified", "骑乘代号 玛琪娜//THE DOOR");
        setDescription("zh_simplified", 
                "@C :这只精灵的相同精灵区有[[大门]]时，得到" +
                "@>@U :各攻击阶段开始时，对战对手的精灵1只作为对象，如果对战对手不把%X支付，那么直到回合结束时为止，其的能力失去。@@" +
                "@C :相同精灵区有[[大门]]的你的精灵的力量+2000。" +
                "~#从你的牌组上面看3张牌。从中把精灵1张公开加入手牌或出场，剩下的任意顺序放置到牌组最下面。"
        );

        setCardFlags(CardFlag.LIFEBURST);

        setType(CardType.SIGNI);
        setColor(CardColor.WHITE);
        setSIGNIClass(CardSIGNIClassGeneration.PERFORMER, CardSIGNIClass.DEFENSE_FACTION,CardSIGNIClass.RIDING_MACHINE);
        setLevel(2);
        setPower(8000);

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA, PlayFormat.ENGLISH);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            registerConstantAbility(this::onConstEff1Cond, new AbilityGainModifier(this::onConstEff1ModGetSample));
            registerConstantAbility(new TargetFilter().own().SIGNI().withZoneObject(CardUnderType.ZONE_GATE), new PowerModifier(2000));
            
            registerLifeBurstAbility(this::onLifeBurstEff);
        }

        private ConditionState onConstEff1Cond()
        {
            return hasZoneObject(CardUnderType.ZONE_GATE) ? ConditionState.OK : ConditionState.BAD;
        }
        private Ability onConstEff1ModGetSample(CardIndex cardIndex)
        {
            AutoAbility attachedAuto = cardIndex.getIndexedInstance().registerAutoAbility(GameEventId.PHASE_START, this::onAttachedAutoEff);
            attachedAuto.setCondition(this::onAttachedAutoEffCond);
            return attachedAuto;
        }
        private ConditionState onAttachedAutoEffCond()
        {
            return getCurrentPhase() == GamePhase.ATTACK_PRE ? ConditionState.OK : ConditionState.BAD;
        }
        private void onAttachedAutoEff(CardIndex caller)
        {
            CardIndex target = playerTargetCard(new TargetFilter(TargetHint.MUTE).OP().SIGNI()).get();
            
            if(target != null && !payEner(getOpponent(), Cost.colorless(1)))
            {
                disableAllAbilities(target, AbilityGain.ALLOW, ChronoDuration.turnEnd());
            }
        }

        private void onLifeBurstEff()
        {
            look(3);

            CardIndex cardIndex = playerTargetCard(0,1, new TargetFilter().own().SIGNI().fromLooked()).get();
            if(reveal(cardIndex))
            {
                if(playerChoiceAction(ActionHint.HAND, ActionHint.FIELD) == 1 || !putOnField(cardIndex))
                {
                    addToHand(cardIndex);
                }
            }

            returnToDeckOrdered(CardLocation.LOOKED, DeckPosition.BOTTOM);
        }
    }
}
