package open.batoru.data.cards;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.pickers.TargetFilter.TargetHint;
import open.batoru.data.Card;
import open.batoru.data.CardConst.CardColor;
import open.batoru.data.CardConst.CardFlag;
import open.batoru.data.CardConst.CardType;
import open.batoru.data.CardConst.PlayFormat;
import open.batoru.data.Cost;
import open.batoru.data.ability.AbilityConst.ActionHint;

public final class SPELL_G_BudOpening extends Card {

    public SPELL_G_BudOpening()
    {
        setImageSets("WX24-D4-25");

        setOriginalName("芽吹");
        setAltNames("メブキ Mebuki");
        setDescription("jp",
                "【エナチャージ２】をする。&E５枚以上@0その後、追加であなたのエナゾーンから緑のシグニを１枚まで対象とし、それを場に出す。" +
                "~#：【エナチャージ１】をする。その後、あなたのエナゾーンからシグニを１枚まで対象とし、それを手札に加えるか場に出す。"
        );

        setName("en", "Bud Opening");
        setDescription("en",
                "[[Ener Charge 2]]. &E5 or more@0 Then, additionally target up to 1 green SIGNI from your ener zone, and put it onto the field." +
                "~#[[Ener Charge 1]]. Then, target up to 1 SIGNI from your ener zone, and add it to your hand or put it onto the field."
        );

        setName("es", "Apertura de Brotes");
        setDescription("es",
                "[[Ener Charge 2]]. &E5 o mas@0 Entonces, adicionalmente selecciona hasta 1 SIGNi verde de tu zona ener y ponla en el campo." +
                "~#[[Ener Charge 1]]. Entonces, selecciona hasta 1 SIGNi de tu zona ener y añadela a tu mano o ponla en el camp."
        );

        setName("zh_simplified", "芽吹");
        setDescription("zh_simplified", 
                "[[能量填充2]]。&E5张以上@0然后，追加从你的能量区把绿色的精灵1张最多作为对象，将其出场。" +
                "~#[[能量填充1]]。然后，从你的能量区把精灵1张最多作为对象，将其加入手牌或出场。"
        );

        setCardFlags(CardFlag.LIFEBURST);

        setType(CardType.SPELL);
        setColor(CardColor.GREEN);
        setCost(Cost.color(CardColor.GREEN, 1));

        setPlayFormat(PlayFormat.KEY, PlayFormat.DIVA);
    }

    @Override
    public IndexedInstance newIndexedInstance(int cardId) { return new IndexedInstance(cardId); }
    public class IndexedInstance extends Card.IndexedInstance
    {
        public IndexedInstance(int cardId)
        {
            super(cardId);

            registerSpellAbility(this::onSpellEff).setRecollect(5);

            registerLifeBurstAbility(this::onLifeBurstEff);
        }

        private void onSpellEff()
        {
            enerCharge(2);
            if(getAbility().isRecollectFulfilled())
            {
                CardIndex target = playerTargetCard(0,1, new TargetFilter(TargetHint.FIELD).own().SIGNI().withColor(CardColor.GREEN).fromEner().playable()).get();
                putOnField(target);
            }
        }

        private void onLifeBurstEff()
        {
            enerCharge(1);
            
            CardIndex target = playerTargetCard(0,1, new TargetFilter().own().SIGNI().fromEner()).get();
            if(target != null)
            {
                if(playerChoiceAction(ActionHint.HAND, ActionHint.FIELD) == 1 || !putOnField(target))
                {
                    addToHand(target);
                }
            }
        }
    }
}
