/*
 * Decompiled with CFR 0.152.
 */
package open.batoru;

import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import open.batoru.Log;
import open.batoru.Settings;
import open.batoru.core.Player;
import open.batoru.data.CardLoader;
import open.batoru.networking.LogoutProcedure;
import open.batoru.parsers.BadgesParser;
import open.batoru.parsers.CardSetsParser;
import open.batoru.parsers.RestrictedCardsParser;
import open.batoru.parsers.UnreleasedCardsParser;
import open.batoru.ui.ThemeController;
import open.batoru.ui.UI;

public class Main
extends Application {
    private static Stage stage;
    public static int testPort;

    public void start(Stage primaryStage) {
        Settings.INSTANCE.init();
        CardLoader.load();
        CardSetsParser.load();
        RestrictedCardsParser.load();
        UnreleasedCardsParser.load();
        Settings.INSTANCE.loadDeckCards(Settings.DeckSource.EDIT);
        BadgesParser.load();
        UI.init();
        Scene scene = new Scene((Parent)UI.getRoot(), 1152.0, 768.0);
        stage = primaryStage;
        Main.updateWindowTitle("");
        primaryStage.setScene(scene);
        ThemeController.loadDefaultTheme();
        ThemeController.applyTheme(Settings.INSTANCE.isUsingDarkTheme());
        primaryStage.show();
        UI.getTabDeck().getDeckBuilder().initCards();
        if (testPort > 0) {
            System.out.println("test mode: client port +" + testPort);
        }
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            StringBuilder message = new StringBuilder("Exception in thread \"" + t.getName() + "\" " + String.valueOf(e));
            for (StackTraceElement element : e.getStackTrace()) {
                message.append("\n\tat ").append(element);
            }
            Log.printMessage(true, message.toString());
        });
    }

    public void stop() throws Exception {
        LogoutProcedure.execute();
        super.stop();
    }

    public static void updateWindowTitle(String info) {
        if (stage == null) {
            return;
        }
        stage.setTitle("Open!batoru " + Settings.INSTANCE.getGameVersionClient() + (String)(Player.getUsername() == null ? " " : " [" + Player.getUsername() + "] ") + info);
    }

    public static Stage getStage() {
        return stage;
    }

    public static void main(String[] args) {
        testPort = args.length * 100;
        Main.launch((String[])args);
    }

    static {
        testPort = 0;
    }
}

