/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.catalog;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import open.batoru.UtilRandom;
import open.batoru.data.Card;
import open.batoru.data.CardLoader;

public class CardSorter {
    private static final long UNIQUE_SEED = UtilRandom.generateRandomSeed();

    public static void sortByName(List<Card> sortingList) {
        sortingList.sort(Comparator.comparing(Card::getName));
    }

    public static void sortByImageSet(String imageSetBias, List<Card> sortingList) {
        sortingList.sort(Comparator.comparing(card -> card.getImageSets().getImageSetByPrefixBias(imageSetBias)));
    }

    public static void sortByUniqueRandom(List<Card> sortingList) {
        Collections.shuffle(sortingList, new Random(UNIQUE_SEED));
    }

    public static void sortDeck(List<String> deckArray) {
        deckArray.sort((is1, is2) -> {
            Card c1 = CardLoader.getCardByImageSet(is1);
            Card c2 = CardLoader.getCardByImageSet(is2);
            if (c1.getType() == c2.getType()) {
                if (c1.getLevel() == c2.getLevel()) {
                    if (Objects.equals(c1.getPower(), c2.getPower())) {
                        if (c1.getName().equals(c2.getName())) {
                            return is1.compareTo((String)is2);
                        }
                        return c1.getName().compareTo(c2.getName());
                    }
                    return c1.getPower().compareTo(c2.getPower());
                }
                return c2.getLevel() - c1.getLevel();
            }
            return c1.getType().compareTo(c2.getType());
        });
    }
}

