/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataColor;
import open.batoru.data.CardDataLRIGType;
import open.batoru.data.CardDataSIGNIClass;
import open.batoru.data.Cost;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ModifiableString;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.CoinCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UIConst;

public class UtilCardDataFormatter {
    public static String formatType(CardConst.CardType cardType) {
        return LanguageParser.getString("CARD_INFO_BRACKET_1L") + cardType.getLabel() + LanguageParser.getString("CARD_INFO_BRACKET_1R");
    }

    public static String formatLevel(int cardLevel) {
        return LanguageParser.getString("CARD_INFO_LEVEL") + " " + cardLevel;
    }

    public static String formatPower(double cardPower) {
        return LanguageParser.getString("CARD_INFO_POWER") + " " + (cardPower != Double.POSITIVE_INFINITY ? String.format("%.0f", cardPower) : "\u221e");
    }

    public static String formatCoins(int cardCoins) {
        return LanguageParser.getString("CARD_INFO_COINS") + " +" + cardCoins;
    }

    public static String formatCost(int cardCost) {
        return LanguageParser.getString("CARD_INFO_COST") + " " + cardCost;
    }

    public static String formatLimit(double cardLimit, boolean showSign) {
        return LanguageParser.getString("CARD_INFO_LIMIT") + " " + (String)(cardLimit != Double.POSITIVE_INFINITY ? (!showSign ? "" : "+") + String.format("%.0f", cardLimit) : "\u221e");
    }

    public static String formatColor(CardDataColor dataCardColor) {
        int i;
        Object value = dataCardColor.getValue();
        CardConst.CardColor primaryColor = dataCardColor.getPrimaryValue();
        ArrayList<String> extraColorsText = new ArrayList<String>();
        StringBuilder stringColor = new StringBuilder();
        if (primaryColor != CardConst.CardColor.COLORLESS || value.size() == 1) {
            stringColor.append(primaryColor.getLabel());
            extraColorsText.add(stringColor.toString());
        }
        block4: for (i = 1; i < value.size(); ++i) {
            CardConst.CardColor color = (CardConst.CardColor)((Object)value.get(i));
            if (stringColor.isEmpty()) {
                stringColor.append(color.getLabel());
            }
            switch (extraColorsText.size()) {
                case 1: {
                    extraColorsText.add(color.getLabel());
                    continue block4;
                }
                case 2: {
                    stringColor = new StringBuilder(primaryColor.getLabel().length() > 1 ? primaryColor.getDisplayShortLabel() : primaryColor.getLabel());
                    extraColorsText.set(1, ((CardConst.CardColor)((Object)value.get(1))).getDisplayShortLabel());
                }
                default: {
                    extraColorsText.add(color.getLabel().length() > 1 ? color.getDisplayShortLabel() : color.getLabel());
                }
            }
        }
        for (i = 1; i < extraColorsText.size(); ++i) {
            stringColor.append(" / ").append((String)extraColorsText.get(i));
        }
        return stringColor.toString();
    }

    public static String formatLRIGType(CardDataLRIGType dataCardLRIGType, boolean isLimitedText) {
        CardConst.CardLRIGType primaryLRIGType = dataCardLRIGType.getPrimaryValue();
        if (primaryLRIGType == CardConst.CardLRIGType.NO_LRIG_LIMIT) {
            return "";
        }
        StringBuilder stringLRIGType = new StringBuilder(LanguageParser.getString("CARD_INFO_BRACKET_2L") + primaryLRIGType.getLabel());
        for (CardConst.CardLRIGType cardLRIGType : CardConst.CardLRIGType.values()) {
            if (!dataCardLRIGType.matches(cardLRIGType) || cardLRIGType == primaryLRIGType) continue;
            stringLRIGType.append(" / ").append(cardLRIGType.getLabel());
        }
        stringLRIGType.append(LanguageParser.getString("CARD_INFO_BRACKET_2R"));
        if (isLimitedText) {
            stringLRIGType.append(" ").append(LanguageParser.getString("CARD_INFO_LRIG_LIMITED"));
        }
        return stringLRIGType.toString();
    }

    public static String formatSIGNIClass(CardDataSIGNIClass dataCardSIGNIClass) {
        CardDataSIGNIClass.CardSIGNIClassValue primarySIGNIClass = dataCardSIGNIClass.getPrimaryValue();
        if (primarySIGNIClass == null) {
            return "";
        }
        StringBuilder stringSIGNIClass = new StringBuilder();
        Iterator iterator = dataCardSIGNIClass.getValue().iterator();
        while (iterator.hasNext()) {
            CardDataSIGNIClass.CardSIGNIClassValue cardSIGNIClassValue = (CardDataSIGNIClass.CardSIGNIClassValue)iterator.next();
            if (!dataCardSIGNIClass.matchesExact(primarySIGNIClass.generation(), cardSIGNIClassValue.cardSIGNIClass())) continue;
            if (!cardSIGNIClassValue.equals(primarySIGNIClass)) {
                stringSIGNIClass.append("\n");
            }
            stringSIGNIClass.append(LanguageParser.getString("CARD_INFO_BRACKET_2L")).append(cardSIGNIClassValue.cardSIGNIClass().getLabel()).append(LanguageParser.getString("CARD_INFO_BRACKET_2R"));
        }
        return stringSIGNIClass.toString();
    }

    public static String formatSIGNIClassFamily(CardDataSIGNIClass dataCardSIGNIClass) {
        CardDataSIGNIClass.CardSIGNIClassValue primarySIGNIClass = dataCardSIGNIClass.getPrimaryValue();
        if (primarySIGNIClass == null) {
            return "";
        }
        StringBuilder stringSIGNIClassFamily = new StringBuilder();
        Iterator iterator = dataCardSIGNIClass.getValue().iterator();
        while (iterator.hasNext()) {
            CardDataSIGNIClass.CardSIGNIClassValue cardSIGNIClassValue = (CardDataSIGNIClass.CardSIGNIClassValue)iterator.next();
            CardConst.CardSIGNIClassFamily family = cardSIGNIClassValue.cardSIGNIClass().getClassFamily();
            if (!dataCardSIGNIClass.matchesExact(primarySIGNIClass.generation(), cardSIGNIClassValue.cardSIGNIClass()) || stringSIGNIClassFamily.toString().contains(family.getLabel())) continue;
            if (!cardSIGNIClassValue.equals(primarySIGNIClass)) {
                stringSIGNIClassFamily.append("\n");
            }
            stringSIGNIClassFamily.append(LanguageParser.getString("CARD_INFO_BRACKET_3L")).append(family.getLabel());
            if (family != CardConst.CardSIGNIClassFamily.FACTION) {
                stringSIGNIClassFamily.append(" ").append(primarySIGNIClass.generation().getLabel());
            }
            stringSIGNIClassFamily.append(LanguageParser.getString("CARD_INFO_BRACKET_3R"));
        }
        return stringSIGNIClassFamily.toString();
    }

    public static String formatSIGNIClassMaskedSingle(CardConst.CardSIGNIClass cardSIGNIClass) {
        if (cardSIGNIClass != CardConst.CardSIGNIClass.ORIGIN) {
            return cardSIGNIClass.getClassFamily().getLabel() + " : " + cardSIGNIClass.getLabel();
        }
        return CardConst.CardSIGNIClass.ORIGIN.getLabel();
    }

    public static void formatCostIcons(TilePane containerIcons, Card cardObject, List<AbilityCostList> dataCostListsModified) {
        List<AbilityCostList> dataCostListsDefault = cardObject.getCostAsDataCostLists();
        for (int i = 0; i < dataCostListsModified.size(); ++i) {
            AbilityCostList costList = dataCostListsModified.get(i);
            for (AbilityCost cost : costList.getDataArray()) {
                ModifiableVariable modCost;
                if (cost instanceof EnerCost) {
                    EnerCost enerCost = (EnerCost)cost;
                    modCost = enerCost.getCostString();
                    String costStringDefault = (String)modCost.getDefaultValue();
                    String costStringModified = ((ModifiableString)modCost).getValue();
                    Map<CardConst.CardColor, Integer> mapDefault = Cost.getMappedColorsCount(costStringDefault);
                    Map<CardConst.CardColor, Integer> mapModified = Cost.getMappedColorsCount(costStringModified);
                    HashMap<CardConst.CardColor, Integer> mapTemp = new HashMap<CardConst.CardColor, Integer>();
                    for (char c : costStringModified.toCharArray()) {
                        CardConst.CardColor color = CardConst.CardColor.getColorByShortLabel(c);
                        Background background = null;
                        if (mapModified.get((Object)color) < mapDefault.get((Object)color)) {
                            background = UIConst.Style.BACKGROUND_GREEN_LIGHT;
                        } else {
                            int count = mapTemp.merge(color, 1, Integer::sum);
                            if (count > mapDefault.get((Object)color)) {
                                background = UIConst.Style.BACKGROUND_RED_DEEP;
                            }
                        }
                        UtilCardDataFormatter.addEnerIcon(containerIcons, background, ImageCache.INSTANCE.getImageIcon(ImageCache.getColorIconPath(color)));
                    }
                    mapModified.entrySet().stream().filter(entry -> (Integer)entry.getValue() == 0 && (Integer)mapDefault.get(entry.getKey()) != 0).forEach(entry -> UtilCardDataFormatter.addEnerIcon(containerIcons, UIConst.Style.BACKGROUND_GREEN_LIGHT, ImageCache.INSTANCE.getImageIcon(ImageCache.getColorIconPath((CardConst.CardColor)((Object)((Object)entry.getKey()))) + "0")));
                    continue;
                }
                if (!(cost instanceof CoinCost)) continue;
                modCost = cost.getModifiableCostMinCount();
                int costDefault = (Integer)modCost.getDefaultValue();
                int costModified = ((ModifiableInteger)modCost).getValue();
                if (cost.getCostMinCount() > 0) {
                    for (int ii = 0; ii < cost.getCostMinCount(); ++ii) {
                        containerIcons.getChildren().add((Object)new ImageView(ImageCache.INSTANCE.getImageIcon("coin")));
                    }
                    continue;
                }
                StackPane containerIcon = new StackPane();
                containerIcon.setBackground(UIConst.Style.BACKGROUND_GREEN_LIGHT);
                containerIcon.getChildren().add((Object)new ImageView(ImageCache.INSTANCE.getImageIcon("coin0")));
                containerIcons.getChildren().add((Object)containerIcon);
            }
            if (!containerIcons.getChildren().isEmpty()) {
                if (i == dataCostListsModified.size() - 1) continue;
                UtilCardDataFormatter.addSeparator(containerIcons);
                continue;
            }
            CardConst.CardColor color = cardObject.getType() != CardConst.CardType.LRIG_ASSIST ? cardObject.getColor().getPrimaryValue() : CardConst.CardColor.COLORLESS;
            containerIcons.getChildren().add((Object)new ImageView(ImageCache.INSTANCE.getImageIcon(ImageCache.getColorIconPath(color) + "0")));
            if (dataCostListsDefault.size() != 2 || cardObject.getColor().getBaseValue().size() != 2) continue;
            UtilCardDataFormatter.addSeparator(containerIcons);
            containerIcons.getChildren().add((Object)new ImageView(ImageCache.INSTANCE.getImageIcon(ImageCache.getColorIconPath((CardConst.CardColor)((Object)cardObject.getColor().getBaseValue().getLast())) + "0")));
        }
    }

    private static void addSeparator(TilePane containerIcons) {
        Text textSeparator = new Text(" / ");
        if ("game".equals(containerIcons.getId())) {
            textSeparator.setFill((Paint)Color.WHITE);
        }
        containerIcons.getChildren().add((Object)textSeparator);
    }

    private static void addEnerIcon(TilePane containerIcons, Background background, Image icon) {
        StackPane containerIcon = new StackPane();
        if (background != null) {
            containerIcon.setBackground(background);
        }
        ImageView imageIcon = new ImageView(icon);
        imageIcon.setFitWidth(20.0);
        imageIcon.setFitHeight(20.0);
        containerIcon.getChildren().add((Object)imageIcon);
        containerIcons.getChildren().add((Object)containerIcon);
    }
}

