/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.catalog.description;

import java.util.List;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.catalog.description.DisabledDescriptionModifier;
import open.batoru.catalog.description.UnbondedDescriptionModifier;
import open.batoru.catalog.description.UnfulfilledRecollectDescriptionModifier;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardLoader;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.LifeBurstAbility;
import open.batoru.game.Zone;
import open.batoru.parsers.LanguageParser;

public class DescriptionParser {
    public static final DescriptionParser DEFAULT = new DescriptionParser("#c6c6c6", "#eee", "#000", "#221816", "ff");
    public static final DescriptionParser GAME = new DescriptionParser("#000", "#44444480", "#fff", "#eee", "80");
    private static final DisabledDescriptionModifier DESCRIPTION_MODIFIER_DISABLED = new DisabledDescriptionModifier();
    private static final UnbondedDescriptionModifier DESCRIPTION_MODIFIER_UNBONDED = new UnbondedDescriptionModifier();
    private static final UnfulfilledRecollectDescriptionModifier DESCRIPTION_MODIFIER_UNFULFILLED_RECOLLECT = new UnfulfilledRecollectDescriptionModifier();
    private final String header;
    private final String colorBackground;
    private final String colorTextNested;
    private final String colorBackgroundNested;
    private final String genericOpacity;

    public DescriptionParser(String colorBackground, String colorBackgroundNested, String colorText, String colorTextNested, String genericTransparency) {
        Object font = LanguageParser.getString("UI_FONT");
        if (((String)font).contains(" ")) {
            font = "&quot;" + (String)font + "&quot;";
        }
        this.header = "<body style=\"" + (String)(colorBackground != null ? "background: " + colorBackground + "; " : "") + "font-family: " + (String)font + "; font-size: " + LanguageParser.getString("UI_CARD_TEXT_SIZE") + "pt; color: " + colorText + "; padding: 0; margin: 0;\">";
        this.colorBackground = colorBackground;
        this.colorTextNested = colorTextNested;
        this.colorBackgroundNested = colorBackgroundNested;
        this.genericOpacity = genericTransparency;
    }

    public String getBackgroundColor() {
        return this.colorBackground;
    }

    public String parseDescription(Card cardObject, boolean showHeader) {
        StringBuilder description = new StringBuilder();
        if (showHeader) {
            this.appendCardHeader(description, cardObject);
        }
        description.append(cardObject.getDescription());
        return this.parseDescription(description.toString());
    }

    public String parseDescription(CardIndex cardIndex, boolean showHeader) {
        int i;
        String extraDescription;
        Ability ability;
        StringBuilder description = new StringBuilder();
        Card cardObject = cardIndex.getCardReference();
        if (showHeader) {
            this.appendCardHeader(description, cardObject);
        }
        if (cardIndex.getIndexedInstance().isState(8) && !cardObject.isCraft()) {
            description.append("[[CRAFT]]\n\n");
        }
        if (cardIndex.getIndexedInstance().getOriginalImageSet() != null) {
            description.append("@=|=`").append(CardLoader.getCardByImageSet(cardIndex.getIndexedInstance().getOriginalImageSet()).getName()).append("`]@@@@@");
        }
        if (cardIndex.isSIGNIOnField()) {
            Zone zone = cardIndex.getZoneByLocation();
            for (int i2 = zone.getTotalCards() - 2; i2 >= 0; --i2) {
                CardIndex cardIndexUnder = zone.getZoneCardList().get(i2).getCardIndex();
                if (cardIndexUnder.getUnderType() != GameConst.CardUnderType.ATTACHED_ACCESSORY) continue;
                for (int ii = 0; ii < cardIndexUnder.getIndexedInstance().getAbilityList().size(); ++ii) {
                    ability = cardIndexUnder.getIndexedInstance().getAbilityList().get(ii);
                    if (ability.isDisabled() || ability.getActiveUnderFlags() != GameConst.CardUnderType.ATTACHED_ACCESSORY.getFlags()) continue;
                    description.append("@*|*").append(LanguageParser.getString("CARD_TEXT_ABILITY_ACCESSORY")).append(" `").append(ability.getSourceCardIndex().getCardReference().getName()).append("`]@@@").append(DescriptionParser.getFullAbilityDescription(ability)).append("@@");
                }
            }
        }
        if ((extraDescription = cardIndex.getIndexedInstance().getStartingExtraDescription()) != null && cardObject.getType() == CardConst.CardType.RESONA) {
            description.append(extraDescription);
        }
        List<Ability> listAbilities = cardIndex.getIndexedInstance().getAbilityList();
        StringBuilder descriptionEnd = new StringBuilder();
        for (i = cardIndex.getIndexedInstance().getTotalBaseAbilities(); i < listAbilities.size(); ++i) {
            String abilityDescription;
            StringBuilder desc;
            ability = cardIndex.getIndexedInstance().getAbilityList().get(i);
            Ability sourceAttachAbility = ability.getSourceAttachAbility();
            if (sourceAttachAbility == null || ability.isDisabled()) continue;
            StringBuilder stringBuilder = desc = !(ability instanceof LifeBurstAbility) ? description : descriptionEnd;
            if (ability instanceof LifeBurstAbility) {
                desc.append("@@");
            }
            if ((abilityDescription = DescriptionParser.getAbilityDescription(ability)).isEmpty()) continue;
            DescriptionParser.appendCardAttachedAbilityHeader(desc, cardIndex, sourceAttachAbility);
            desc.append(abilityDescription);
            desc.append("@@");
        }
        if (extraDescription != null && cardObject.getType() != CardConst.CardType.RESONA) {
            description.append(extraDescription);
        }
        for (i = 0; i < cardIndex.getIndexedInstance().getTotalBaseAbilities(); ++i) {
            ability = cardIndex.getIndexedInstance().getAbilityList().get(i);
            String abilityDescription = ability.getCachedAbilityDescription();
            if (ability.getEnerCostDescriptionModifier() != null) {
                abilityDescription = ability.getEnerCostDescriptionModifier().processModifier(ability, abilityDescription);
            }
            if (ability.isDisabled()) {
                abilityDescription = DESCRIPTION_MODIFIER_DISABLED.processModifier(ability, abilityDescription);
            }
            if (ability.isUseLimited()) {
                abilityDescription = DESCRIPTION_MODIFIER_DISABLED.processModifier(ability, abilityDescription);
            }
            if (ability.isBonded() && !cardIndex.getIndexedInstance().hasActiveBond()) {
                abilityDescription = DESCRIPTION_MODIFIER_UNBONDED.processModifier(ability, abilityDescription);
            }
            if (ability.hasRecollect() && !ability.isRecollectFulfilled()) {
                abilityDescription = DESCRIPTION_MODIFIER_UNFULFILLED_RECOLLECT.processModifier(ability, abilityDescription);
            }
            description.append(abilityDescription);
        }
        String descriptionFinal = this.parseDescription(description.toString());
        if (descriptionEnd.isEmpty()) {
            return descriptionFinal;
        }
        int unclosedTags = DescriptionParser.countOccurrences(descriptionFinal, "</div>") - DescriptionParser.countOccurrences(descriptionFinal, "<div>");
        return this.parseDescription(String.valueOf(description) + "@@".repeat(unclosedTags) + String.valueOf(descriptionEnd));
    }

    public static int countOccurrences(String str, String sub) {
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String getAbilityDescription(Ability ability) {
        if (ability.getSourceAttachAbility() == null) {
            return DescriptionParser.getFullAbilityDescription(ability);
        }
        if (ability.getSourceStockAbility() == null) {
            return DescriptionParser.getNestedAbilityDescription(ability);
        }
        return ability.getSourceStockAbility().getAbilityDescription();
    }

    @Deprecated
    public static String getDefaultFullAbilityDescription(Ability ability) {
        List<String> listAbilityDescriptions = ability.getSourceCardIndex().getIndexedInstance().getAbilityDescriptionsList();
        return !listAbilityDescriptions.isEmpty() ? listAbilityDescriptions.get(Math.min(ability.getAbilityId(), listAbilityDescriptions.size() - 1)) : "";
    }

    private static String getFullAbilityDescription(Ability ability) {
        if (ability.getSourceStockAbility() == null) {
            if (ability.getSourceCardIndex().getIndexedInstance() != null) {
                String defaultDescription = DescriptionParser.getDefaultFullAbilityDescription(ability);
                if (ability.getSourceAttachPlayerRole() != null) {
                    return defaultDescription;
                }
                return DescriptionParser.getModifiedAbilityDescription(ability, defaultDescription);
            }
            return ability.getCachedAbilityDescription();
        }
        return ability.getSourceStockAbility().getAbilityDescription();
    }

    private static String getNestedAbilityDescription(Ability ability) {
        Ability sourceAttachAbility = ability.getSourceAttachAbility();
        if (sourceAttachAbility != null && sourceAttachAbility.getSourceCardIndex().getIndexedInstance() == null) {
            return ability.getCachedAbilityDescription();
        }
        while (sourceAttachAbility != null && sourceAttachAbility.getTotalNestedAbilityDescriptions() == 0) {
            sourceAttachAbility = sourceAttachAbility.getSourceAttachAbility();
        }
        if (sourceAttachAbility == null || ability.isCopied()) {
            return DescriptionParser.getModifiedAbilityDescription(ability, DescriptionParser.getFullAbilityDescription(ability.getSourceAttachAbility()));
        }
        String description = DescriptionParser.getDynamicAbilityDescription(ability, sourceAttachAbility.getNestedAbilityDescription(ability.getNestedDescriptionOffset()));
        return DescriptionParser.getModifiedAbilityDescription(ability, description);
    }

    public static String getDynamicAbilityDescription(Ability ability, String originalDescription) {
        String dynamicString;
        int tokenFormat;
        String dynamicDescription;
        if (ability.getDynamicAbilityDescriptionHandler() == null) {
            return originalDescription;
        }
        TargetFilter.setDefaultSources(ability.getSourceCardIndex(), ability);
        try {
            dynamicDescription = ability.getDynamicAbilityDescriptionHandler().getDescription();
        }
        catch (NullPointerException ex) {
            return originalDescription;
        }
        int tokenStart = originalDescription.indexOf("{{");
        int tokenEnd = originalDescription.indexOf("}}");
        if (tokenStart != -1 && tokenEnd != -1 && (tokenFormat = (dynamicString = originalDescription.substring(tokenStart + 2, tokenEnd)).indexOf("$")) != -1) {
            String formattedString = dynamicString.substring(tokenFormat + 1).replace("%1", dynamicDescription);
            return originalDescription.substring(0, tokenStart + 2) + formattedString + originalDescription.substring(tokenEnd);
        }
        return originalDescription;
    }

    private static String getModifiedAbilityDescription(Ability ability, String description) {
        if (ability.getEnerCostDescriptionModifier() != null) {
            description = ability.getEnerCostDescriptionModifier().processModifier(ability, description);
        }
        if (ability.isUseLimited()) {
            description = DESCRIPTION_MODIFIER_DISABLED.processModifier(ability, description);
        }
        if (ability.hasRecollect() && !ability.isRecollectFulfilled()) {
            description = DESCRIPTION_MODIFIER_UNFULFILLED_RECOLLECT.processModifier(ability, description);
        }
        return description;
    }

    public static String getActionReplacementAbilityDescription(String description) {
        int tokenStart = description.indexOf("||");
        int tokenEnd = description.lastIndexOf("||");
        if (tokenStart != -1 && tokenEnd != -1 && tokenStart != tokenEnd) {
            return Character.toUpperCase(description.charAt(tokenStart + 2)) + description.substring(tokenStart + 3, tokenEnd);
        }
        return description;
    }

    public static void assignCardAbilityDescriptions(CardIndex cardIndex) {
        CardConst.CardType cardType = cardIndex.getCardReference().getType();
        String description = cardIndex.getCardReference().getDescription();
        StringBuilder abilityDescription = new StringBuilder();
        StringBuilder extraAbilityDescription = new StringBuilder();
        int currentAbilityIndex = cardType != CardConst.CardType.SPELL && cardType != CardConst.CardType.ARTS && cardType != CardConst.CardType.PIECE ? -1 : 0;
        int nestedLevels = 0;
        int maxNestedLevels = 0;
        for (int i = 0; i < description.length(); ++i) {
            boolean isSpecialSequence;
            char nextChar;
            char prevChar = i != 0 ? description.charAt(i - 1) : (char)'\u0000';
            char currentChar = description.charAt(i);
            char c = nextChar = i != description.length() - 1 ? description.charAt(i + 1) : (char)'\u0000';
            if (currentChar == '@') {
                if (nextChar == '>') {
                    if (nestedLevels == 0) {
                        DescriptionParser.addAbilityDescription(cardIndex, currentAbilityIndex, abilityDescription.toString(), 0, maxNestedLevels);
                        abilityDescription = new StringBuilder();
                    }
                    if (++nestedLevels > maxNestedLevels) {
                        maxNestedLevels = nestedLevels;
                    }
                    if (nestedLevels == 1) {
                        ++i;
                        continue;
                    }
                    abilityDescription.append("@>");
                    i += 2;
                } else if (nextChar == '@' && prevChar != '~' && nestedLevels > 0) {
                    if (nestedLevels != 1) {
                        abilityDescription.append(currentChar).append(nextChar);
                    }
                    DescriptionParser.addAbilityDescription(cardIndex, currentAbilityIndex, abilityDescription.toString(), nestedLevels, maxNestedLevels);
                    abilityDescription = new StringBuilder();
                    --nestedLevels;
                    ++i;
                    continue;
                }
            }
            boolean isSpecialChar = currentChar == '@' || currentChar == '+' || currentChar == '\\' || currentChar == '^';
            boolean isValidNextChar = nextChar == 'E' || nextChar == 'A' || nextChar == 'U' || nextChar == 'C' || nextChar == 'L';
            boolean bl = isSpecialSequence = (prevChar == '\u0000' || prevChar == '\n' || prevChar == '@' || prevChar == '>') && isSpecialChar && isValidNextChar || currentChar == '~' && nextChar == '@' || prevChar == '\u0000' && currentChar == '=' && (nextChar == 'H' || nextChar == 'I') || prevChar == '\u0000' && currentChar == '=' && nextChar == 'X' || currentChar == '~' && (nextChar == '#' || nextChar == '!' || nextChar == '{');
            if (isSpecialSequence) {
                DescriptionParser.addAbilityDescription(cardIndex, currentAbilityIndex, abilityDescription.toString(), nestedLevels, maxNestedLevels);
                abilityDescription = new StringBuilder();
                if (nestedLevels == 0) {
                    ++currentAbilityIndex;
                }
            }
            if (currentAbilityIndex != -1) {
                abilityDescription.append(currentChar);
                continue;
            }
            extraAbilityDescription.append(currentChar);
        }
        if (!extraAbilityDescription.isEmpty()) {
            cardIndex.getIndexedInstance().setStartingExtraDescription(extraAbilityDescription.toString());
        }
        DescriptionParser.addAbilityDescription(cardIndex, currentAbilityIndex, abilityDescription.toString(), nestedLevels, maxNestedLevels);
    }

    private static void addAbilityDescription(CardIndex cardIndex, int abilityIndex, String description, int nestedLevels, int maxNestedLevels) {
        if (abilityIndex < 0 || description.isEmpty()) {
            return;
        }
        List<String> descriptions = cardIndex.getIndexedInstance().getAbilityDescriptionsList();
        if (nestedLevels == 0) {
            Ability ability;
            Ability ability2 = ability = abilityIndex < cardIndex.getIndexedInstance().getAbilityList().size() ? cardIndex.getIndexedInstance().getAbilityList().get(abilityIndex) : null;
            if (ability != null && ability.getTotalNestedAbilityDescriptions() > 0) {
                String oldDescription = descriptions.get(abilityIndex);
                descriptions.set(abilityIndex, oldDescription + description);
            } else {
                descriptions.add(description);
            }
            System.out.println("* ABILITY(" + abilityIndex + "): " + description);
        } else {
            String oldDescription = descriptions.get(abilityIndex);
            if (descriptions.size() < nestedLevels) {
                descriptions.set(abilityIndex, oldDescription + "@>" + description + "@@");
                Ability ability = cardIndex.getIndexedInstance().getAbilityList().get(abilityIndex);
                ability.addNestedAbilityDescription(description);
                System.out.println("* NESTED(" + abilityIndex + ":" + ability.getTotalNestedAbilityDescriptions() + "): @>" + description + "@@");
                int start = description.indexOf("@>");
                if (start != -1) {
                    int end = description.indexOf("@@");
                    description = description.substring(start + 2, end != -1 ? end : description.length());
                    ability.addNestedAbilityDescription(description);
                    System.out.println("* NESTED(" + abilityIndex + ":" + ability.getTotalNestedAbilityDescriptions() + "): " + description);
                }
            } else {
                Ability ability = cardIndex.getIndexedInstance().getAbilityList().get(abilityIndex);
                if (nestedLevels >= maxNestedLevels) {
                    descriptions.set(abilityIndex, oldDescription + "@>" + description + "@@");
                    ability.addNestedAbilityDescription(description);
                    System.out.println("* NESTED(" + abilityIndex + ":" + ability.getTotalNestedAbilityDescriptions() + "): @>" + description + "@@");
                } else {
                    descriptions.set(abilityIndex, oldDescription.substring(0, oldDescription.length() - 2) + description + "@@");
                    ability.appendNestedAbilityDescription(nestedLevels - 1, description + "@@");
                    System.out.println("* NESTED(" + abilityIndex + ":" + (ability.getTotalNestedAbilityDescriptions() - 1) + "): " + description + "@@");
                }
            }
        }
    }

    public static void appendCardAttachedAbilityHeader(StringBuilder description, CardIndex cardIndex, Ability sourceAttachAbility) {
        description.append(cardIndex.getCurrentOwnerSafe() == sourceAttachAbility.getSourceCardIndex().getCurrentOwnerSafe() ? "@+|+" : "@-|-").append(LanguageParser.getString("CARD_TEXT_ABILITY_GAINED_BY")).append(" `").append((String)(cardIndex != sourceAttachAbility.getSourceCardIndex() ? (sourceAttachAbility.getSourceCardIndex() != null && sourceAttachAbility.getSourceCardIndex().getCardReference() != null ? sourceAttachAbility.getSourceCardIndex().getCardReference().getName() : sourceAttachAbility.getCachedSourceCardName()) : "&lt;" + LanguageParser.getString("CARD_TEXT_ABILITY_GAINED_SELF") + "&gt;")).append("`]@@@");
    }

    private void appendCardHeader(StringBuilder description, Card cardObject) {
        if ((cardObject.getCardFlags() & 8) != 0) {
            description.append("[[").append(LanguageParser.getString("CARD_TEXT_CRAFT")).append("]]\n\n");
        } else if ((cardObject.getCardFlags() & 0x10) != 0) {
            description.append("[[").append(LanguageParser.getString("CARD_TEXT_RELAY")).append("]]\n\n");
        }
        int useTiming = cardObject.getUseTiming();
        if (useTiming != 0) {
            if (cardObject.getType() != CardConst.CardType.RESONA) {
                if ((useTiming & 1) != 0) {
                    description.append("=M\n");
                }
                if ((useTiming & 2) != 0) {
                    description.append("=A\n");
                }
                if ((useTiming & 4) != 0) {
                    description.append("=S\n");
                }
                description.append("\n");
            } else {
                description.append("=P ");
                if ((useTiming & 1) != 0) {
                    description.append("-M ");
                }
                if ((useTiming & 2) != 0) {
                    description.append("-A ");
                }
                if ((useTiming & 4) != 0) {
                    description.append("-S ");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String parseDescription(String description) {
        StringBuilder parsedDescription = new StringBuilder(this.header);
        if (description == null) {
            return parsedDescription.toString();
        }
        boolean inQuotes = false;
        boolean inQuotes2 = false;
        boolean inDynamicText = false;
        boolean inDynamicTextFormat = false;
        int len = description.length();
        int i = 0;
        while (true) {
            block217: {
                if (i >= len) {
                    return parsedDescription.toString();
                }
                char c1 = description.charAt(i);
                switch (c1) {
                    case '\n': {
                        parsedDescription.append("<br>");
                        break block217;
                    }
                    case '`': {
                        inQuotes = !inQuotes;
                        break block217;
                    }
                    case '\"': {
                        inQuotes2 = !inQuotes2;
                        parsedDescription.append(inQuotes2 ? "\"<i>" : "</i>\"");
                        break block217;
                    }
                    case '$': {
                        if (!inDynamicText) break;
                        inDynamicTextFormat = true;
                        break;
                    }
                    case '}': {
                        if (!inDynamicTextFormat) break;
                        inDynamicTextFormat = false;
                    }
                }
                if (inQuotes) {
                    parsedDescription.append(c1);
                } else if (!inDynamicTextFormat) {
                    if (i + 1 != len) {
                        char c2 = description.charAt(i + 1);
                        String seq = String.valueOf(c1).concat(String.valueOf(c2));
                        ++i;
                        switch (seq) {
                            case "<<": {
                                parsedDescription.append("<b>&lt;");
                                break;
                            }
                            case ">>": {
                                parsedDescription.append("&gt;</b>");
                                break;
                            }
                            case "[[": {
                                parsedDescription.append("<b>").append(LanguageParser.getString("CARD_INFO_BRACKET_1L"));
                                break;
                            }
                            case "]]": {
                                parsedDescription.append(LanguageParser.getString("CARD_INFO_BRACKET_1R")).append("</b>");
                                break;
                            }
                            case "{{": {
                                inDynamicText = true;
                                break;
                            }
                            case "}}": {
                                inDynamicText = false;
                                break;
                            }
                            case "||": {
                                break;
                            }
                            case "((": {
                                parsedDescription.append("<i>(");
                                break;
                            }
                            case "))": {
                                parsedDescription.append(")</i>");
                                break;
                            }
                            case "@|": {
                                parsedDescription.append("<u>");
                                break;
                            }
                            case "|@": {
                                parsedDescription.append("</u>");
                                break;
                            }
                            case "@[": {
                                parsedDescription.append("<b>");
                                break;
                            }
                            case "]@": {
                                parsedDescription.append("</b>");
                                break;
                            }
                            case "@(": {
                                parsedDescription.append("<i>");
                                break;
                            }
                            case ")@": {
                                parsedDescription.append("</i>");
                                break;
                            }
                            case "@@": 
                            case "@0": {
                                parsedDescription.append("</div>");
                                break;
                            }
                            case "@!": {
                                parsedDescription.append("<div style=\"filter: grayscale(75%) opacity(30%);\">");
                                break;
                            }
                            case "@?": {
                                parsedDescription.append("<div style=\"filter: grayscale(25%) opacity(50%);\">");
                                break;
                            }
                            case "@R": {
                                parsedDescription.append("<div style=\"display: inline-block; background: red;\">");
                                break;
                            }
                            case "@G": {
                                parsedDescription.append("<div style=\"display: inline-block; background: lightgreen;\">");
                                break;
                            }
                            case "@>": {
                                parsedDescription.append("<div style=\"");
                                if (this.colorBackgroundNested != null) {
                                    parsedDescription.append("background: ").append(this.colorBackgroundNested).append("; ");
                                }
                                parsedDescription.append("border-left: 4px grey solid; padding: 3px 0 3px 5px; margin: 5px 0 5px 0;\">");
                                break;
                            }
                            case "@#": {
                                parsedDescription.append("<div style=\"display: inline-block; color: ").append(this.colorTextNested).append("\">");
                                break;
                            }
                            case "@+": {
                                parsedDescription.append(DescriptionParser.parseAttachedAbility("c9f2d1", "24983c"));
                                break;
                            }
                            case "@*": {
                                parsedDescription.append(DescriptionParser.parseAttachedAbility("234e35", "d0eedd", "dashed", "d0eedd"));
                                break;
                            }
                            case "|+": {
                                parsedDescription.append(DescriptionParser.parseAttachedAbilityName("c9f2d1", "24983c"));
                                break;
                            }
                            case "|*": {
                                parsedDescription.append(DescriptionParser.parseAttachedAbilityName("234e35", "d0eedd"));
                                break;
                            }
                            case "@-": {
                                parsedDescription.append(DescriptionParser.parseAttachedAbility("fdf2f2", "cf2221"));
                                break;
                            }
                            case "|-": {
                                parsedDescription.append(DescriptionParser.parseAttachedAbilityName("fdf2f2", "cf2221"));
                                break;
                            }
                            case "@=": {
                                parsedDescription.append(DescriptionParser.parseAttachedAbility("e2e2e2", "6b6b6b"));
                                break;
                            }
                            case "|=": {
                                parsedDescription.append(DescriptionParser.parseAttachedAbilityName("e2e2e2", "6b6b6b"));
                                break;
                            }
                            case "--": {
                                parsedDescription.append("\u2212");
                                break;
                            }
                            case "$$": {
                                char c3 = description.charAt(i + 1);
                                if (c3 < '1' || c3 > '8') break;
                                c3 = (char)(c3 + '\u0001');
                                ++i;
                                parsedDescription.append("&#1012").append(c3).append(";");
                                break;
                            }
                            case "$T": {
                                char c3 = description.charAt(i + 1);
                                if (c3 >= '1' && c3 <= '9') {
                                    ++i;
                                    parsedDescription.append(DescriptionParser.parseNumberedOval(LanguageParser.getString("CARD_TEXT_TURN"), String.valueOf(c3), "000"));
                                    break;
                                }
                                if (c3 == 'O') {
                                    ++i;
                                    parsedDescription.append(DescriptionParser.parsePlayerTurn(true, "0f65b3"));
                                    break;
                                }
                                if (c3 != 'P') break;
                                ++i;
                                parsedDescription.append(DescriptionParser.parsePlayerTurn(false, "cf2221"));
                                break;
                            }
                            case "$G": {
                                char c3 = description.charAt(i + 1);
                                if (c3 < '1' || c3 > '9') break;
                                ++i;
                                parsedDescription.append(DescriptionParser.parseNumberedOval(LanguageParser.getString("CARD_TEXT_GAME"), String.valueOf(c3), "cf2221"));
                                break;
                            }
                            case "$W": {
                                char c3 = description.charAt(i + 1);
                                if (c3 >= '1' && c3 <= '9') {
                                    char c4;
                                    Object seq2 = String.valueOf(c3);
                                    if (++i + 1 != len && (c4 = description.charAt(i + 1)) >= '0' && c4 <= '9') {
                                        ++i;
                                        seq2 = (String)seq2 + c4;
                                    }
                                    parsedDescription.append(DescriptionParser.parseWisdom(true, (String)seq2));
                                    break;
                                }
                                if (c3 != '0') break;
                                ++i;
                                parsedDescription.append(DescriptionParser.parseWisdom(false, ""));
                                break;
                            }
                            case "%X": {
                                i += this.parseColorToken("colorless", i, parsedDescription, description, len);
                                break;
                            }
                            case "%W": {
                                i += this.parseColorToken("white", i, parsedDescription, description, len);
                                break;
                            }
                            case "%R": {
                                i += this.parseColorToken("red", i, parsedDescription, description, len);
                                break;
                            }
                            case "%G": {
                                i += this.parseColorToken("green", i, parsedDescription, description, len);
                                break;
                            }
                            case "%B": {
                                i += this.parseColorToken("blue", i, parsedDescription, description, len);
                                break;
                            }
                            case "%K": {
                                i += this.parseColorToken("black", i, parsedDescription, description, len);
                                break;
                            }
                            case "~@": {
                                parsedDescription.append("<div style=\"margin: 0 0 5px 0; color: ").append(this.colorTextNested).append(";\">").append(DescriptionParser.parseIcon("guard", 20)).append(" <b>").append(LanguageParser.getString("CARD_TEXT_GUARD")).append("</b></div>");
                                break;
                            }
                            case "~#": {
                                parsedDescription.append("<div style=\"background: #221816; color: white; padding: 5px; margin: 5px 0 0 0;\">").append(DescriptionParser.parseIcon("lifeburst")).append(" <b>").append(LanguageParser.getString("CARD_TEXT_LIFEBURST")).append("</b> ");
                                break;
                            }
                            case "~!": {
                                parsedDescription.append("<div style=\"background: #c9e5f8").append(this.genericOpacity).append("; padding: 5px; margin: 5px 0 0 0;\">").append(DescriptionParser.parseIcon("trap")).append(" <b>").append(LanguageParser.getString("CARD_TEXT_TRAP")).append("</b> ");
                                break;
                            }
                            case "~{": {
                                parsedDescription.append("<div style=\"background: #f7c6da").append(this.genericOpacity).append("; border: 1px solid #c31052; padding: 5px; margin: 5px 0 0 0;\">");
                                break;
                            }
                            case "#D": {
                                parsedDescription.append(DescriptionParser.parseIcon("down"));
                                break;
                            }
                            case "#S": {
                                parsedDescription.append(DescriptionParser.parseIcon("dissona", 20));
                                break;
                            }
                            case "#H": {
                                parsedDescription.append(DescriptionParser.parseIcon("heaven", 20));
                                break;
                            }
                            case "#C": {
                                boolean isZeroIcon = i + 1 != len && description.charAt(i + 1) == '0';
                                parsedDescription.append(DescriptionParser.parseIcon("coin" + (isZeroIcon ? "0" : "")));
                                if (!isZeroIcon) break;
                                ++i;
                                break;
                            }
                            case "#!": {
                                parsedDescription.append(DescriptionParser.parseIcon("trap"));
                                break;
                            }
                            case "#L": {
                                parsedDescription.append(DescriptionParser.parseIcon("layer"));
                                break;
                            }
                            case "##": {
                                parsedDescription.append(DescriptionParser.parseIcon("lifeburst"));
                                break;
                            }
                            case "#G": {
                                parsedDescription.append(DescriptionParser.parseIcon("guard", 20));
                                break;
                            }
                            case "-A": {
                                parsedDescription.append(DescriptionParser.parseUseTiming(false, LanguageParser.getString("CARD_TEXT_TIMING_ATTACK")));
                                break;
                            }
                            case "-M": {
                                parsedDescription.append(DescriptionParser.parseUseTiming(false, LanguageParser.getString("CARD_TEXT_TIMING_MAIN")));
                                break;
                            }
                            case "-S": {
                                parsedDescription.append(DescriptionParser.parseUseTiming(false, LanguageParser.getString("CARD_TEXT_TIMING_SPELLCUTIN")));
                                break;
                            }
                            case "@C": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("cf2221", LanguageParser.getString("CARD_TEXT_CONST"), "fff"));
                                break;
                            }
                            case "@U": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("e1b622", LanguageParser.getString("CARD_TEXT_AUTO"), "fff"));
                                break;
                            }
                            case "@E": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("2254a2", LanguageParser.getString("CARD_TEXT_ENTER"), "fff"));
                                break;
                            }
                            case "@A": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("24983c", LanguageParser.getString("CARD_TEXT_ACTION"), "fff"));
                                break;
                            }
                            case "+C": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("cf2221", LanguageParser.getString("CARD_TEXT_CONST"), "fff", DescriptionParser.parseSVGIcon(DescriptionParser.getSVGIconCross())));
                                break;
                            }
                            case "+U": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("e1b622", LanguageParser.getString("CARD_TEXT_AUTO"), "fff", DescriptionParser.parseSVGIcon(DescriptionParser.getSVGIconCross())));
                                break;
                            }
                            case "+E": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("2254a2", LanguageParser.getString("CARD_TEXT_ENTER"), "fff", DescriptionParser.parseSVGIcon(DescriptionParser.getSVGIconCross())));
                                break;
                            }
                            case "+A": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("24983c", LanguageParser.getString("CARD_TEXT_ACTION"), "fff", DescriptionParser.parseSVGIcon(DescriptionParser.getSVGIconCross())));
                                break;
                            }
                            case "\\C": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("cf2221", LanguageParser.getString("CARD_TEXT_CONST"), "fff", "\u2707"));
                                break;
                            }
                            case "\\U": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("e1b622", LanguageParser.getString("CARD_TEXT_AUTO"), "fff", "\u2707"));
                                break;
                            }
                            case "^C": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("cf2221", LanguageParser.getString("CARD_TEXT_CONST"), "fff", DescriptionParser.parseSVGIcon(DescriptionParser.getSVGIconTeam())));
                                break;
                            }
                            case "^U": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("e1b622", LanguageParser.getString("CARD_TEXT_AUTO"), "fff", DescriptionParser.parseSVGIcon(DescriptionParser.getSVGIconTeam())));
                                break;
                            }
                            case "^E": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("2254a2", LanguageParser.getString("CARD_TEXT_ENTER"), "fff", DescriptionParser.parseSVGIcon(DescriptionParser.getSVGIconTeam())));
                                break;
                            }
                            case "^A": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("24983c", LanguageParser.getString("CARD_TEXT_ACTION"), "fff", DescriptionParser.parseSVGIcon(DescriptionParser.getSVGIconTeam())));
                                break;
                            }
                            case "{C": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("cf2221", LanguageParser.getString("CARD_TEXT_CONST"), "fff", DescriptionParser.parseIcon("bond", 15, 13)));
                                break;
                            }
                            case "{U": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("e1b622", LanguageParser.getString("CARD_TEXT_AUTO"), "fff", DescriptionParser.parseIcon("bond", 15, 13)));
                                break;
                            }
                            case "{E": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("2254a2", LanguageParser.getString("CARD_TEXT_ENTER"), "fff", DescriptionParser.parseIcon("bond", 15, 13)));
                                break;
                            }
                            case "{A": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("24983c", LanguageParser.getString("CARD_TEXT_ACTION"), "fff", DescriptionParser.parseIcon("bond", 15, 13)));
                                break;
                            }
                            case "=A": {
                                parsedDescription.append(DescriptionParser.parseUseTiming(true, LanguageParser.getString("CARD_TEXT_TIMING_ATTACK")));
                                break;
                            }
                            case "=M": {
                                parsedDescription.append(DescriptionParser.parseUseTiming(true, LanguageParser.getString("CARD_TEXT_TIMING_MAIN")));
                                break;
                            }
                            case "=S": {
                                parsedDescription.append(DescriptionParser.parseUseTiming(true, LanguageParser.getString("CARD_TEXT_TIMING_SPELLCUTIN")));
                                break;
                            }
                            case "=C": {
                                parsedDescription.append(DescriptionParser.parseLeadArrow("fff37b", LanguageParser.getString("CARD_TEXT_CHAIN"), "000"));
                                break;
                            }
                            case "=X": {
                                parsedDescription.append(DescriptionParser.parseCross("221816", "fff"));
                                break;
                            }
                            case "=P": {
                                parsedDescription.append(DescriptionParser.parseLeadOval(LanguageParser.getString("CARD_TEXT_COND_PLAY")));
                                break;
                            }
                            case "=U": {
                                parsedDescription.append(DescriptionParser.parseLeadOval(LanguageParser.getString("CARD_TEXT_COND_USE")));
                                break;
                            }
                            case "=G": {
                                parsedDescription.append(DescriptionParser.parseLeadOval(LanguageParser.getString("CARD_TEXT_COND_GROW")));
                                break;
                            }
                            case "=R": {
                                parsedDescription.append(DescriptionParser.parseLeadOval(LanguageParser.getString("CARD_TEXT_RISE")));
                                break;
                            }
                            case "=H": {
                                parsedDescription.append(DescriptionParser.parseLeadOval(LanguageParser.getString("CARD_TEXT_HARMONY")));
                                break;
                            }
                            case "==": {
                                parsedDescription.append(DescriptionParser.parseLeadOval("\u3000\u3000\u3000\u3000"));
                                break;
                            }
                            case "=I": {
                                parsedDescription.append(DescriptionParser.parseRide());
                                break;
                            }
                            case "=L": {
                                parsedDescription.append(DescriptionParser.parseLayer("221816", "fff"));
                                break;
                            }
                            case "=D": {
                                parsedDescription.append(DescriptionParser.parseLeadOval("<i>" + LanguageParser.getString("CARD_TEXT_DECORATE") + " \u2726</i>"));
                                break;
                            }
                            case "=T": {
                                parsedDescription.append(DescriptionParser.parseTeam(LanguageParser.getString("CARD_TEXT_TEAM")));
                                break;
                            }
                            case "=E": {
                                parsedDescription.append(DescriptionParser.parseTeam(LanguageParser.getString("CARD_TEXT_TEAM_DREAM")));
                                break;
                            }
                            case "&R": {
                                parsedDescription.append(DescriptionParser.parseRise());
                                break;
                            }
                            case "&A": {
                                parsedDescription.append(DescriptionParser.parseAccessory());
                                break;
                            }
                            case "&B": {
                                parsedDescription.append(DescriptionParser.parseBeat());
                                break;
                            }
                            case "&E": {
                                parsedDescription.append(DescriptionParser.parseRecollect());
                                break;
                            }
                            case "~X": {
                                parsedDescription.append(DescriptionParser.parseCross("fff", "221816"));
                                break;
                            }
                            case "~L": {
                                parsedDescription.append(DescriptionParser.parseLayer("fff", "221816"));
                                break;
                            }
                            default: {
                                --i;
                                parsedDescription.append(c1);
                                break;
                            }
                        }
                    } else {
                        parsedDescription.append(c1);
                    }
                }
            }
            ++i;
        }
    }

    private int parseColorToken(String colorName, int i, StringBuilder parsedDescription, String description, int len) {
        char iconMod;
        char c = iconMod = i + 1 != len ? description.charAt(i + 1) : (char)'\u0000';
        if (iconMod != '0' && iconMod != 'i') {
            iconMod = '\u0000';
        }
        parsedDescription.append(DescriptionParser.parseColorIcon(colorName, iconMod));
        return iconMod != '\u0000' ? 1 : 0;
    }

    private static String parseIcon(String iconName) {
        return "<img style=\"vertical-align: middle;\" src=\"" + ImageCache.INSTANCE.getHTMLIconPath(iconName) + "\">";
    }

    private static String parseColorIcon(String colorName, char iconMod) {
        if (iconMod != '\u0000') {
            colorName = (String)colorName + iconMod;
        }
        return DescriptionParser.parseIcon("colors/" + (String)colorName);
    }

    private static String parseIcon(String iconName, int size) {
        return DescriptionParser.parseIcon(iconName, size, size);
    }

    private static String parseIcon(String iconName, int width, int height) {
        return "<img style=\"vertical-align: middle; width: " + width + "px; height: " + height + "px;\" src=\"" + ImageCache.INSTANCE.getHTMLIconPath(iconName) + "\">";
    }

    private static String parseSVGIcon(String svgXML) {
        return "<svg style=\"display: inline-block; vertical-align: middle; width: 10px; height: 10px;\" viewBox=\"0 0 4.2 4.2\">" + svgXML + "</svg>";
    }

    private static String getSVGIconTeam() {
        return "<circle cx=\"2.1167\" cy=\"2.1167\" r=\"1.9567\" stroke=\"#fff\" stroke-width=\"0.32\" fill=\"none\"/><path d=\"M2.1167,0.7938a1.3229,1.3229 0 0 0 -1.3229,1.3229 1.3229,1.3229 0 0 0 1.3229,1.3229 1.3229,1.3229 0 0 0 1.3229,-1.3229 1.3229,1.3229 0 0 0 -1.3229,-1.3229z m0,0.2033l0.9207,1.7701h-1.8419z\" fill=\"#fff\"/>";
    }

    private static String getSVGIconCross() {
        return "<path d=\"M4.23335,4.23334 2.11666,3.08725 0,4.23337 1.14612,2.1167 0,3e-5 2.11669,1.14612 4.23336,0 3.08723,2.11667 z\" fill=\"#fff\" />";
    }

    private static String parseUseTiming(boolean isHeader, String text) {
        return isHeader ? "<div style=\"display: inline-block; vertical-align: middle; width: 0; height 0; border-top: 8px solid transparent; border-bottom: 8px solid transparent; border-right: 8px solid #221816;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #221816; color: #fff; width: 120px; text-align: center; padding: 0 2px 0 2px;\"><b>" + text + "</b></div><div style=\"display: inline-block; vertical-align: middle; width: 0; height 0; border-top: 8px solid transparent; border-bottom: 8px solid transparent; border-left: 8px solid #221816;\"></div> " : "<div style=\"display: inline-block; vertical-align: middle; background: #221816; color: #fff; text-align: center; padding: 0 4px 0 4px; border: 1px solid #fff;\"><b>" + text + "</b></div>";
    }

    private static String parseLeadArrow(String colorBackground, String text, String colorText) {
        return DescriptionParser.parseLeadArrow(colorBackground, text, colorText, "");
    }

    private static String parseLeadArrow(String colorBackground, String text, String colorText, String textPrefix) {
        if (textPrefix != null && !((String)textPrefix).isBlank()) {
            textPrefix = (String)textPrefix + " ";
        }
        return "<div style=\"display: inline-block; vertical-align: middle; background: #" + colorBackground + "; color: #" + colorText + "; padding: 0 2px 0 2px;\"><b>" + (String)textPrefix + text + "</b></div><div style=\"display: inline-block; vertical-align: middle; width: 0; height 0; border-top: 8px solid transparent; border-bottom: 8px solid transparent; border-left: 8px solid #" + colorBackground + ";\"></div> ";
    }

    private static String parseCross(String colorBackground, String colorText) {
        return "<div style=\"display: inline-block; vertical-align: middle; width: 0; height 0;border-top: 8px solid #" + colorBackground + "; border-bottom: 8px solid #" + colorBackground + "; border-left: 8px solid transparent;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #" + colorBackground + "; color: #" + colorText + "; padding: 0 2px 0 2px;\"><b>" + LanguageParser.getString("CARD_TEXT_CROSS") + "</b></div><div style=\"display: inline-block; vertical-align: middle; width: 0; height 0;border-top: 8px solid #" + colorBackground + "; border-bottom: 8px solid #" + colorBackground + "; border-right: 8px solid transparent;\"></div> ";
    }

    private static String parseLeadOval(String text) {
        return "<div style=\"display: inline-block; vertical-align: middle; background: #221816; color: #fff; padding: 0 10px 0 10px; border-radius: 8px;\"><b>" + text + "</b></div> ";
    }

    private static String parseTeam(String text) {
        return "<div style=\"display: inline-block; vertical-align: middle; background: linear-gradient(to right, #eb6fa6 25%, #1eB9ee 75%); color: #fff; padding: 0 10px 0 10px; border-radius: 8px;\">" + DescriptionParser.parseIcon("formats/diva_small") + " <b>" + text + "</b></div> ";
    }

    private static String parseLayer(String colorBackground, String colorText) {
        return "<div style=\"display: inline-block; vertical-align: middle; background: #" + colorBackground + "; width: 11px; height: 11px; border-radius: 11px;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #" + colorBackground + "; color: #" + colorText + "; margin: 0 0 0 -7px; padding: 0 10px 0 10px; border-radius: 8px;\"><b>" + LanguageParser.getString("CARD_TEXT_LAYER") + "</b></div><div style=\"display: inline-block; vertical-align: middle; background: #" + colorBackground + "; margin: 0 0 0 -7px; width: 11px; height: 11px; border-radius: 11px;\"></div> ";
    }

    private static String parseRise() {
        return "<div style=\"display: inline-block; vertical-align: middle; background: #f5e1bc; margin: 10px 0 0 0;width: 6px; height: 6px;\"></div><div style=\"display: inline-block; vertical-align: middle;  background: #f5e1bc; margin: 5px 0 0 0;width: 6px; height: 11px;\"></div><div style=\"display: inline-block; vertical-align: middle;  background: #f5e1bc; color: #000; padding: 0 2px 0 2px;\"><b>" + LanguageParser.getString("CARD_TEXT_RISE") + "</b></div><div style=\"display: inline-block; vertical-align: middle;  width: 0; height 0;border-top: 8px solid #f5e1bc; border-bottom: 8px solid #f5e1bc; border-right: 8px solid transparent;\"></div> ";
    }

    private static String parseAccessory() {
        return "<div style=\"display: inline-block; vertical-align: middle; background: #234e35; width: 16px; height: 6px;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #234e35; margin: 0 0 0 -11px;width: 6px; height: 16px;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #234e35; color: #fff; margin: 0 0 0 5px; padding: 0 2px 0 2px;\"><b>" + LanguageParser.getString("CARD_TEXT_ACCESSORY") + "</b></div><div style=\"display: inline-block; vertical-align: middle; width: 0; height 0;border-top: 8px solid #234e35; border-bottom: 8px solid #234e35; border-right: 8px solid transparent;\"></div> ";
    }

    private static String parseRide() {
        return "<div style=\"display: inline-block; transform: skew(-20deg); padding: 0 0 0 3px;\"><div style=\"display: inline-block; vertical-align: middle; background: #221816; color: #fff; padding: 0 2px 0 2px;\"><b>" + LanguageParser.getString("CARD_TEXT_RIDE") + "</b></div><div style=\"display: inline-block; vertical-align: middle; width: 14px; height: 16px;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #221816; margin: 10px 0 5px -15px;width: 5px; height: 5px;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #221816; margin: 0 0 11px -5px;width: 5px; height: 5px;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #221816; margin: 10px 0 0 0;width: 5px; height: 5px;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #221816; margin: 0 0 5px -5px;width: 5px; height: 5px;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #221816; margin: 10px 0 5px 0;width: 5px; height: 5px;\"></div><div style=\"display: inline-block; vertical-align: middle; background: #221816; margin: 0 0 11px -5px;width: 5px; height: 5px;\"></div></div> ";
    }

    private static String parseWisdom(boolean showSign, String number) {
        return "<div style=\"display: inline-block; vertical-align: middle; background: #003d25; color: #fff; margin: 0 0 0 4px; padding: 0 2px 0 2px; border-top: 2px solid #92610d; border-bottom: 2px solid #92610d;\"><b>" + LanguageParser.getString("CARD_TEXT_WISDOM") + (showSign ? "=" : "") + number + "</b></div>";
    }

    private static String parsePlayerTurn(boolean isOwnTurn, String colorBackground) {
        return "<div style=\"display: inline-block; vertical-align: middle; background: #" + colorBackground + "; color: #fff; padding: 0 2px 0 2px; border: 2px ridge #fff;\"><b>" + LanguageParser.getString(isOwnTurn ? "CARD_TEXT_OWN_TURN" : "CARD_TEXT_OP_TURN") + "</b></div>";
    }

    private static String parseNumberedOval(String text, String number, String colorText) {
        return "<div style=\"display: inline-block; vertical-align: middle; background: #fff; color: #" + colorText + "; margin: 0 8px 0 0; padding: 0 20px 0 10px; border: 1px solid black; border-radius: 8px;\"><b>" + text + "</b></div><div style=\"display: inline-block; vertical-align: middle; font-family: Monospaced; color: #" + colorText + "; font-size: 12pt; margin: 0 6px 0 -24px;\"><b>" + number + "</b></div> ";
    }

    private static String parseBeat() {
        return "<div style=\"display: inline-block; vertical-align: middle; margin: 1px 4px 0 0; padding: 0 4px 0 0; border-bottom: 1px solid; border-right: 5px double;\"><div style=\"display: inline-block; vertical-align: middle; background: white; color: black; margin: 0 4px 0 0; padding: 0 4px 0 0;border-left: 5px double; border-right: 5px double; border-top: 1px solid;\"><div style=\"display: inline-block; vertical-align: middle; font-family: Impact; font-size: 12pt; margin: 0 4px 2px 4px;\"><b>\u266a</b></div><b>" + LanguageParser.getString("CARD_TEXT_BEAT") + "</b></div>";
    }

    private static String parseRecollect() {
        return "<div style=\"display: inline-block; vertical-align: middle; position: relative; margin: 1px 9px 0 0; padding: 0 4px 0 0; border-bottom: 1px solid;\"><div style=\"display: inline-block; vertical-align: middle; background: white; color: black; margin: 0 4px 0 0; padding: 0 4px 0 0;border-left: 1px solid; border-right: 1px solid; border-top: 1px solid;\"><div style=\"display: inline-block; vertical-align: middle; font-family: Impact; font-size: 12pt; margin: 0 15px 2px 0;\"><div style=\"display: inline-block; font-size: 18pt; position: absolute; top: -4px;\"><b>\u231b</b></div></div><b>" + LanguageParser.getString("CARD_TEXT_RECOLLECT") + "</b></div><div style=\"display: inline-block; vertical-align: middle; width: 0; height 0; position: absolute; right: -8px; border-top: 8px solid transparent; border-bottom: 8px solid transparent; border-left: 8px solid white;\"></div>";
    }

    private static String parseAttachedAbility(String colorBackground, String colorBorder) {
        return DescriptionParser.parseAttachedAbility(colorBackground, colorBorder, "solid", "000");
    }

    private static String parseAttachedAbility(String colorBackground, String colorBorder, String styleBorder, String colorText) {
        return "<div style=\"background-color: #" + colorBackground + "; border: 1px #" + colorBorder + " " + styleBorder + "; color: #" + colorText + "; padding: 7px 3px 3px 3px; margin: 6px 0 5px 0;\">";
    }

    private static String parseAttachedAbilityName(String colorBackground, String colorText) {
        return "<div style=\"background-color: #" + colorBackground + "; border: 1px #" + colorText + " solid; color: #" + colorText + "; margin: -12px 0 0 0; font-size: 8pt;\"><b>";
    }

    public static DescriptionParser getThemedDescriptionParser() {
        return Settings.INSTANCE.isUsingDarkTheme() ? GAME : DEFAULT;
    }

    public static String formatNumber(int number) {
        if (number == Integer.MAX_VALUE) {
            return "\u221e";
        }
        String[] digits = LanguageParser.getString("CARD_TEXT_DYNAMIC_DIGIT_FORMAT").split(",", -1);
        if (number >= 0 && number <= 9) {
            return digits[number];
        }
        String numberString = String.valueOf(number);
        if (number < 0) {
            numberString = numberString.replace("-", "--");
        }
        if (digits[0].length() > 1) {
            return numberString;
        }
        StringBuilder result = new StringBuilder();
        for (char c : numberString.toCharArray()) {
            if (c >= '0' && c <= '9') {
                result.append(digits[c - 48]);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String formatSeparator() {
        return LanguageParser.getString("CARD_TEXT_DYNAMIC_SEPARATOR");
    }
}

