/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.catalog.description;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import open.batoru.catalog.description.DescriptionModifier;
import open.batoru.data.CardConst;
import open.batoru.data.Cost;
import open.batoru.data.ModifiableString;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.cost.EnerCost;

public class EnerCostDescriptionModifier
implements DescriptionModifier {
    private static final Pattern PATTERN_ENER_COST = Pattern.compile("((?:%[WRBGKX]0?\\s*)+)(?=[^[:\uff1a]]*[:\uff1a])");
    private static final Pattern PATTERN_ALT_COST_END = Pattern.compile(" @\\[(?!@)|[:\uff1a]");
    private String defaultEnerCostDescription;
    private final HashSet<CardConst.CardColor> defaultOrderedColors = new LinkedHashSet<CardConst.CardColor>();

    public EnerCostDescriptionModifier(Ability ability) {
        Matcher matcher = PATTERN_ENER_COST.matcher(ability.getCachedAbilityDescription());
        if (matcher.find()) {
            this.defaultEnerCostDescription = matcher.group(1);
            for (String token : this.defaultEnerCostDescription.split(" ")) {
                if (token.charAt(0) != '%') continue;
                CardConst.CardColor color = CardConst.CardColor.getColorByShortLabel(token.charAt(1));
                this.defaultOrderedColors.add(color);
            }
        }
    }

    @Override
    public String processModifier(Ability ability, String description) {
        EnerCost enerCost = ability.getCostLists().stream().flatMap(costList -> costList.getDataArray().stream()).filter(EnerCost.class::isInstance).map(EnerCost.class::cast).findFirst().orElse(null);
        if (enerCost == null) {
            return description;
        }
        ModifiableString modCost = enerCost.getCostString();
        String costStringDefault = (String)modCost.getDefaultValue();
        String costStringModified = modCost.getValue();
        Map<CardConst.CardColor, Integer> mapDefault = Cost.getMappedColorsCount(costStringDefault);
        Map<CardConst.CardColor, Integer> mapModified = Cost.getMappedColorsCount(costStringModified);
        StringBuilder modifiedEnerCostDescription = new StringBuilder();
        for (CardConst.CardColor color2 : this.defaultOrderedColors) {
            int count2 = mapModified.get((Object)color2);
            if (count2 == 0 && mapDefault.get((Object)color2) == 0 && !costStringModified.isEmpty()) continue;
            for (int i = 0; i < Math.max(1, count2); ++i) {
                String background = count2 < mapDefault.get((Object)color2) ? "@G" : (count2 > 0 && i + 1 > mapDefault.get((Object)color2) ? "@R" : null);
                if (background != null) {
                    modifiedEnerCostDescription.append(background);
                }
                modifiedEnerCostDescription.append('%').append(color2.getShortLabel());
                if (count2 == 0) {
                    modifiedEnerCostDescription.append('0');
                }
                modifiedEnerCostDescription.append(background != null ? "@0 " : " ");
            }
        }
        mapModified.forEach((color, count) -> {
            if (this.defaultOrderedColors.contains(color)) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                modifiedEnerCostDescription.append("@R%").append(color.getShortLabel()).append("@0 ");
            }
        });
        if (this.defaultEnerCostDescription != null) {
            return description.replaceFirst(this.defaultEnerCostDescription, modifiedEnerCostDescription.toString().trim());
        }
        return PATTERN_ALT_COST_END.matcher(description).replaceFirst(" " + modifiedEnerCostDescription.toString().trim() + "$0");
    }
}

