/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core;

import open.batoru.core.Disposable;
import open.batoru.core.GameData;
import open.batoru.core.PlayerGameData;
import open.batoru.core.gameplay.ActionQueue;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameLog;
import open.batoru.core.gameplay.GameRules;
import open.batoru.core.gameplay.IdleStateCoordinator;
import open.batoru.core.gameplay.IndexRegistry;
import open.batoru.core.gameplay.actions.ActionOpenHand;
import open.batoru.core.gameplay.actions.ActionOpenLRIG;
import open.batoru.core.gameplay.actions.ActionOpenMulligan;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.rooms.Room;
import open.batoru.game.animations.tracker.GameSpeedController;
import open.batoru.networking.FakeGameReceiver;

public class Game
implements Disposable {
    private static Game currentGame;
    private final int gamePort;
    private final int gameId;
    private final Room room;
    private final GamePlayerRole rolePlayer;
    private GameState state = GameState.CONNECTING;
    private boolean isNeutralPerspectiveGame;
    private final GameRules rules = new GameRules();
    private final IndexRegistry indexRegistry = new IndexRegistry();
    private final ChronoRecordScheduler chronoScheduler = new ChronoRecordScheduler();
    private final IdleStateCoordinator idleStateCoordinator = new IdleStateCoordinator();
    private final GameLog log = new GameLog();
    private final ActionQueue queue = new ActionQueue();
    private final PlayerControl control = new PlayerControl();
    private final GameData data = new GameData();
    private final PlayerGameData dataHost = new PlayerGameData();
    private final PlayerGameData dataGuest = new PlayerGameData();
    private FakeGameReceiver fakeReceiver;
    private String sourceReplayChecksum;
    private GameSpeedController gameSpeedController = new GameSpeedController();

    public Game(int portOffset, int gameId, GamePlayerRole rolePlayer, Room room) {
        this.gamePort = 42007 + portOffset;
        this.gameId = gameId;
        this.rolePlayer = rolePlayer;
        this.room = room;
    }

    public void setAsNeutralPerspectiveGame() {
        this.isNeutralPerspectiveGame = true;
    }

    public boolean isNeutralPerspectiveGame() {
        return this.isNeutralPerspectiveGame;
    }

    public void initStartActions() {
        if (this.queue.getLastOrder() > 0) {
            return;
        }
        this.queue.addAction(new ActionOpenLRIG());
        this.queue.addAction(new ActionOpenHand());
        this.queue.addAction(new ActionOpenMulligan());
    }

    public void setFakeReceiver(FakeGameReceiver fakeReceiver) {
        this.fakeReceiver = fakeReceiver;
    }

    public FakeGameReceiver getFakeReceiver() {
        return this.fakeReceiver;
    }

    public void setSourceReplayChecksum(String checksum) {
        this.sourceReplayChecksum = checksum;
    }

    public String getSourceReplayChecksum() {
        return this.sourceReplayChecksum;
    }

    public GameSpeedController getGameSpeedController() {
        return this.gameSpeedController;
    }

    public int getGameServerPort() {
        return this.gamePort;
    }

    public int getGameServerPortOffset() {
        return this.gamePort - 42007;
    }

    public GamePlayerRole getPlayerRole() {
        return this.rolePlayer;
    }

    public Room getRoom() {
        return this.room;
    }

    public int getGameId() {
        return this.gameId;
    }

    public void setGameState(GameState newState) {
        this.state = newState;
    }

    public GameState getGameState() {
        return this.state;
    }

    public GameRules getGameRules() {
        return this.rules;
    }

    public IndexRegistry getIndexRegistry() {
        return this.indexRegistry;
    }

    public ChronoRecordScheduler getChronoScheduler() {
        return this.chronoScheduler;
    }

    public IdleStateCoordinator getIdleStateCoordinator() {
        return this.idleStateCoordinator;
    }

    public GameLog getGameLog() {
        return this.log;
    }

    public ActionQueue getActionQueue() {
        return this.queue;
    }

    public PlayerControl getPlayerControl() {
        return this.control;
    }

    public GameData getGameData() {
        return this.data;
    }

    public PlayerGameData getOwnPlayerData() {
        return this.getPlayerGameData(this.rolePlayer);
    }

    public PlayerGameData getPlayerGameData(GamePlayerRole rolePlayer) {
        if (rolePlayer == GamePlayerRole.HOST) {
            return this.dataHost;
        }
        if (rolePlayer == GamePlayerRole.GUEST) {
            return this.dataGuest;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void dispose() {
        this.rules.dispose();
        this.indexRegistry.dispose();
        this.chronoScheduler.dispose();
        this.idleStateCoordinator.dispose();
        this.log.dispose();
        this.queue.dispose();
        this.control.dispose();
        this.data.dispose();
        this.dataHost.dispose();
        this.dataGuest.dispose();
        this.fakeReceiver = null;
        this.gameSpeedController = null;
    }

    public static void setCurrentGame(Game game) {
        if (game == null && currentGame != null) {
            currentGame.dispose();
        }
        currentGame = game;
    }

    public static Game getCurrentGame() {
        return currentGame;
    }

    public static enum GameState {
        CONNECTING,
        DECIDE_STARTING_PLAYER,
        GAME_SETUP,
        IN_PROGRESS,
        POST_GAME;

    }

    public static enum GamePlayerRole {
        HOST,
        GUEST;


        public int getId() {
            return this.ordinal();
        }

        public static GamePlayerRole getRoleById(int id) {
            return GamePlayerRole.values()[id];
        }

        public static GamePlayerRole getOpponentRole(GamePlayerRole role) {
            return GamePlayerRole.values()[role.ordinal() ^ 1];
        }
    }
}

