/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.game._3d.Card3D;

public class GameData
implements Disposable {
    private final List<ConstantModifier> cacheActiveModifiers = new ArrayList<ConstantModifier>();
    private final Set<Card3D> cachePrivateCardsToBeCleared = new HashSet<Card3D>();
    private final List<CardIndex> cacheTempCardsWithOverriddenLocations = new ArrayList<CardIndex>();

    public void addToActiveModifiersCache(ConstantModifier modifier) {
        this.cacheActiveModifiers.add(modifier);
    }

    public void removeFromActiveModifiersCache(ConstantModifier modifier) {
        this.cacheActiveModifiers.remove(modifier);
    }

    public List<ConstantModifier> getCachedActiveModifiersList() {
        return List.copyOf(this.cacheActiveModifiers);
    }

    public void addPrivateCardImageSetToClear(Card3D card3D) {
        this.cachePrivateCardsToBeCleared.add(card3D);
    }

    public void removePrivateCardImageSetToClear(Card3D card3D) {
        this.cachePrivateCardsToBeCleared.remove(card3D);
    }

    public boolean shouldClearPrivateCardImageSet(Card3D card3D) {
        return this.cachePrivateCardsToBeCleared.contains(card3D);
    }

    public void processClearPrivateCardImageSets() {
        for (Card3D card3D : this.cachePrivateCardsToBeCleared) {
            card3D.clearCardIndex();
        }
        this.cachePrivateCardsToBeCleared.clear();
    }

    @Deprecated
    public void addTempCardWithOverriddenLocation(CardIndex cardIndex) {
        this.cacheTempCardsWithOverriddenLocations.add(cardIndex);
    }

    @Deprecated
    public void clearTempCardsWithOverriddenLocations() {
        this.cacheTempCardsWithOverriddenLocations.forEach(CardIndex::clearOverrideLocation);
        this.cacheTempCardsWithOverriddenLocations.clear();
    }

    @Override
    public void dispose() {
        this.cacheActiveModifiers.clear();
        this.cachePrivateCardsToBeCleared.clear();
        this.cacheTempCardsWithOverriddenLocations.clear();
    }
}

