/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ActionAbility;

public class PlayerGameData
implements Disposable {
    private final List<Ability> listPlayerAbilities = new ArrayList<Ability>();
    private boolean shouldReorderEffectsAtOnce;

    public void addPlayerAbility(Ability ability) {
        if (ability instanceof ActionAbility) {
            ability.setAbilityId(100 + this.listPlayerAbilities.size() + (ability.getAbilityOwner() == Game.GamePlayerRole.HOST ? 0 : 100));
        }
        this.listPlayerAbilities.add(ability);
    }

    public void removePlayerAbility(Ability ability) {
        if (this.listPlayerAbilities.contains(ability)) {
            ability.disable();
            this.listPlayerAbilities.remove(ability);
        }
    }

    public List<Ability> getPlayerAbilities() {
        return Collections.unmodifiableList(this.listPlayerAbilities);
    }

    public void setShouldReorderEffectsAtOnce(boolean set) {
        this.shouldReorderEffectsAtOnce = set;
    }

    public boolean shouldReorderEffectsAtOnce() {
        return this.shouldReorderEffectsAtOnce;
    }

    @Override
    public void dispose() {
        this.listPlayerAbilities.forEach(Ability::dispose);
        this.listPlayerAbilities.clear();
    }
}

