/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import open.batoru.Log;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.Card;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.game.FieldData;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.ui.FX;

public class CardIndex
implements TargetFilter.Targetable,
Disposable {
    public static final int UNKNOWN_INDEX = 0;
    private Card3D sourceCard3D;
    private int idCard;
    private String imageSet;
    private Card cardReference;
    private Card.IndexedInstance indexedInstance;
    private GameConst.CardLocation location;
    private GameConst.CardLocation oldLocation;
    private GameConst.CardLocation oldEffectiveLocation;
    private GameConst.CardLocation preTransientLocation;
    private GameConst.CardLocation overrideLocation;
    private CardConst.CardFace face = CardConst.CardFace.FRONT;
    private GameConst.CardUnderType underType = GameConst.CardUnderType.NONE;
    private boolean isKnownByBothPlayers;

    public CardIndex(GameConst.CardLocation location) {
        this.location = location;
    }

    public CardIndex(GameConst.CardLocation location, int idCard) {
        this.location = location;
        this.idCard = idCard;
    }

    public void setSourceCard3D(Card3D card3D) {
        this.sourceCard3D = card3D;
    }

    public Card3D getSourceCard3D() {
        return this.sourceCard3D;
    }

    public void setImageSet(int idCard, String imageSet) {
        this.idCard = idCard;
        this.imageSet = imageSet;
        this.cardReference = CardLoader.getCardByImageSet(imageSet);
        if (this.cardReference == null) {
            FX.run(() -> {
                Alert alert = new Alert(Alert.AlertType.ERROR, "Fatal Error!\nAttempted to create an index of an unknown card.\n#(" + idCard + ") ImageSet: \"" + imageSet + "\"\nPlease, update the game!", new ButtonType[0]);
                alert.showAndWait();
                Platform.exit();
            });
            return;
        }
        if (this.indexedInstance != null) {
            System.out.println(">>> POTENTIAL UNDISPOSED CARD INDEX INSTANCE: " + String.valueOf(this.indexedInstance));
        }
        TargetFilter.setDefaultSources(this, null);
        this.indexedInstance = this.cardReference.newIndexedInstance(idCard);
        this.indexedInstance.initCardAbilities();
    }

    public void setTokenImageSet(int idCard, String imageSet) {
        this.idCard = idCard;
        this.imageSet = imageSet;
        this.cardReference = CardLoader.getCardByImageSet(imageSet);
    }

    public void clearImageSet() {
        this.idCard = 0;
        this.imageSet = null;
        this.cardReference = null;
        if (this.indexedInstance != null) {
            this.indexedInstance.dispose();
            this.indexedInstance = null;
        }
        this.isKnownByBothPlayers = false;
    }

    public void setLocation(GameConst.CardLocation location) {
        this.oldLocation = this.location;
        if (this.oldLocation != GameConst.CardLocation.LOOKED && this.oldLocation != GameConst.CardLocation.REVEALED) {
            this.oldEffectiveLocation = this.oldLocation;
        }
        this.location = location;
    }

    void updateId(int id) {
        this.idCard = id;
    }

    public void setOldLocation(GameConst.CardLocation location) {
        this.oldLocation = location;
    }

    public void updatePreTransientLocation() {
        this.preTransientLocation = this.location;
    }

    public void updateOverrideLocation() {
        if (this.location == GameConst.CardLocation.LOOKED || this.location == GameConst.CardLocation.REVEALED) {
            return;
        }
        this.overrideLocation = this.location;
    }

    public void resetOverrideLocation() {
        if (this.overrideLocation == null || this.location == GameConst.CardLocation.LOOKED || this.location == GameConst.CardLocation.REVEALED || this.overrideLocation == this.oldLocation) {
            return;
        }
        this.overrideLocation = null;
    }

    @Deprecated
    public void clearOverrideLocation() {
        this.overrideLocation = null;
    }

    public boolean wasMovedByOverride() {
        return this.overrideLocation == this.oldLocation || this.overrideLocation == this.location;
    }

    public void setCardFace(CardConst.CardFace face) {
        this.face = face;
    }

    public boolean isFaceUp() {
        return this.face == CardConst.CardFace.FRONT;
    }

    public final void setUnderType(GameConst.CardUnderType underType) {
        this.underType = underType;
    }

    public final GameConst.CardUnderType getUnderType() {
        return this.underType;
    }

    public void markAsKnownByBothPlayers(boolean isKnown) {
        this.isKnownByBothPlayers = isKnown;
    }

    public boolean isKnownByBothPlayers() {
        return this.isKnownByBothPlayers;
    }

    public int getId() {
        return this.idCard;
    }

    public String getImageSet() {
        return this.imageSet;
    }

    public Card getCardReference() {
        return this.cardReference;
    }

    public Card.IndexedInstance getIndexedInstance() {
        return this.indexedInstance;
    }

    public GameConst.CardLocation getLocation() {
        return this.location;
    }

    public GameConst.CardLocation getOldLocation() {
        return this.oldLocation;
    }

    public GameConst.CardLocation getOldEffectiveLocation() {
        return this.oldEffectiveLocation;
    }

    public GameConst.CardLocation getPreTransientLocation() {
        return this.preTransientLocation;
    }

    public boolean isSIGNIOnField() {
        return this.isFaceUp() && GameConst.CardLocation.isSIGNI(this.location) && this.getZoneByLocation().getTopCard() != null && this.getZoneByLocation().getTopCard().getCardIndex() == this;
    }

    public Zone getZoneByLocation() {
        return FieldData.getZoneByLocation(this.getCurrentOwnerSafe(), this.getLocation());
    }

    public Game.GamePlayerRole getCurrentOwnerSafe() {
        return this.indexedInstance != null ? this.indexedInstance.getCurrentOwner() : (this.sourceCard3D != null ? Card3D.getCurrentOwner(this.sourceCard3D) : CardIndex.getOriginalOwner(this.idCard));
    }

    public static Game.GamePlayerRole getOriginalOwner(int idCard) {
        if (idCard == 0) {
            throw new IllegalArgumentException();
        }
        return idCard > 0 ? Game.GamePlayerRole.HOST : Game.GamePlayerRole.GUEST;
    }

    public static boolean isOwnCard(CardIndex cardIndex) {
        return cardIndex.getCurrentOwnerSafe() == Game.getCurrentGame().getPlayerRole();
    }

    public boolean isEffectivelyAtLocation(GameConst.CardLocation location) {
        return this.getLocation() == location || (this.getLocation() == GameConst.CardLocation.REVEALED || this.getLocation() == GameConst.CardLocation.LOOKED) && this.getOldLocation() == location;
    }

    public boolean isInDefaultExpectedLocation() {
        return this.isInDefaultExpectedLocation(this.location);
    }

    public boolean isInDefaultExpectedLocation(GameConst.CardLocation location) {
        if (this.cardReference == null) {
            return false;
        }
        return switch (this.cardReference.getType()) {
            default -> throw new MatchException(null, null);
            case CardConst.CardType.LRIG -> {
                if (location == GameConst.CardLocation.LRIG || location == GameConst.CardLocation.LRIG_ASSIST_LEFT || location == GameConst.CardLocation.LRIG_ASSIST_RIGHT) {
                    yield true;
                }
                yield false;
            }
            case CardConst.CardType.LRIG_ASSIST -> {
                if (location == GameConst.CardLocation.LRIG_ASSIST_LEFT || location == GameConst.CardLocation.LRIG_ASSIST_RIGHT || location == GameConst.CardLocation.TRASH_LRIG) {
                    yield true;
                }
                yield false;
            }
            case CardConst.CardType.SIGNI, CardConst.CardType.RESONA -> GameConst.CardLocation.isSIGNI(location);
            case CardConst.CardType.SPELL, CardConst.CardType.ARTS, CardConst.CardType.PIECE -> {
                if (location == GameConst.CardLocation.CHECK_ZONE) {
                    yield true;
                }
                yield false;
            }
            case CardConst.CardType.KEY -> {
                if (location == GameConst.CardLocation.KEY) {
                    yield true;
                }
                yield false;
            }
            case CardConst.CardType.TOKEN -> true;
        };
    }

    public double getSIGNILimitConsumption() {
        if (!CardConst.CardType.isSIGNI(this.cardReference.getType())) {
            return 0.0;
        }
        return this.indexedInstance.getLimit().getValue() == 0.0 ? (double)this.indexedInstance.getLevel().getValue().intValue() : this.indexedInstance.getLimit().getValue();
    }

    @Override
    public void dispose() {
        this.clearImageSet();
        this.sourceCard3D = null;
        this.underType = null;
    }

    public static Optional<Card3D> getCardFromPacketData(String data) {
        return CardIndex.getCardFromPacketData(data, Zone.ZonePosition.TOP);
    }

    public static Optional<Card3D> getCardFromPacketData(String data, Zone.ZonePosition zonePosition) {
        if (data.isEmpty() || data.equals(String.valueOf(0))) {
            return Optional.empty();
        }
        String[] args = data.split("~");
        if (args.length == 3) {
            int cardId = Integer.parseInt(args[0]);
            String imageSet = CardDataImageSet.decompressImageSetData(args[1]);
            Zone zone = FieldData.getZoneByLocation(CardIndex.getOriginalOwner(cardId), GameConst.CardLocation.getLocationByShortLabel(args[2]));
            if (zone == null) {
                return Optional.empty();
            }
            Card3D card3D = zone.getPrivateCard(imageSet, cardId, zonePosition);
            Log.printMessage("REQUEST PUBLIC <<< " + String.valueOf(card3D) + " " + imageSet + " " + cardId);
            String oldImageSet = card3D.getCardIndex().getImageSet();
            if (card3D.getCardIndex().getIndexedInstance() == null || !imageSet.equals(oldImageSet)) {
                if (oldImageSet != null && !imageSet.equals(oldImageSet)) {
                    Log.printMessage(true, "Warning: Direct CardIndex/imageSet replacement! This shouldn't happen!! (" + oldImageSet + " -> " + imageSet + ")");
                }
                Game.getCurrentGame().getIndexRegistry().addIndex(cardId, card3D.getCardIndex());
                card3D.setImageSet(cardId, imageSet);
            } else if (card3D.getCardIndex().getId() != cardId) {
                card3D.getCardIndex().updateId(cardId);
            }
            return Optional.of(card3D);
        }
        if (args.length == 2) {
            Game.GamePlayerRole rolePlayer = Game.GamePlayerRole.getRoleById(Integer.parseInt(args[0]));
            Zone zone = FieldData.getZoneByLocation(rolePlayer, GameConst.CardLocation.getLocationByShortLabel(args[1]));
            if (zone == null) {
                return Optional.empty();
            }
            Card3D card3D = zone.getPrivateCard(null, 0, zonePosition);
            Log.printMessage("REQUEST PRIVATE >>> " + String.valueOf(card3D));
            return Optional.of(card3D);
        }
        if (args.length == 1 && args[0].charAt(0) != '!') {
            int cardId = Integer.parseInt(args[0]);
            CardIndex cardIndex = Game.getCurrentGame().getIndexRegistry().getIndex(cardId);
            return Optional.ofNullable(cardIndex).map(CardIndex::getSourceCard3D);
        }
        return Optional.empty();
    }

    public static void assignCardFromShortPacketData(String data, Card3D card3D) {
        if (card3D == null || data.isEmpty() || data.equals(String.valueOf(0))) {
            return;
        }
        String[] args = data.split("~");
        int cardId = Integer.parseInt(args[0]);
        if (args.length > 1) {
            String imageSet = CardDataImageSet.decompressImageSetData(args[1]);
            CardIndex cardIndex = Game.getCurrentGame().getIndexRegistry().getIndex(cardId);
            if (cardIndex != null && imageSet.equals(cardIndex.getImageSet()) && card3D.getCardIndex() == cardIndex) {
                return;
            }
            Game.getCurrentGame().getIndexRegistry().addIndex(cardId, card3D.getCardIndex());
            FX.run(() -> card3D.setImageSet(cardId, imageSet));
        } else {
            FX.run(() -> card3D.setImageSet(cardId, Game.getCurrentGame().getIndexRegistry().getIndex(cardId).getImageSet()));
        }
    }
}

