/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;

public class ChronoDuration {
    private final ChronoStateHandler handler;
    private int ticks = 1;
    private boolean shouldAutoAdaptPhaseEndCheck;
    private boolean adaptedIsPhaseEnd;

    public ChronoDuration(ChronoStateHandler handler) {
        this.handler = handler;
    }

    public ChronoDuration(ChronoDuration chronoDuration) {
        this.handler = chronoDuration.getStateHandler();
        this.ticks = chronoDuration.getTicks();
        this.adaptedIsPhaseEnd = false;
        this.shouldAutoAdaptPhaseEndCheck = false;
    }

    public ChronoDuration(ChronoStateHandler handler, boolean adaptedIsPhaseEnd) {
        this(handler);
        this.adaptedIsPhaseEnd = adaptedIsPhaseEnd;
    }

    public ChronoDuration repeat(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public void setShouldAutoAdaptPhaseEndCheck(boolean set) {
        this.shouldAutoAdaptPhaseEndCheck = set;
    }

    private ChronoStateHandler getStateHandler() {
        return this.handler;
    }

    public int getTicks() {
        return this.ticks;
    }

    protected boolean check(Game.GamePlayerRole roleTurnPlayer, GameConst.GamePhase currentPhase, boolean isPhaseEnd) {
        return this.handler.check(roleTurnPlayer, currentPhase, isPhaseEnd || this.shouldAutoAdaptPhaseEndCheck && this.adaptedIsPhaseEnd) && --this.ticks <= 0;
    }

    public static ChronoDuration turnEnd() {
        return new ChronoDuration((roleTurnPlayer, currentPhase, isPhaseEnd) -> currentPhase == GameConst.GamePhase.END && isPhaseEnd, true);
    }

    public static ChronoDuration nextTurn(Game.GamePlayerRole rolePlayer) {
        return new ChronoDuration((roleTurnPlayer, currentPhase, isPhaseEnd) -> roleTurnPlayer == rolePlayer && currentPhase == GameConst.GamePhase.UP && !isPhaseEnd, false);
    }

    public static ChronoDuration nextTurnEnd(Game.GamePlayerRole rolePlayer) {
        return new ChronoDuration((roleTurnPlayer, currentPhase, isPhaseEnd) -> roleTurnPlayer == rolePlayer && currentPhase == GameConst.GamePhase.END && isPhaseEnd, true);
    }

    public static ChronoDuration nextPhase() {
        return new ChronoDuration((roleTurnPlayer, currentPhase, isPhaseEnd) -> !isPhaseEnd, false);
    }

    public static ChronoDuration nextPhase(GameConst.GamePhase phase) {
        return new ChronoDuration((roleTurnPlayer, currentPhase, isPhaseEnd) -> currentPhase == phase && !isPhaseEnd, false);
    }

    public static ChronoDuration nextPhase(Game.GamePlayerRole rolePlayer, GameConst.GamePhase phase) {
        return new ChronoDuration((roleTurnPlayer, currentPhase, isPhaseEnd) -> roleTurnPlayer == rolePlayer && currentPhase == phase && !isPhaseEnd, false);
    }

    public static ChronoDuration nextPhaseEnd() {
        return new ChronoDuration((roleTurnPlayer, currentPhase, isPhaseEnd) -> isPhaseEnd, false);
    }

    public static ChronoDuration nextPhaseEnd(GameConst.GamePhase phase) {
        return new ChronoDuration((roleTurnPlayer, currentPhase, isPhaseEnd) -> currentPhase == phase && isPhaseEnd, false);
    }

    public static ChronoDuration nextPhaseEnd(Game.GamePlayerRole rolePlayer, GameConst.GamePhase phase) {
        return new ChronoDuration((roleTurnPlayer, currentPhase, isPhaseEnd) -> roleTurnPlayer == rolePlayer && currentPhase == phase && isPhaseEnd, false);
    }

    public static ChronoDuration permanent() {
        return null;
    }

    @FunctionalInterface
    public static interface ChronoStateHandler {
        public boolean check(Game.GamePlayerRole var1, GameConst.GamePhase var2, boolean var3);
    }
}

