/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.callback.EffectCallbackThread;
import open.batoru.data.CardConst;
import open.batoru.data.ability.Ability;

public class CutInResponse {
    private final EffectCallbackThread sourceEffectCallback;
    private final Ability sourceAbility;
    private boolean hasBeenResponded;
    private boolean isWaitingForOpponentResponse;

    public CutInResponse(EffectCallbackThread sourceEffectCallback, Ability sourceAbility) {
        this.sourceEffectCallback = sourceEffectCallback;
        this.sourceAbility = sourceAbility;
    }

    public EffectCallbackThread getSourceCallbackThread() {
        return this.sourceEffectCallback;
    }

    public EffectBucket getSourceEffectBucket() {
        return Game.getCurrentGame().getGameRules().getEffectProcessor().getSourceBucket(this.sourceAbility);
    }

    public CardConst.CardType getCutInCardType() {
        return this.getSourceCardIndex().getCardReference().getType();
    }

    public CardIndex getSourceCardIndex() {
        return this.sourceAbility.getSourceCardIndex();
    }

    public Ability getSourceAbility() {
        return this.sourceAbility;
    }

    public void setIsWaitingForOpponentResponse(boolean set) {
        this.isWaitingForOpponentResponse = set;
    }

    public boolean isWaitingForOpponentResponse() {
        return this.isWaitingForOpponentResponse;
    }

    public void setHasBeenResponded() {
        this.hasBeenResponded = true;
    }

    public boolean hasBeenResponded() {
        return this.hasBeenResponded;
    }
}

