/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.ArrayList;
import java.util.List;
import open.batoru.Log;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEffectActivatePayCost;
import open.batoru.core.gameplay.actions.ActionEffectManualWaitReorder;
import open.batoru.core.gameplay.actions.ActionEffectWaitReorder;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.AutoAbility;
import open.batoru.data.ability.CardAbilities;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.LifeBurstAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.overlay.log.events.LogEventEffectTrigger;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class EffectBucket
implements Disposable {
    private final Game.GamePlayerRole rolePlayer;
    private final List<Ability> listAbilities = new ArrayList<Ability>();
    private final List<GameEvent> listEvents = new ArrayList<GameEvent>();
    private final List<CardIndex> cacheToClear = new ArrayList<CardIndex>();
    private boolean shouldReorderEffects;
    private int numReorderLocks;
    private int numCompletedReorderLockEffects;
    private int numCompletedEffects;
    private Ability currentAbility;
    private GameEvent currentEvent;
    private static Ability lastAbility;
    private static GameEvent lastEvent;
    private static Ability currentResolvingAbility;
    private static GameEvent currentResolvingEvent;

    public EffectBucket(Game.GamePlayerRole rolePlayer) {
        this.rolePlayer = rolePlayer;
    }

    public static void setLastAbilityAndEvent(Ability ability, GameEvent event) {
        lastAbility = ability;
        lastEvent = event;
    }

    public static Ability getLastAbility() {
        return lastAbility;
    }

    public static GameEvent getLastEvent() {
        return lastEvent;
    }

    public void resetReorderLock() {
        if (this.numReorderLocks > 0) {
            --this.numReorderLocks;
            ++this.numCompletedReorderLockEffects;
        }
    }

    public void prepareAbilities(GameEvent event) {
        if (event == null) {
            return;
        }
        Ability cacheCurrentResolvingAbility = currentResolvingAbility;
        GameEvent cacheCurrentResolvingEvent = currentResolvingEvent;
        EffectBucket.setCurrentResolvingAbilityAndEvent(null, null);
        this.currentEvent = event;
        ArrayList<Ability> cacheAvailableAbilities = new ArrayList<Ability>();
        Game.getCurrentGame().getGameRules().getEffectProcessor().cacheAvailableAbilities(cacheAvailableAbilities, this.rolePlayer);
        cacheAvailableAbilities.forEach(this::processAbility);
        EffectBucket.setCurrentResolvingAbilityAndEvent(cacheCurrentResolvingAbility, cacheCurrentResolvingEvent);
    }

    private void processAbility(Ability ability) {
        this.currentAbility = ability;
        EffectBucket.setLastAbilityAndEvent(ability, this.currentEvent);
        TargetFilter.setDefaultSources(ability.getSourceCardIndex(), ability);
        if (!(ability.isDisabled() && !ability.isAlwaysActive() || ability.isMuted() || !ability.isActiveDuringEvent(this.currentEvent) || ability.isBonded() && !ability.getSourceCardIndex().getIndexedInstance().hasActiveBond() || ability.isActiveBySelfSourceOnly() && this.currentEvent.getCallerCardIndex() != ability.getSourceCardIndex() || !ability.isInActiveLocation() || ability.getConditionState(this.currentEvent.getCallerCardIndex()) == AbilityCondition.ConditionState.BAD || ability.isActiveOncePerEffect() && ability.getLastCostCallbackAction() == AbilityCost.getCallbackAction() && ability.getLastEffectCallbackAction() == CardAbilities.getEffectCallbackAction())) {
            AutoAbility autoAbility;
            if (!ability.isUseLimited()) {
                if (ability.isActiveOncePerEffect()) {
                    ability.setLastCostCallbackAction(AbilityCost.getCallbackAction());
                    ability.setLastEffectCallbackAction(CardAbilities.getEffectCallbackAction());
                }
                Log.printMessage(">>> added: " + String.valueOf(ability));
                this.addEffectToBucket(ability);
                ability.onAbilityAddedToBucket();
            }
            if (ability instanceof AutoAbility && (autoAbility = (AutoAbility)ability).getEventAccumulator() != null) {
                autoAbility.getEventAccumulator().process(this.currentEvent);
            }
        }
    }

    private void addEffectToBucket(Ability ability) {
        LogEventEffectTrigger logEventEffectTrigger = new LogEventEffectTrigger(ability);
        if (!(ability instanceof CheckZoneAbility)) {
            this.listAbilities.add(ability);
            this.listEvents.add(this.currentEvent);
            FX.run(() -> {
                UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().addEffect(ability);
                UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEventEffectTrigger);
            });
            if (this.numReorderLocks == 0) {
                this.shouldReorderEffects = true;
            }
        } else {
            this.listAbilities.add(this.numReorderLocks, ability);
            this.listEvents.add(this.numReorderLocks, this.currentEvent);
            int prevReorderLocks = this.numReorderLocks++;
            FX.run(() -> {
                UI.getTabGame().getFieldSceneOverlay().getEffectsSidebar().addEffect(ability, prevReorderLocks);
                UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(logEventEffectTrigger);
            });
        }
    }

    public void resolveNext() {
        if (this.numReorderLocks > 0 || !this.shouldReorderEffects || this.numCompletedEffects == this.listAbilities.size() - 1) {
            this.currentAbility = this.listAbilities.get(this.numReorderLocks == 0 ? this.numCompletedEffects : this.numCompletedReorderLockEffects);
            this.currentEvent = this.listEvents.get(this.numReorderLocks == 0 ? this.numCompletedEffects : this.numCompletedReorderLockEffects);
            Game.getCurrentGame().getActionQueue().addAction(new ActionEffectActivatePayCost(this.currentAbility, this.currentEvent));
            if (!Game.getCurrentGame().getPlayerGameData(this.rolePlayer).shouldReorderEffectsAtOnce()) {
                this.shouldReorderEffects = true;
            }
        } else {
            int remainingEffects = this.getAbilitiesNum() - this.getCompletedEffectsNum();
            if (remainingEffects > 1 || !Game.getCurrentGame().getPlayerGameData(this.rolePlayer).shouldReorderEffectsAtOnce()) {
                this.reorderEffects();
            } else {
                this.shouldReorderEffects = false;
                this.resolveNext();
            }
        }
    }

    private void reorderEffects() {
        GameAction action = PlayerControl.isChoosingPlayer(this.getOwner()) ? new ActionEffectManualWaitReorder(this) : new ActionEffectWaitReorder(this);
        action.setOnActionCompleted(() -> {
            this.shouldReorderEffects = false;
            this.resolveNext();
        });
        Game.getCurrentGame().getActionQueue().addAction(action);
    }

    public void setEffectAsCompleted() {
        ++this.numCompletedEffects;
        if (this.hasNextAbility()) {
            CardIndex sourceCardIndex = this.listAbilities.get(this.numCompletedEffects).getSourceCardIndex();
            if (this.cacheToClear.remove(sourceCardIndex)) {
                sourceCardIndex.getSourceCard3D().clearCardIndex();
            }
        } else {
            this.clear();
        }
    }

    public boolean hasNextAbility() {
        return this.numCompletedEffects < this.listAbilities.size();
    }

    public Ability getNextAbility() {
        return this.hasNextAbility() ? this.listAbilities.get(this.numCompletedEffects) : null;
    }

    public boolean hasNoAwaitingAbilities(CardIndex cardIndex) {
        return cardIndex == null || this.listAbilities.stream().skip(this.numCompletedEffects).noneMatch(ability -> ability.getSourceCardIndex() == cardIndex);
    }

    public void setClearCardIndexAfterFinalResolution(CardIndex cardIndex) {
        if (!this.cacheToClear.contains(cardIndex)) {
            this.cacheToClear.add(cardIndex);
        }
    }

    public void terminate() {
        for (Ability ability : this.listAbilities) {
            ability.onAbilityEnd(false);
        }
        this.clear();
    }

    void clear() {
        this.shouldReorderEffects = false;
        this.numCompletedReorderLockEffects = 0;
        this.numCompletedEffects = 0;
        this.listAbilities.clear();
        this.listEvents.clear();
        for (CardIndex cardIndex : this.cacheToClear) {
            cardIndex.getSourceCard3D().clearCardIndex();
        }
        this.cacheToClear.clear();
    }

    public int getAbilitiesNum() {
        return this.listAbilities.size();
    }

    public int getCompletedEffectsNum() {
        return this.numCompletedEffects;
    }

    public List<Ability> getAbilityList() {
        return this.listAbilities;
    }

    public List<GameEvent> getEventList() {
        return this.listEvents;
    }

    public Game.GamePlayerRole getOwner() {
        return this.rolePlayer;
    }

    @Override
    public void dispose() {
        this.listAbilities.clear();
        this.listEvents.clear();
        this.cacheToClear.clear();
        this.currentAbility = null;
        this.currentEvent = null;
    }

    public static Ability getCurrentResolvingAbility() {
        return currentResolvingAbility;
    }

    public static GameEvent getCurrentResolvingEvent() {
        return currentResolvingEvent;
    }

    public static void setCurrentResolvingAbilityAndEvent(Ability ability, GameEvent event) {
        currentResolvingAbility = ability;
        currentResolvingEvent = event;
    }

    public static boolean isAbilityMandatory(Ability ability) {
        return ability.getCostLists().isEmpty() || ability instanceof CheckZoneAbility || ability instanceof LifeBurstAbility || ability instanceof ActionAbility && AbilityCostList.canPayDataCostLists(ability.getCostLists());
    }
}

