/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.scene.paint.Color;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.parsers.LanguageParser;

public final class GameConst {
    public static final int DECK_CARDLIMIT_MAIN = 40;
    public static final int DECK_CARDLIMIT_LRIG = 10;
    public static final int DECK_CARDLIMIT_LRIG_DIVA = 12;
    public static final int DECK_CARDLIMIT_LIFEBURST = 20;
    public static final int DECK_CARDLIMIT_PIECE_TEAM = 1;
    public static final int DECK_DUPLICATE_MAX_MAIN = 4;
    public static final int DECK_DUPLICATE_MAX_LRIG = 1;
    public static final int GAME_LIFECLOTH_START = 7;
    public static final int GAME_HAND_START = 5;
    public static final int GAME_HAND_MAX = 6;
    public static final int GAME_HAND_TURNDRAW_FIRST = 1;
    public static final int GAME_HAND_TURNDRAW = 2;
    public static final int GAME_REFRESH_MAX_TURN = 2;
    public static final int GAME_MAX_LEVEL = 5;
    public static final int GAME_MAX_COINS = 5;
    public static final int GAME_MAX_SIGNI_ON_FIELD = 4;
    public static final int ANI_PSEUDO_REVEAL_DELAY = 300;
    public static final int ROOM_MAX_DESCRIPTION_LEN = 32;
    public static final int ROOM_MAX_PASSWORD_LEN = 12;

    private GameConst() {
    }

    public static enum SIGNIZonePosition {
        LEFT(0, CardLocation.SIGNI_LEFT),
        CENTER(1, CardLocation.SIGNI_CENTER),
        RIGHT(2, CardLocation.SIGNI_RIGHT);

        private final int id;
        private final CardLocation location;
        private static final Map<Integer, SIGNIZonePosition> mapId;

        private SIGNIZonePosition(int id, CardLocation location) {
            this.id = id;
            this.location = location;
        }

        public int getId() {
            return this.id;
        }

        public CardLocation getLocation() {
            return this.location;
        }

        public static SIGNIZonePosition getSIGNIPositionById(int id) {
            return mapId.get(id);
        }

        public static SIGNIZonePosition getSIGNIPositionByCardLocation(CardLocation cardLocation) {
            return switch (cardLocation.ordinal()) {
                case 11 -> LEFT;
                case 12 -> CENTER;
                case 13 -> RIGHT;
                default -> null;
            };
        }

        public static SIGNIZonePosition getOppositeSIGNIPosition(SIGNIZonePosition zonePosition) {
            return switch (zonePosition.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> RIGHT;
                case 1 -> CENTER;
                case 2 -> LEFT;
            };
        }

        static {
            mapId = Arrays.stream(SIGNIZonePosition.values()).collect(Collectors.toMap(SIGNIZonePosition::getId, Function.identity()));
        }
    }

    public static enum CardUnderType {
        NONE(0, CardUnderCategory.NONE, null, null),
        ATTACHED_GENERIC(0, CardUnderCategory.ATTACHED, Color.rgb((int)80, (int)100, (int)80), "attach_generic"),
        ATTACHED_CHARM(8, CardUnderCategory.ATTACHED, Color.rgb((int)140, (int)0, (int)140), "charm"),
        ATTACHED_ACCESSORY(16, CardUnderCategory.ATTACHED, Color.rgb((int)40, (int)120, (int)80), "accessory"),
        ATTACHED_SOUL(32, CardUnderCategory.ATTACHED, Color.rgb((int)110, (int)100, (int)0), "soul"),
        UNDER_GENERIC(0, CardUnderCategory.UNDER, Color.rgb((int)80, (int)80, (int)80), "under_generic"),
        UNDER_RISE(64, CardUnderCategory.UNDER, Color.rgb((int)125, (int)110, (int)100), "rise"),
        UNDER_BLOOD_CRYSTAL_ARM(128, CardUnderCategory.UNDER, Color.rgb((int)140, (int)0, (int)0), "blood"),
        ZONE_GENERIC(0, CardUnderCategory.ZONE, Color.rgb((int)140, (int)140, (int)200), "zone_generic"),
        ZONE_VIRUS(256, CardUnderCategory.ZONE, Color.rgb((int)125, (int)140, (int)90), "virus"),
        ZONE_TRAP(512, CardUnderCategory.ZONE, Color.rgb((int)120, (int)80, (int)255), "trap"),
        ZONE_SEED(1024, CardUnderCategory.ZONE, Color.rgb((int)170, (int)150, (int)80), "seed"),
        ZONE_GATE(2048, CardUnderCategory.ZONE, Color.rgb((int)0, (int)128, (int)255), "gate"),
        ZONE_HASTALYK(4096, CardUnderCategory.ZONE, Color.rgb((int)0, (int)0, (int)255), "hastalyk"),
        ZONE_MAGIC_BOX(8192, CardUnderCategory.ZONE, Color.rgb((int)180, (int)180, (int)0), "magic_box");

        private final int flags;
        private final CardUnderCategory underCategory;
        private final Color color;
        private final String textureName;

        private CardUnderType(int flags, CardUnderCategory underCategory, Color color, String textureName) {
            this.flags = flags | underCategory.getFlags();
            this.underCategory = underCategory;
            this.color = color;
            this.textureName = textureName;
        }

        public int getFlags() {
            return this.flags;
        }

        public CardUnderCategory getUnderCategory() {
            return this.underCategory;
        }

        public Color getColor() {
            return this.color;
        }

        public String getTextureName() {
            return this.textureName;
        }
    }

    public static enum CardUnderCategory {
        NONE(0, "", TargetFilter.TargetHint.GENERIC),
        ATTACHED(1, "UNDER_CATEGORY_INFO_ATTACHED", TargetFilter.TargetHint.ATTACH),
        UNDER(2, "UNDER_CATEGORY_INFO_UNDER", TargetFilter.TargetHint.UNDER),
        ZONE(4, "UNDER_CATEGORY_INFO_ZONE", TargetFilter.TargetHint.ZONE);

        private final int flags;
        private final String label;
        private final TargetFilter.TargetHint targetHint;

        private CardUnderCategory(int flags, String label, TargetFilter.TargetHint targetHint) {
            this.flags = flags;
            this.label = LanguageParser.getString(label);
            this.targetHint = targetHint;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getLabel() {
            return this.label;
        }

        public TargetFilter.TargetHint getTargetHint() {
            return this.targetHint;
        }
    }

    public static enum UseCondition {
        RISE,
        RESONA,
        GROW;

    }

    public static class AttackModifierFlag {
        public static final int DEFAULT = 0;
        public static final int CANT_ATTACK = 1;
        public static final int ASSASSIN = 2;
        public static final int DOUBLE_CRUSH = 4;
        public static final int TRIPLE_CRUSH = 8;
        public static final int FORCE_ATTACK = 16;
        public static final int ASSIST_ATTACK = 32;
    }

    public static class CardStateFlag {
        public static final int NONE = 0;
        public static final int HAS_LIFEBURST = 1;
        public static final int CAN_GUARD = 2;
        public static final int HAS_TRAP = 4;
        public static final int IS_CRAFT = 8;
        public static final int IS_RELAY = 16;
        public static final int IS_DISSONA = 32;
        public static final int UNDECIDED_LIFEBURST = 64;
        public static final int KILL_ME = 256;
        public static final int STOLEN = 512;
        public static final int ENTERED_FIELD_ATONCE = 1024;
        public static final int TRANSIENT_PERSIST_EFFECT = 2048;
        public static final int DONT_RESET_STATS = 4096;
        public static final int DOWNED = 16384;
        public static final int ATTACKING = 32768;
        public static final int FROZEN = 65536;
        public static final int CROSSED_LEFT = 131072;
        public static final int CROSSED_RIGHT = 262144;
        public static final int BLOOD_CRYSTAL_ARMED = 524288;
        public static final int AWAKENED = 0x100000;
        public static final int IN_DRIVE = 0x200000;
        public static final int MASK_RETAIN_FLAGS = 6664;
        public static final int MASK_STATE_FLAGS = 1654792;
    }

    public static enum GameEventId {
        ABILITY,
        ABILITY_ACTION,
        ABILITY_DELAYED,
        ABILITY_LIFEBURST,
        LIFEBURST,
        ENTER,
        GROW,
        ATTACK,
        ATTACK_BATTLE,
        BANISH,
        TRASH,
        FREEZE,
        DRAW,
        DISCARD,
        ENER,
        CRUSH,
        DAMAGE,
        GUARD,
        REVEAL,
        MOVE,
        MOVE_UNDER,
        PLACE,
        RISE,
        HEAVEN,
        DRIVE,
        EXCEED,
        POWER_CHANGED,
        UP,
        DOWN,
        ATTACH,
        TARGET,
        ABILITY_GAIN,
        USE_SPELL,
        USE_ARTS,
        USE_PIECE,
        PHASE_START,
        PHASE_END,
        REFRESH,
        TRANSFORM,
        COIN;

    }

    public static enum GamePhase {
        UP("UI_GAME_PHASE_UP"),
        DRAW("UI_GAME_PHASE_DRAW"),
        ENER("UI_GAME_PHASE_ENER"),
        GROW("UI_GAME_PHASE_GROW"),
        MAIN("UI_GAME_PHASE_MAIN"),
        ATTACK_PRE("UI_GAME_PHASE_ATTACK_PREATK"),
        ATTACK_DEF("UI_GAME_PHASE_ATTACK_DEF"),
        ATTACK_SIGNI("UI_GAME_PHASE_ATTACK_SIGNI"),
        ATTACK_LRIG("UI_GAME_PHASE_ATTACK_LRIG"),
        END("UI_GAME_PHASE_END");

        private final String longLabel;
        private final String label;

        private GamePhase(String label) {
            this.longLabel = LanguageParser.getString(label + "_LONG");
            this.label = LanguageParser.getString(label);
        }

        public String getLongLabel() {
            return this.longLabel;
        }

        public String getLabel() {
            return this.label;
        }

        public static boolean isAttackPhase(GamePhase gamePhase) {
            return gamePhase == ATTACK_PRE || gamePhase == ATTACK_DEF || gamePhase == ATTACK_SIGNI || gamePhase == ATTACK_LRIG;
        }
    }

    public static enum CardLocation {
        DECK_MAIN("D"),
        DECK_LRIG("DL"),
        TRASH("T"),
        TRASH_LRIG("TL"),
        HAND("H"),
        ENER("E"),
        CHECK_ZONE("CZ"),
        LIFE_CLOTH("LC"),
        LRIG("L"),
        LRIG_ASSIST_LEFT("LL"),
        LRIG_ASSIST_RIGHT("LR"),
        SIGNI_LEFT("SL"),
        SIGNI_CENTER("SC"),
        SIGNI_RIGHT("SR"),
        KEY("K"),
        CHEER("C"),
        REVEALED("R"),
        LOOKED("O"),
        BEAT("B"),
        EXCLUDED("X");

        private final String shortLabel;
        private static final Map<String, CardLocation> mapLabelsShort;

        private CardLocation(String shortLabel) {
            this.shortLabel = shortLabel;
        }

        public String getShortLabel() {
            return this.shortLabel;
        }

        public static CardLocation getLocationByShortLabel(String shortLabel) {
            return mapLabelsShort.get(shortLabel);
        }

        public static boolean isSIGNI(CardLocation location) {
            return location == SIGNI_LEFT || location == SIGNI_CENTER || location == SIGNI_RIGHT || location == CHEER;
        }

        public static boolean isLRIG(CardLocation location) {
            return location == LRIG || location == LRIG_ASSIST_LEFT || location == LRIG_ASSIST_RIGHT;
        }

        public static boolean isOnField(CardLocation location) {
            return location == CHECK_ZONE || CardLocation.isLRIG(location) || location == KEY || CardLocation.isSIGNI(location);
        }

        public static boolean isDeck(CardLocation location) {
            return location == DECK_MAIN || location == DECK_LRIG || location == TRASH || location == TRASH_LRIG;
        }

        public static boolean isPublic(CardLocation location) {
            return CardLocation.isOnField(location) || location == ENER || location == TRASH || location == TRASH_LRIG || location == REVEALED;
        }

        public static boolean isPlayerPrivate(CardLocation location) {
            return location == HAND || location == DECK_LRIG || location == LOOKED;
        }

        public static CardLocation getOppositeSIGNILocation(CardLocation location) {
            return switch (location.ordinal()) {
                case 11 -> SIGNI_RIGHT;
                case 12 -> SIGNI_CENTER;
                case 13 -> SIGNI_LEFT;
                default -> null;
            };
        }

        public static CardLocation getLeftSIGNILocation(CardLocation location) {
            return switch (location.ordinal()) {
                case 12 -> SIGNI_LEFT;
                case 13 -> SIGNI_CENTER;
                default -> null;
            };
        }

        public static CardLocation getRightSIGNILocation(CardLocation location) {
            return switch (location.ordinal()) {
                case 11 -> SIGNI_CENTER;
                case 12 -> SIGNI_RIGHT;
                default -> null;
            };
        }

        public static String getIconByLocation(CardLocation location) {
            return switch (location.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> "\ud83d\udcda";
                case 2, 3 -> "\ud83d\uddd1";
                case 4 -> "\u270b";
                case 5 -> "\ud83d\uddf2";
                case 6 -> "\u2714";
                case 7 -> "\ud83d\udda4";
                case 8 -> "\ud83d\udc83";
                case 14 -> "\ud83d\udd11";
                case 9 -> "\u269e\ud83d\udc6f";
                case 10 -> "\ud83d\udc6f\u269f";
                case 11 -> "\ud83c\udc62\ud83c\udc63\ud83c\udc63";
                case 12 -> "\ud83c\udc63\ud83c\udc62\ud83c\udc63";
                case 13 -> "\ud83c\udc63\ud83c\udc63\ud83c\udc62";
                case 15 -> "\ud83d\udce3";
                case 16, 17 -> "\ud83d\udc41";
                case 18 -> "\ud83c\udfb6";
                case 19 -> "\ud83d\udeab";
            };
        }

        static {
            mapLabelsShort = Arrays.stream(CardLocation.values()).collect(Collectors.toMap(CardLocation::getShortLabel, Function.identity()));
        }
    }
}

