/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.events.EventPhaseStart;
import open.batoru.data.ability.events.GameEvent;

public class GameLog
implements Disposable {
    private final Map<Integer, List<GameEvent>> mapEventsList = new ConcurrentHashMap<Integer, List<GameEvent>>();
    private static final Predicate<GameEvent> STOP_CONDITION_PHASE = event -> event.getId() == GameConst.GameEventId.PHASE_START;

    public void addRecord(GameEvent event) {
        if (event == null) {
            return;
        }
        List currentTurnList = this.mapEventsList.computeIfAbsent(Game.getCurrentGame().getGameRules().getTurnCount(), currentTurn -> new ArrayList());
        if (!currentTurnList.contains(event)) {
            currentTurnList.add(event);
        }
    }

    public List<GameEvent> exportPhaseRecords() {
        return this.exportRecords(Game.getCurrentGame().getGameRules().getTurnCount(), STOP_CONDITION_PHASE);
    }

    public List<GameEvent> exportTurnRecords() {
        return this.exportRecords(Game.getCurrentGame().getGameRules().getTurnCount(), null);
    }

    public List<GameEvent> exportTurnRecords(int turnCount) {
        return this.exportRecords(turnCount, null);
    }

    private List<GameEvent> exportRecords(int turnCount, Predicate<GameEvent> stopCondition) {
        if (turnCount < 1) {
            return List.of();
        }
        List<GameEvent> turnEvents = this.mapEventsList.get(turnCount);
        if (turnEvents == null || turnEvents.isEmpty()) {
            return List.of();
        }
        ArrayList<GameEvent> recentEvents = new ArrayList<GameEvent>();
        for (int i = turnEvents.size() - 1; !(i < 0 || stopCondition != null && stopCondition.test(turnEvents.get(i))); --i) {
            recentEvents.add(turnEvents.get(i));
        }
        return recentEvents;
    }

    public static int getPhaseRecordsCount(Predicate<GameEvent> filterCondition) {
        return GameLog.getRecordsCount(Game.getCurrentGame().getGameRules().getTurnCount(), STOP_CONDITION_PHASE, filterCondition);
    }

    public static int getPhaseRecordsCount(GameConst.GamePhase stopPhase, Predicate<GameEvent> filterCondition) {
        return GameLog.getRecordsCount(Game.getCurrentGame().getGameRules().getTurnCount(), event -> event.getId() == GameConst.GameEventId.PHASE_START && ((EventPhaseStart)event).getPhase() == stopPhase, filterCondition);
    }

    public static int getTurnRecordsCount(Predicate<GameEvent> filterCondition) {
        return GameLog.getRecordsCount(Game.getCurrentGame().getGameRules().getTurnCount(), null, filterCondition);
    }

    public static int getTurnRecordsCount(int turnCount, Predicate<GameEvent> filterCondition) {
        return GameLog.getRecordsCount(turnCount, null, filterCondition);
    }

    public static int getGameRecordsCount(Predicate<GameEvent> filterCondition) {
        int count = 0;
        for (int i = 1; i <= Game.getCurrentGame().getGameRules().getTurnCount(); ++i) {
            count += GameLog.getTurnRecordsCount(i, filterCondition);
        }
        return count;
    }

    private static int getRecordsCount(int turnCount, Predicate<GameEvent> stopCondition, Predicate<GameEvent> filterCondition) {
        return (int)Game.getCurrentGame().getGameLog().exportRecords(turnCount, stopCondition).stream().filter(filterCondition).count();
    }

    @Override
    public void dispose() {
        this.mapEventsList.clear();
    }
}

