/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.ui.FX;

public class IdleStateCoordinator
implements Disposable {
    private final Set<Object> busyObjects = new HashSet<Object>();
    private final ArrayList<Runnable> handlers = new ArrayList();

    public void markAsBusy(Object object) {
        if (this.busyObjects.add(object) && this.busyObjects.size() == 1) {
            FX.run(() -> {
                if (!this.busyObjects.isEmpty()) {
                    Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().onBusy();
                }
            });
        }
    }

    public void markAsIdle(Object object) {
        this.busyObjects.remove(object);
        if (!this.busyObjects.isEmpty()) {
            return;
        }
        for (Runnable runnable : this.handlers) {
            runnable.run();
        }
        this.handlers.clear();
        FX.run(() -> {
            if (this.busyObjects.isEmpty()) {
                Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().internalOnIdle();
            }
        });
        if (Game.getCurrentGame().getFakeReceiver() != null) {
            Game.getCurrentGame().getFakeReceiver().processIdle(Game.getCurrentGame().getActionQueue().getLastProcessedOrder() + 1);
        }
    }

    public void setOnNextIdle(Runnable handler) {
        this.handlers.add(handler);
    }

    @Override
    public void dispose() {
        this.handlers.clear();
        this.busyObjects.clear();
    }
}

