/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import java.util.HashMap;
import java.util.Map;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;

public class IndexRegistry
implements Disposable {
    private final Map<Integer, CardIndex> indexes = new HashMap<Integer, CardIndex>();
    private int idMaxIndex = 52;
    private int idMinIndex = -this.idMaxIndex;

    public CardIndex getIndex(int idCard) {
        return this.indexes.get(idCard);
    }

    public void addIndex(int idCard, CardIndex cardIndex) {
        this.indexes.put(idCard, cardIndex);
    }

    public CardIndex createFreeIndex(Game.GamePlayerRole rolePlayerOwner, GameConst.CardLocation location) {
        int idCard = this.getNextFreeIndex(rolePlayerOwner);
        CardIndex cardIndex = new CardIndex(location, idCard);
        this.indexes.put(idCard, cardIndex);
        return cardIndex;
    }

    public int getNextFreeIndex(Game.GamePlayerRole rolePlayer) {
        return rolePlayer == Game.GamePlayerRole.HOST ? (this.idMaxIndex = this.idMaxIndex + 1) : (this.idMinIndex = this.idMinIndex - 1);
    }

    @Override
    public void dispose() {
        this.indexes.values().forEach(CardIndex::dispose);
        this.indexes.clear();
    }
}

