/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardGameAction;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.ConstantEffect;

public abstract class TransientCardGameAction
extends CardGameAction {
    private CardIndex cardIndex;

    public TransientCardGameAction() {
    }

    public TransientCardGameAction(CardIndex cardIndex) {
        this.setCardIndex(cardIndex);
    }

    public final void setCardIndex(CardIndex cardIndex) {
        this.cardIndex = cardIndex;
        this.setOnActionBlocked(() -> {
            if (this.isLastAtOnce()) {
                this.resetTransientPersistEffectFlags();
            }
        });
    }

    public final CardIndex getCardIndex() {
        return this.cardIndex;
    }

    public final void addCardIndexData() {
        this.cardIndex.updatePreTransientLocation();
        super.addCardIndexData(this.cardIndex);
        if (this.cardIndex != null && this.cardIndex.getIndexedInstance() != null && this.cardIndex.getUnderType() == GameConst.CardUnderType.NONE) {
            this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(2048);
            if (this.isLastAtOnce() && (!this.isNonOverridableAction() || this.getSourceOverrideResult() == null || this.getSourceOverrideResult().getSourceOriginalAction().isLastAtOnce())) {
                this.setOnActionCompleted(this::resetTransientPersistEffectFlags);
            }
        }
    }

    protected void resetTransientPersistEffectFlags() {
        boolean mustUpdateConstAbilities = false;
        TransientCardGameAction action = this;
        do {
            if (action.getCardIndex() == null || action.getCardIndex().getIndexedInstance() == null || !action.getCardIndex().getIndexedInstance().isState(2048)) continue;
            action.getCardIndex().getIndexedInstance().resetAbilityFlags();
            if (!mustUpdateConstAbilities && action.getCardIndex().getIndexedInstance().getAbilityList().stream().anyMatch(ability -> ability instanceof ConstantEffect)) {
                mustUpdateConstAbilities = true;
            }
            action.getCardIndex().getIndexedInstance().getCardStateFlags().removeValue(2048);
        } while ((action = (TransientCardGameAction)action.getPrevAtOnceAction()) != null);
        if (mustUpdateConstAbilities) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
        }
    }
}

