/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.control.ControlTemporaryCardRules;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.events.EventMove;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.ui.UI;

public class ActionAddToLifeCloth
extends TransientCardGameAction {
    private final Game.GamePlayerRole rolePlayer;
    private int numToAdd;

    public ActionAddToLifeCloth(Game.GamePlayerRole rolePlayer, int numToAdd) {
        this.rolePlayer = rolePlayer;
        this.numToAdd = numToAdd;
    }

    public ActionAddToLifeCloth(CardIndex cardIndex) {
        super(cardIndex);
        this.rolePlayer = cardIndex.getCurrentOwnerSafe();
    }

    @Override
    protected void dispatch() {
        if (this.numToAdd <= 0 && this.getCardIndex() == null || this.getCardIndex() != null && this.getCardIndex().getIndexedInstance() != null && this.getSourceAbility() != null && (this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.getCardIndex(), this, new Object[]{GameConst.CardLocation.LIFE_CLOTH}) == RuleCheck.RuleCheckState.BLOCK)) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer);
        if (this.numToAdd > 0) {
            int countInDeck = field.getDeckZone(Deck.DeckType.MAIN).getTotalCards();
            if (countInDeck == 0) {
                this.getDataTable().add(null);
                this.setAsCompleted();
                return;
            }
            if (this.numToAdd > countInDeck) {
                this.numToAdd = countInDeck;
            }
        } else if (this.getCardIndex() != null) {
            this.setLogEvent(new LogEventMove(new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.LIFE_CLOTH), TargetFilter.TargetHint.HEAL));
            if (ControlTemporaryCardRules.applyLocationOverrideOnLeaveField(this.getCardIndex(), this)) {
                return;
            }
            UI.getTabGame().getFieldSceneOverlay().getGameLog().getLifeClothTracker(this.rolePlayer).healNext(this.getLogEvent());
        }
        AnimationTracker tracker = new AnimationTracker(this.numToAdd > 0 ? this.numToAdd : 1);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        if (this.numToAdd > 0) {
            Card3D card3D;
            for (int i = 0; i < this.numToAdd && (card3D = field.getDeckZone(Deck.DeckType.MAIN).getTopCard(i)) != null; ++i) {
                this.getDataTable().add(card3D.getCardIndex());
                this.setLogEvent(new LogEventMove(new EventMove(card3D.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.LIFE_CLOTH), TargetFilter.TargetHint.HEAL));
                AnimationCardMove aniMove = new AnimationCardMove(card3D, field.getLifeClothZone());
                aniMove.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniMove);
                UI.getTabGame().getFieldSceneOverlay().getGameLog().getLifeClothTracker(this.rolePlayer).healNext(this.getLogEvent());
            }
        } else {
            Card3D card3D = this.getCardIndex().getSourceCard3D();
            this.addCardIndexData();
            if (this.getCardIndex().getIndexedInstance() != null && this.getCardIndex().getLocation() != GameConst.CardLocation.REVEALED && GameConst.CardLocation.isPublic(this.getCardIndex().getLocation())) {
                tracker.setMaxCount(tracker.getMaxCount() + 1);
                AnimationCardMove aniReveal = new AnimationCardMove(card3D, field.getRevealZone());
                aniReveal.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniReveal);
            }
            AnimationCardMove aniMove = new AnimationCardMove(card3D, field.getLifeClothZone());
            if (this.getCardIndex().getLocation() != GameConst.CardLocation.REVEALED && this.getCardIndex().getLocation() != GameConst.CardLocation.LOOKED) {
                aniMove.setDelay(300.0);
            }
            aniMove.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniMove);
        }
        seqAni.play();
    }
}

