/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionDamage;
import open.batoru.core.gameplay.actions.ActionGuard;
import open.batoru.core.gameplay.actions.ActionManualChoiceCostGuard;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceInteger;
import open.batoru.core.gameplay.actions.override.OverrideAction;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.rulechecks.CostRuleCheck;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.EventAttack;
import open.batoru.data.ability.events.EventDamage;
import open.batoru.data.ability.events.EventGuard;
import open.batoru.game.GameField;
import open.batoru.game.animations.AnimationFlashGuard;
import open.batoru.game.overlay.log.events.LogEventAttackLRIG;
import open.batoru.ui.UI;

public class ActionAttackLRIG
extends GameAction<CardIndex> {
    private final EventAttack eventAttack;
    private Game.GamePlayerRole rolePlayerOpponent;
    private boolean shouldDisableGuardSkip;
    private Map<AbilityCost, ModifiableVariable.ModifiableValueReference<Integer>> cacheModifiedCosts;
    private int currentDamageInstance;
    private int numTotalDamageInstances;
    private int numSuccessfulGuardInstances;

    public ActionAttackLRIG(EventAttack eventAttack) {
        this.eventAttack = eventAttack;
    }

    @Override
    protected void dispatch() {
        this.rolePlayerOpponent = Game.GamePlayerRole.getOpponentRole(this.getSourceCardIndex().getIndexedInstance().getCurrentOwner());
        PlayerRuleCheckRegistry ruleCheckRegistryOpponent = Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.rolePlayerOpponent);
        Game.getCurrentGame().getGameRules().setIsGuardStep(true);
        GameField.highlightPlayerField(this.rolePlayerOpponent);
        this.setLogEvent(new LogEventAttackLRIG(this.eventAttack));
        this.numTotalDamageInstances = this.getSourceCardIndex().getIndexedInstance().getRCRegistry().getRuleValue(CardRuleCheckRegistry.CardRuleValueType.ATTACK_DAMAGE_INSTANCES).getValue();
        if (ruleCheckRegistryOpponent.getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_GUARD).check(this.rolePlayerOpponent, this.getSourceCardIndex(), new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            this.dispatchDamage(this.numTotalDamageInstances);
            this.setAsCompleted();
            return;
        }
        CardIndex cardIndexLRIGOpponent = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayerOpponent).getLRIGZone().getTopCard().getCardIndex();
        CostRuleCheck costRuleCheckGuard = (CostRuleCheck)ruleCheckRegistryOpponent.getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.COST_TO_GUARD);
        List<AbilityCostList> dataCostListsGuard = costRuleCheckGuard.check(new PlayerRuleCheckData(this.rolePlayerOpponent, null, null, cardIndexLRIGOpponent)).getSourceCostList().getSourceDataCostLists();
        if (PlayerControl.isChoosingPlayer(this.rolePlayerOpponent)) {
            this.cacheModifiedCosts = new HashMap<AbilityCost, ModifiableVariable.ModifiableValueReference<Integer>>();
            if (UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayerOpponent).getLifeClothZone().getTotalCards() == 0 && ((RuleCheck)ruleCheckRegistryOpponent.getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_BE_DAMAGED)).getRuleChecksNum() == 1 && ((RuleCheck)ruleCheckRegistryOpponent.getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_LOSE_GAME)).getRuleChecksNum() == 1 && OverrideAction.findActiveOverrideActions(this.rolePlayerOpponent, null, new EventDamage(this.rolePlayerOpponent, this.getSourceCardIndex(), null)).isEmpty()) {
                for (AbilityCostList costList : dataCostListsGuard) {
                    AbilityCost cost = costList.getDataArray().getFirst();
                    if (cost.getCostMinCount() != 0) continue;
                    ModifiableVariable.ModifiableValueReference<Integer> valueReference = cost.getModifiableCostMinCount().setBaseValue(cost.getCostMaxCount());
                    this.cacheModifiedCosts.put(cost, valueReference);
                }
                this.shouldDisableGuardSkip = true;
            }
        }
        this.dispatchGuardPre(cardIndexLRIGOpponent, dataCostListsGuard);
        this.setAsCompleted();
    }

    private void dispatchGuardPre(CardIndex cardIndexLRIGOpponent, List<AbilityCostList> dataCostListsGuard) {
        ++this.currentDamageInstance;
        boolean isLastDamageInstance = this.currentDamageInstance == this.numTotalDamageInstances;
        GameAction action = PlayerControl.isChoosingPlayer(this.rolePlayerOpponent) ? new ActionManualChoiceCostGuard(dataCostListsGuard, this.shouldDisableGuardSkip) : new ActionPlayerChoiceInteger();
        action.setOnActionCompleted(() -> {
            if (ActionPayCost.isCostActionSuccessful(action)) {
                AbilityCostList costListChosen = (AbilityCostList)dataCostListsGuard.get((Integer)action.getDataTable().get());
                costListChosen.setSourceCardIndex(cardIndexLRIGOpponent);
                for (AbilityCost cost : costListChosen.getDataArray()) {
                    cost.setSourceAbility(null);
                }
                costListChosen.setForcedMandatoryState(this.shouldDisableGuardSkip);
                costListChosen.setOnCostHandledAll(() -> {
                    if (costListChosen.isPaid()) {
                        ++this.numSuccessfulGuardInstances;
                        CardIndex cardIndexGuard = this.getCostPaidCardIndex(costListChosen.getDataArray().getFirst());
                        AnimationFlashGuard aniFlash = new AnimationFlashGuard(cardIndexGuard);
                        Game.getCurrentGame().getIdleStateCoordinator().markAsBusy((Object)aniFlash);
                        aniFlash.setOnAnimationFinished(() -> {
                            Game.getCurrentGame().getIdleStateCoordinator().markAsIdle((Object)aniFlash);
                            this.dispatchGuard(cardIndexGuard, isLastDamageInstance && this.numSuccessfulGuardInstances == this.numTotalDamageInstances);
                            if (isLastDamageInstance) {
                                this.dispatchGuardPost();
                            } else {
                                this.dispatchGuardPre(cardIndexLRIGOpponent, dataCostListsGuard);
                            }
                        });
                        aniFlash.play();
                    } else if (isLastDamageInstance) {
                        this.dispatchGuardPost();
                    } else {
                        this.dispatchGuardPre(cardIndexLRIGOpponent, dataCostListsGuard);
                    }
                });
                Game.getCurrentGame().getActionQueue().addAction(new ActionPayCost(costListChosen));
            } else if (isLastDamageInstance) {
                this.dispatchGuardPost();
            } else {
                this.dispatchGuardPre(cardIndexLRIGOpponent, dataCostListsGuard);
            }
        });
        action.treatAsMidEffAction();
        Game.getCurrentGame().getActionQueue().addAction(action);
    }

    private void dispatchGuardPost() {
        int totalDamageInstances = this.numTotalDamageInstances - this.numSuccessfulGuardInstances;
        if (totalDamageInstances > 0) {
            this.dispatchDamage(totalDamageInstances);
        }
        if (this.cacheModifiedCosts != null) {
            for (AbilityCost cost : this.cacheModifiedCosts.keySet()) {
                cost.getModifiableCostMinCount().removeBaseValue(this.cacheModifiedCosts.get(cost));
            }
        }
    }

    private void dispatchGuard(CardIndex cardIndexGuard, boolean isTotalDamageGuarded) {
        ActionGuard action = new ActionGuard();
        action.setSourceCardIndex(cardIndexGuard);
        if (isTotalDamageGuarded) {
            action.setOnActionDispatched(() -> {
                Game.getCurrentGame().getGameRules().setIsGuardStep(false);
                GameField.highlightPlayerField(null);
            });
            action.setOnActionCompleted(() -> {
                Game.getCurrentGame().getGameRules().getEffectProcessor().setOnEffectProcessingFinished(() -> Game.getCurrentGame().getIdleStateCoordinator().setOnNextIdle(() -> this.eventAttack.callOnAttackEnd(false)));
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(new EventGuard(cardIndexGuard));
            });
        } else {
            action.treatAsMidEffAction();
        }
        Game.getCurrentGame().getActionQueue().addAction(action);
    }

    private void dispatchDamage(int numDamageInstances) {
        ActionDamage action = new ActionDamage(this.rolePlayerOpponent);
        action.setSourceCardIndex(this.getSourceCardIndex());
        action.setOnActionDispatched(() -> {
            Game.getCurrentGame().getGameRules().setIsGuardStep(false);
            GameField.highlightPlayerField(null);
        });
        if (numDamageInstances == 1) {
            action.setOnActionCompleted(() -> Game.getCurrentGame().getIdleStateCoordinator().setOnNextIdle(() -> this.eventAttack.callOnAttackEnd(action.isSuccessful())));
            action.setOnActionOverridden(() -> this.eventAttack.callOnAttackEnd(false));
        } else {
            if (numDamageInstances > 1) {
                action.setIsNotLastDamageInstance();
            }
            action.setOnActionCompleted(() -> this.dispatchDamage(numDamageInstances - 1));
        }
        Game.getCurrentGame().getActionQueue().addAction(action);
    }

    private CardIndex getCostPaidCardIndex(AbilityCost cost) {
        if (cost.getSourceAbility() == null) {
            AbilityCost.Payable payable = cost.getPaidCostData().get();
            if (payable instanceof CardIndexSnapshot) {
                CardIndexSnapshot cardIndexSnapshot = (CardIndexSnapshot)payable;
                return cardIndexSnapshot.getSourceCardIndex();
            }
            return cost.getSourceCardIndex();
        }
        return cost.getSourceAbility().getSourceCardIndex();
    }
}

