/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameAction;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.DelayedAbility;
import open.batoru.data.ability.events.EventActivateDelayed;
import open.batoru.data.ability.events.GameEventTrigger;

public class ActionCallDelayedEffect
extends GameAction<Void> {
    private final CardIndex cardIndex;
    private final Ability sourceCallerAbility;
    private final AbilityEffectNoSource effect;
    private ChronoRecordScheduler.ChronoRecord record;
    private GameEventTrigger eventTrigger;

    public ActionCallDelayedEffect(CardIndex cardIndex, Ability sourceCallerAbility, ChronoRecordScheduler.ChronoRecord record, AbilityEffectNoSource effect) {
        this.cardIndex = cardIndex;
        this.sourceCallerAbility = sourceCallerAbility;
        this.record = record;
        this.effect = effect;
    }

    public ActionCallDelayedEffect(CardIndex cardIndex, Ability sourceCallerAbility, GameEventTrigger eventTrigger, AbilityEffectNoSource effect) {
        this.cardIndex = cardIndex;
        this.sourceCallerAbility = sourceCallerAbility;
        this.eventTrigger = eventTrigger;
        this.effect = effect;
    }

    @Override
    protected void dispatch() {
        DelayedAbility ability = new DelayedAbility(this.effect);
        ability.setSourceCardId(this.sourceCallerAbility.getSourceCardId());
        ability.setSourceAttachAbility(this.sourceCallerAbility);
        ability.setSourceAttachPlayerRole(this.cardIndex.getCurrentOwnerSafe());
        ability.onAbilityInit();
        Game.getCurrentGame().getPlayerGameData(this.cardIndex.getCurrentOwnerSafe()).addPlayerAbility(ability);
        if (this.record != null) {
            this.record.getChronoDuration().setShouldAutoAdaptPhaseEndCheck(true);
            this.record.setOnChronoRecordExpired(() -> {
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventActivateDelayed(ability));
                Game.getCurrentGame().getGameRules().getPhaseList().getCurrentPhase().setShouldForceCallNextEffects(true);
            });
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(this.record);
        } else if (this.eventTrigger != null) {
            ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(ChronoDuration.permanent());
            this.eventTrigger.setLinkedRecord(record);
            record.setOnChronoRecordExpired(() -> Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventActivateDelayed(ability)));
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        }
        this.setAsCompleted();
    }
}

