/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionEffectEndCutInResponse;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.game._3d.textures.UtilTextureLayer;

public class ActionCancel
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;

    public ActionCancel(CardIndex cardIndex) {
        this.cardIndex = cardIndex;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || this.cardIndex.getLocation() != GameConst.CardLocation.CHECK_ZONE) {
            this.setAsCompleted();
            return;
        }
        this.cardIndex.getIndexedInstance().getAbilityList().stream().filter(ability -> ability instanceof CheckZoneAbility && !ability.isCancelled()).findFirst().ifPresent(ability -> {
            ability.cancel();
            this.getDataTable().add(this.cardIndex);
            this.cardIndex.getSourceCard3D().getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.DISABLED));
            Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> Game.getCurrentGame().getActionQueue().addAction(new ActionEffectEndCutInResponse()));
        });
        this.setAsCompleted();
    }
}

