/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.AbilityFunctionalConditionalHandler;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.ui.FX;

public class ActionDisableAllAbilities
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;
    private final AbilityFunctionalConditionalHandler handlerAbility;
    private final AbilityConst.AbilityGain abilityGain;
    private final ChronoDuration chronoDuration;

    public ActionDisableAllAbilities(CardIndex cardIndex, AbilityFunctionalConditionalHandler handlerAbility, AbilityConst.AbilityGain abilityGain, ChronoDuration chronoDuration) {
        this.cardIndex = cardIndex;
        this.handlerAbility = handlerAbility;
        this.abilityGain = abilityGain;
        this.chronoDuration = chronoDuration;
    }

    @Override
    protected void dispatch() {
        RuleCheck.RuleCheckHandler<RuleCheck.RuleCheckState, CardRuleCheckData> handlerRCAbilityGain;
        if (this.cardIndex == null || this.cardIndex.getIndexedInstance() == null || this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ABILITY_BE_DISABLED).check(this.cardIndex, this.getSourceAbility(), new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            this.resetTransientFlags();
            this.setAsCompleted();
            return;
        }
        this.getDataTable().add(this.cardIndex);
        int countDisabled = 0;
        for (Ability ability : this.cardIndex.getIndexedInstance().getAbilityList()) {
            if (this.handlerAbility != null && !this.handlerAbility.handle(ability)) continue;
            ability.disable(this.chronoDuration);
            ++countDisabled;
        }
        if (!this.isLastAtOnce()) {
            this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(2048);
        }
        Card3D card3D = this.cardIndex.getSourceCard3D();
        if (this.handlerAbility == null && countDisabled > 0) {
            card3D.getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.DISABLED));
        }
        RuleCheck.RuleCheckHandler<RuleCheck.RuleCheckState, CardRuleCheckData> ruleCheckHandler = handlerRCAbilityGain = this.abilityGain == AbilityConst.AbilityGain.BLOCK ? data -> RuleCheck.RuleCheckState.BLOCK : null;
        if (handlerRCAbilityGain != null) {
            RuleCheck ruleCheck = (RuleCheck)this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ABILITY_BE_ATTACHED);
            ruleCheck.addRuleCheck(handlerRCAbilityGain, this.getSourceAbility());
        }
        if (this.chronoDuration != ChronoDuration.permanent()) {
            boolean wasDisabled = countDisabled > 0;
            ChronoRecordScheduler.ChronoRecord record = new ChronoRecordScheduler.ChronoRecord(this.cardIndex, this.chronoDuration);
            record.setOnChronoRecordExpired(() -> {
                if (this.handlerAbility == null && wasDisabled) {
                    FX.run(() -> card3D.getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.DISABLED.getAlias()));
                }
                if (handlerRCAbilityGain != null) {
                    RuleCheck ruleCheck = (RuleCheck)this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_ABILITY_BE_ATTACHED);
                    ruleCheck.removeRuleCheck(handlerRCAbilityGain);
                }
            });
            Game.getCurrentGame().getChronoScheduler().addChronoRecord(record);
        }
        this.resetTransientFlags();
        this.setAsCompleted();
    }

    private void resetTransientFlags() {
        if (this.getTotalNumAtOnce() <= 1 || !this.isLastAtOnce()) {
            return;
        }
        ActionDisableAllAbilities action = this;
        do {
            CardIndex cardIndexResult;
            if (!action.isSuccessful() || (cardIndexResult = (CardIndex)action.getDataTable().get()).getIndexedInstance() == null || !cardIndexResult.getIndexedInstance().isState(2048)) continue;
            cardIndexResult.getIndexedInstance().getCardStateFlags().removeValue(2048);
        } while ((action = (ActionDisableAllAbilities)action.getPrevAtOnceAction()) != null);
    }
}

