/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardGameAction;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.DataTable;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventDiscard;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.EventTrash;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.GameField;
import open.batoru.game.PlayerHand;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionDiscard
extends CardGameAction {
    private final List<CardIndex> listCards = new ArrayList<CardIndex>();

    public ActionDiscard(DataTable<CardIndex> data) {
        for (int i = 0; i < data.size(); ++i) {
            this.listCards.add(data.get(i));
        }
    }

    public ActionDiscard(CardIndex cardIndex) {
        this.listCards.add(cardIndex);
    }

    public ActionDiscard() {
    }

    @Override
    protected void dispatch() {
        if (this.isChildAction()) {
            this.getDataTable().clear();
        }
        if (this.listCards.isEmpty() || !this.isDataReceived() && this.listCards.stream().anyMatch(cardIndex -> cardIndex.getIndexedInstance() == null)) {
            if (!this.isDataReceived()) {
                this.listCards.clear();
                this.requestData();
            } else {
                this.getDataTable().add(null);
                this.setAsCompleted();
            }
            return;
        }
        AnimationTracker tracker = new AnimationTracker(this.listCards.size() * 2);
        tracker.setOnTrackerAllFinished(() -> {
            if (this.isSuccessful()) {
                Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            } else {
                this.getDataTable().add(null);
            }
            this.setAsCompleted();
        });
        GameField field = UI.getTabGame().getFieldScene().getGameField();
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        for (CardIndex cardIndex2 : this.listCards) {
            if (cardIndex2.getIndexedInstance() == null || cardIndex2.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(cardIndex2, this, new Object[]{GameConst.CardLocation.TRASH}) == RuleCheck.RuleCheckState.BLOCK) {
                PlayerHand.Card3DHoverAnimation hoverAnimation;
                if (cardIndex2.getLocation() == GameConst.CardLocation.HAND && (hoverAnimation = field.getPlayerFieldByRole(cardIndex2.getCurrentOwnerSafe()).getHand().getHandHoverAnimation(cardIndex2.getSourceCard3D())) != null) {
                    hoverAnimation.setLock(false);
                }
                tracker.setMaxCount(tracker.getMaxCount() - 2);
                continue;
            }
            this.addCardIndexData(cardIndex2);
        }
        if (!this.getDataTable().isEmpty()) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
        }
        for (int i = 0; i < this.getDataTable().size(); ++i) {
            CardIndex cardIndex2;
            cardIndex2 = (CardIndex)this.getDataTable().get(i);
            GameEvent[] listEvents = new GameEvent[]{new EventMove(cardIndex2, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.TRASH), new EventDiscard(cardIndex2, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost()), new EventTrash(cardIndex2, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost())};
            for (GameEvent event : listEvents) {
                event.setAtOnce(i, this.getDataTable().size());
            }
            this.setLogEvent(new LogEventMove(listEvents[1], GameConst.CardLocation.TRASH, AbilityConst.ActionHint.DISCARD));
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(listEvents);
            if (cardIndex2.getLocation() != GameConst.CardLocation.REVEALED) {
                AnimationCardMove aniReveal = new AnimationCardMove(cardIndex2.getSourceCard3D(), field.getPlayerFieldByRole(cardIndex2.getCurrentOwnerSafe()).getRevealZone());
                aniReveal.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniReveal);
            } else {
                tracker.setMaxCount(tracker.getMaxCount() - 1);
            }
            AnimationCardMove aniMove = new AnimationCardMove(cardIndex2.getSourceCard3D(), field.getPlayerFieldByRole(Card3D.getCurrentOwner(cardIndex2.getSourceCard3D())).getTrashZone(Deck.DeckType.MAIN));
            if (cardIndex2.getLocation() != GameConst.CardLocation.REVEALED) {
                aniMove.setDelay(300.0);
            }
            aniMove.setOnAnimationStarted(() -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(cardIndex2));
            aniMove.setAnimationTracker(tracker);
            seqAni.getAnimationList().add(aniMove);
        }
        seqAni.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        for (int i = 1; i < pp.getDataArgsNum(); ++i) {
            CardIndex.getCardFromPacketData(pp.getDataArgument(i)).ifPresent(card3D -> this.listCards.add(card3D.getCardIndex()));
        }
    }
}

