/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.events.EventDown;
import open.batoru.game.animations.AnimationCardRotate;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.log.events.LogEventDown;
import open.batoru.ui.UI;

public class ActionDown
extends GameAction<CardIndex> {
    private final CardIndex cardIndex;

    public ActionDown(CardIndex cardIndex) {
        this.cardIndex = cardIndex;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex == null || this.cardIndex.getIndexedInstance() == null || !GameConst.CardLocation.isSIGNI(this.cardIndex.getLocation()) && !GameConst.CardLocation.isLRIG(this.cardIndex.getLocation()) || this.cardIndex.getIndexedInstance().isState(16384) || this.getSourceAbility() != null && (this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_DOWNED).check(this.cardIndex, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.cardIndex, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK)) {
            this.setAsCompleted();
            return;
        }
        this.getDataTable().add(this.cardIndex);
        if (this.getSourceCost() != null) {
            this.getSourceCost().addPaidCardIndexData(this.cardIndex);
        }
        if (this.getSourceAbility() != null || this.getSourceCost() != null) {
            UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(new LogEventDown(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost()));
        }
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(new EventDown(this.cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost()));
        if (this.isLastAtOnce()) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
        }
        this.cardIndex.getIndexedInstance().getCardStateFlags().addValue(16384);
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        AnimationCardRotate aniDown = new AnimationCardRotate(this.cardIndex.getSourceCard3D(), false);
        aniDown.setAnimationTracker(tracker);
        aniDown.play();
    }
}

