/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventDraw;
import open.batoru.data.ability.events.EventMove;
import open.batoru.game.GameField;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneLook;
import open.batoru.game.ZoneReveal;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionDraw
extends GameAction<CardIndex> {
    private Card3D[] listCards;
    private int numToDraw;
    private Game.GamePlayerRole rolePlayerPrivate;

    @Override
    protected void dispatch() {
        if (!this.isDataReceived()) {
            this.requestData();
            return;
        }
        if (this.numToDraw <= 0) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        AnimationTracker tracker = new AnimationTracker(this.numToDraw);
        tracker.setOnTrackerAllFinished(() -> {
            for (int i = 0; i < this.getDataTable().size(); ++i) {
                EventDraw eventDraw = new EventDraw((CardIndex)this.getDataTable().get(i), this.getSourceCardIndex(), this.getSourceAbility());
                eventDraw.setAtOnce(i, this.getDataTable().size());
                EventMove eventMove = new EventMove((CardIndex)this.getDataTable().get(i), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.HAND);
                eventMove.setAtOnce(i, this.getDataTable().size());
                this.setLogEvent(new LogEventMove(eventDraw, GameConst.CardLocation.DECK_MAIN, GameConst.CardLocation.HAND, AbilityConst.ActionHint.DRAW));
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(eventDraw, eventMove);
            }
            Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects();
            this.setAsCompleted();
        });
        GameField field = UI.getTabGame().getFieldScene().getGameField();
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
        if (this.listCards == null) {
            ZoneLook zoneLook;
            PlayerField playerField;
            ZoneReveal zoneReveal;
            Card3D card3D;
            for (int i = 0; i < this.numToDraw && (card3D = (zoneReveal = (playerField = this.rolePlayerPrivate == null ? field.getTopPlayerField() : field.getPlayerFieldByRole(this.rolePlayerPrivate)).getRevealZone()).getTotalCards() > 0 && i < zoneReveal.getTotalCards() && zoneReveal.getZoneCardList().get(i).getCardIndex().getOldLocation() == GameConst.CardLocation.DECK_MAIN ? zoneReveal.getZoneCardList().get(i) : ((zoneLook = playerField.getLookZone()).getTotalCards() > 0 && i < zoneLook.getTotalCards() && zoneLook.getZoneCardList().get(i).getCardIndex().getOldLocation() == GameConst.CardLocation.DECK_MAIN ? zoneLook.getZoneCardList().get(i) : playerField.getDeckZone(Deck.DeckType.MAIN).getTopCard(i))) != null; ++i) {
                this.getDataTable().add(card3D.getCardIndex());
                AnimationCardMove aniMove = new AnimationCardMove(card3D, playerField.getHand());
                aniMove.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniMove);
            }
        } else {
            for (int i = 0; i < this.numToDraw; ++i) {
                Card3D card3D = this.listCards[i];
                this.getDataTable().add(card3D.getCardIndex());
                AnimationCardMove aniMove = new AnimationCardMove(card3D, field.getBottomPlayerField().getHand());
                aniMove.setOnAnimationStarted(() -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(card3D.getCardIndex()));
                aniMove.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniMove);
            }
        }
        seqAni.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (pp.getDataArgsNum() >= 2 && pp.getDataArgument(1).startsWith("~")) {
            this.numToDraw = Integer.parseInt(pp.getDataArgument(1).substring(1));
            this.rolePlayerPrivate = pp.getDataArgsNum() == 2 ? Game.GamePlayerRole.getOpponentRole(Game.getCurrentGame().getPlayerRole()) : Game.GamePlayerRole.getRoleById(Integer.parseInt(pp.getDataArgument(2)));
        } else {
            if (pp.getDataArgument(1).equals(String.valueOf(0))) {
                this.numToDraw = 0;
                return;
            }
            this.numToDraw = pp.getDataArgsNum() - 1;
            this.listCards = new Card3D[this.numToDraw];
            PlayerField field = UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField();
            for (int i = 0; i < this.listCards.length; ++i) {
                ZoneLook zoneLook;
                ZoneReveal zoneReveal = field.getRevealZone();
                Card3D card3D = zoneReveal.getTotalCards() > 0 && i < zoneReveal.getTotalCards() && zoneReveal.getZoneCardList().get(i).getCardIndex().getOldLocation() == GameConst.CardLocation.DECK_MAIN ? zoneReveal.getZoneCardList().get(i) : ((zoneLook = field.getLookZone()).getTotalCards() > 0 && i < zoneLook.getTotalCards() && zoneLook.getZoneCardList().get(i).getCardIndex().getOldLocation() == GameConst.CardLocation.DECK_MAIN ? zoneLook.getZoneCardList().get(i) : field.getDeckZone(Deck.DeckType.MAIN).getTopCard(i));
                CardIndex.assignCardFromShortPacketData(pp.getDataArgument(i + 1), card3D);
                this.listCards[i] = card3D;
            }
        }
    }
}

