/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.callback.CallbackGameAction;
import open.batoru.core.gameplay.callback.EffectCallbackThread;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.CardAbilities;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.GameField;
import open.batoru.game.animations.AnimationFlashEffect;
import open.batoru.game.animations.AnimationFlashEffectNegate;
import open.batoru.game.animations.AnimationFlashEffectRecollect;

public class ActionEffectActivateResolve
extends CallbackGameAction {
    private final GameEvent sourceEvent;
    private boolean hasChangedHighlightOwner;

    public ActionEffectActivateResolve(Ability ability, GameEvent event) {
        this.setSourceAbility(ability);
        this.sourceEvent = event;
        this.treatAsMidEffAction();
    }

    @Override
    protected void dispatch() {
        if (GameField.getHighlightDefaultPlayer() != this.getSourceCardIndex().getCurrentOwnerSafe() && Game.getCurrentGame().getGameRules().getEffectProcessor().getCutInResponse() == null) {
            GameField.setHighlightDefaultPlayer(this.getSourceCardIndex().getCurrentOwnerSafe());
            this.hasChangedHighlightOwner = true;
        }
        AnimationFlashEffect aniFlash = !this.getSourceAbility().hasRecollect() || !this.getSourceAbility().isRecollectFulfilled() ? (!this.getSourceAbility().isDisabled() || (this.getSourceAbility().getFlags().getValue() & 2) == 0 ? new AnimationFlashEffect(this.getSourceAbility()) : new AnimationFlashEffectNegate(this.getSourceAbility())) : new AnimationFlashEffectRecollect(this.getSourceAbility());
        aniFlash.setOnAnimationFinished(this::dispatchEffectCallback);
        aniFlash.play();
    }

    private void dispatchEffectCallback() {
        CardAbilities.setEffectCallbackAction(this);
        this.startCallbackThread(new EffectCallbackThread(this));
        this.setAsCompleted();
    }

    public GameEvent getSourceEvent() {
        return this.sourceEvent;
    }

    public boolean hasChangedHighlightOwner() {
        return this.hasChangedHighlightOwner;
    }
}

