/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.net.UnknownHostException;
import java.util.List;
import java.util.StringJoiner;
import open.batoru.Log;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEffectDecideLifeBurst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.GameField;
import open.batoru.game.animations.AnimationBorderIcon;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowEffectDecideLifeBurst;
import open.batoru.networking.RedirectedReceiver;
import open.batoru.networking.connection.GameSendActionAttempt;
import open.batoru.ui.UI;

public class ActionEffectManualDecideLifeBurst
extends GameAction<Integer> {
    private final List<CardIndex> listCards;

    public ActionEffectManualDecideLifeBurst(List<CardIndex> listCards) {
        this.listCards = listCards;
    }

    @Override
    protected void dispatch() {
        GameField.highlightPlayerField(Game.getCurrentGame().getPlayerRole());
        AnimationBorderIcon aniBorder = new AnimationBorderIcon(UI.getTabGame().getFieldScene().getGameField().getBottomPlayerField().getCheckZone(), TargetFilter.TargetHint.ACTIVATE);
        aniBorder.play();
        OverlayWindowEffectDecideLifeBurst window = new OverlayWindowEffectDecideLifeBurst(this.listCards);
        window.getConfirmButton().setOnAction(e -> {
            window.setLock(true);
            window.getConfirmButton().setDisable(true);
            StringJoiner packetData = new StringJoiner("|");
            List<Integer> listData = window.getDecidedData();
            for (Integer data : listData) {
                this.getDataTable().add(data);
                packetData.add(String.valueOf(data));
            }
            try {
                GameSendActionAttempt attempt = new GameSendActionAttempt("SELA", this, packetData.toString());
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, RedirectedReceiver.RedirectValidator.ofSimpleGameAction(this.getOrderId()), pp -> {
                    aniBorder.stop();
                    OverlayWindow.removeFromFieldOverlay(window);
                    ActionEffectDecideLifeBurst actionDecide = new ActionEffectDecideLifeBurst(Game.getCurrentGame().getPlayerRole(), this.listCards);
                    actionDecide.dispatchAsChild(this);
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                Log.printMessage(ex);
            }
        });
        window.getSkipButton().setOnAction(e -> {
            window.getSkipButton().setDisable(true);
            window.deselectAll();
            window.getConfirmButton().fire();
        });
        OverlayWindow.addToFieldOverlay(window);
    }
}

