/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.TransientCardGameAction;
import open.batoru.core.gameplay.control.ControlTemporaryCardRules;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.events.EventEner;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.overlay.log.events.LogEventMove;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionEnerCharge
extends TransientCardGameAction {
    private boolean isSilent;

    public ActionEnerCharge(CardIndex cardIndex) {
        super(cardIndex);
    }

    public ActionEnerCharge() {
        this(false);
    }

    public ActionEnerCharge(boolean isSilent) {
        this.isSilent = isSilent;
    }

    @Override
    protected void dispatch() {
        if (!(this.isDataReceived() || this.getCardIndex() != null && this.getCardIndex().getIndexedInstance() != null)) {
            this.requestData();
            return;
        }
        if (this.getCardIndex() == null || this.getCardIndex().getIndexedInstance() != null && this.getSourceAbility() != null && (this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.getCardIndex(), this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.getCardIndex().getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.getCardIndex(), this, new Object[]{GameConst.CardLocation.ENER}) == RuleCheck.RuleCheckState.BLOCK)) {
            this.getDataTable().add(null);
            this.setAsCompleted();
            return;
        }
        GameEvent[] listEvents = new GameEvent[this.isSilent ? 1 : 2];
        listEvents[0] = new EventMove(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), GameConst.CardLocation.ENER);
        if (!this.isSilent) {
            listEvents[1] = new EventEner(this.getCardIndex(), this.getSourceCardIndex(), this.getSourceAbility());
        }
        this.setLogEvent(new LogEventMove((EventMove)listEvents[0], AbilityConst.ActionHint.ENER));
        for (GameEvent event : listEvents) {
            event.setAtOnce(this);
        }
        if (this.applyActiveOverrideActions(this.getCardIndex().getCurrentOwnerSafe(), listEvents) || ControlTemporaryCardRules.applyLocationOverrideOnLeaveField(this.getCardIndex(), this)) {
            return;
        }
        this.addCardIndexData();
        Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilitiesAndWait(listEvents);
        if (this.isLastAtOnce()) {
            this.setOnActionCompleted(() -> Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> Game.getCurrentGame().getGameRules().getEffectProcessor().resolveWaitingEffects()));
        }
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(this::setAsCompleted);
        AnimationCardMove aniMove = new AnimationCardMove(this.getCardIndex().getSourceCard3D(), UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getCardIndex().getCurrentOwnerSafe()).getEnerZone());
        aniMove.setAnimationTracker(tracker);
        aniMove.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> this.setCardIndex(card3D.getCardIndex()));
    }
}

