/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.override.OverrideResult;
import open.batoru.data.CardConst;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Card3DSubstitute;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.AnimationCardMoveRemoveEnerSubstitute;
import open.batoru.game.animations.AnimationCardMoveZoneDrop;
import open.batoru.game.animations.AnimationCardPayEner;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventPayEner;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionEnerPay
extends GameAction<PaidEnerData> {
    private List<PaidEnerData> paidEnerData;

    public ActionEnerPay(List<PaidEnerData> paidEnerData) {
        this.paidEnerData = paidEnerData;
    }

    public ActionEnerPay() {
    }

    @Override
    protected void dispatch() {
        if (this.paidEnerData == null && !this.isDataReceived()) {
            this.requestData();
            return;
        }
        if (this.paidEnerData == null || this.paidEnerData.isEmpty()) {
            this.setAsCompleted();
            return;
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getSourceCost().getPayerRole());
        List<Card3DSubstitute> listEnerSubstitutes = field.getEnerZone().getZoneCardList().stream().filter(Card3DSubstitute.class::isInstance).map(Card3DSubstitute.class::cast).toList();
        AnimationTracker tracker = new AnimationTracker(1 + this.paidEnerData.size() + listEnerSubstitutes.size());
        tracker.setOnTrackerAllFinished(() -> {
            this.paidEnerData.clear();
            Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
            this.setAsCompleted();
        });
        AnimationCardPayEner aniPay = new AnimationCardPayEner(this.paidEnerData, listEnerSubstitutes);
        aniPay.setAnimationTracker(tracker);
        aniPay.setOnAnimationFinished(() -> {
            UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(new LogEventPayEner(this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), this.paidEnerData));
            TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker);
            for (PaidEnerData enerData : this.paidEnerData) {
                OverrideResult overrideResult;
                this.getDataTable().add(enerData);
                if (this.getSourceCost() != null) {
                    this.getSourceCost().addPaidData(enerData);
                }
                Card3D card3D = enerData.cardIndexSnapshot().getSourceCardIndex().getSourceCard3D();
                card3D.getCardMeshFace().removeTextureLayer("ener_tint");
                CardIndex cardIndex = card3D.getCardIndex();
                OverrideResult overrideResult2 = overrideResult = !this.isChildAction() ? this.getSourceOverrideResult() : this.getParentAction().getSourceOverrideResult();
                if (overrideResult != null && (overrideResult.getCurrentOverrideAction().getOverrideFlags() & 8) == 0) {
                    cardIndex.updateOverrideLocation();
                    Game.getCurrentGame().getGameData().addTempCardWithOverriddenLocation(cardIndex);
                }
                TrackableAnimation aniMove = cardIndex.getLocation() == GameConst.CardLocation.ENER ? new AnimationCardMoveZoneDrop(card3D, field.getTrashZone(Deck.DeckType.MAIN)) : new AnimationCardMove(card3D, field.getTrashZone(Card3D.isMainDeckCard(card3D) ? Deck.DeckType.MAIN : Deck.DeckType.LRIG));
                aniMove.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniMove);
            }
            for (Card3DSubstitute card3DSubstitute : listEnerSubstitutes) {
                AnimationCardMoveRemoveEnerSubstitute aniMove = new AnimationCardMoveRemoveEnerSubstitute(card3DSubstitute, field.getEnerZone());
                aniMove.setAnimationTracker(tracker);
                seqAni.getAnimationList().add(aniMove);
            }
            seqAni.play();
        });
        aniPay.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        if (!pp.getDataArgument(1).equals(String.valueOf(0))) {
            Optional<Card3D> card3D;
            this.paidEnerData = new ArrayList<PaidEnerData>();
            for (int i = 1; i < pp.getDataArgsNum() && !(card3D = CardIndex.getCardFromPacketData(pp.getDataArgument(i))).isEmpty(); i += 2) {
                CardConst.CardColor cardColor = CardConst.CardColor.getColorByShortLabel(pp.getDataArgument(i + 1).charAt(0));
                this.paidEnerData.add(new PaidEnerData(new CardIndexSnapshot(card3D.get().getCardIndex()), cardColor));
            }
        }
    }

    public record PaidEnerData(CardIndexSnapshot cardIndexSnapshot, CardConst.CardColor cardColor) implements AbilityCost.Payable
    {
    }
}

