/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.EventPlace;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game.animations.AnimationZoneExchange;
import open.batoru.game.animations.tracker.AnimationTracker;

public class ActionExchange
extends GameAction<CardIndex> {
    private final CardIndex cardIndex1;
    private final CardIndex cardIndex2;
    private final boolean isSilent;

    public ActionExchange(CardIndex cardIndex1, CardIndex cardIndex2, Boolean isSilent) {
        this.cardIndex1 = cardIndex1;
        this.cardIndex2 = cardIndex2;
        this.isSilent = isSilent;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndex1 == null || this.cardIndex2 == null || !GameConst.CardLocation.isSIGNI(this.cardIndex1.getLocation()) || !GameConst.CardLocation.isSIGNI(this.cardIndex2.getLocation()) || this.cardIndex1.getLocation() == this.cardIndex2.getLocation() || this.getSourceCardIndex() != null && (this.cardIndex1.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.cardIndex1, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.cardIndex2.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(this.cardIndex2, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK || this.cardIndex1.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.cardIndex1, this, new Object[]{this.cardIndex2.getLocation()}) == RuleCheck.RuleCheckState.BLOCK || this.cardIndex2.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(this.cardIndex2, this, new Object[]{this.cardIndex1.getLocation()}) == RuleCheck.RuleCheckState.BLOCK || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.cardIndex1.getIndexedInstance().getCurrentOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_NEWLY_PUT_SIGNI_ON_FIELD).check(this.cardIndex1.getIndexedInstance().getCurrentOwner(), this.cardIndex1, this.getSourceAbility(), new Object[]{GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(this.cardIndex2.getLocation())}) == RuleCheck.RuleCheckState.BLOCK || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.cardIndex2.getIndexedInstance().getCurrentOwner()).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_NEWLY_PUT_SIGNI_ON_FIELD).check(this.cardIndex2.getIndexedInstance().getCurrentOwner(), this.cardIndex2, this.getSourceAbility(), new Object[]{GameConst.SIGNIZonePosition.getSIGNIPositionByCardLocation(this.cardIndex1.getLocation())}) == RuleCheck.RuleCheckState.BLOCK)) {
            this.setAsCompleted();
            return;
        }
        ZoneSIGNI zone1 = (ZoneSIGNI)this.cardIndex1.getZoneByLocation();
        ZoneSIGNI zone2 = (ZoneSIGNI)this.cardIndex2.getZoneByLocation();
        this.getDataTable().add(this.cardIndex1);
        this.getDataTable().add(this.cardIndex2);
        if (!this.isSilent) {
            EventMove move1 = new EventMove(this.cardIndex1, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), zone2.getZoneLocation());
            EventMove move2 = new EventMove(this.cardIndex2, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost(), zone1.getZoneLocation());
            move1.setAtOnce(0, 2);
            move2.setAtOnce(1, 2);
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(move1, move2);
        }
        AnimationTracker tracker = new AnimationTracker(1);
        tracker.setOnTrackerAllFinished(() -> {
            if (!this.isSilent) {
                EventPlace place1 = new EventPlace(this.cardIndex1, this.getSourceCardIndex(), this.getSourceAbility());
                EventPlace place2 = new EventPlace(this.cardIndex2, this.getSourceCardIndex(), this.getSourceAbility());
                place1.setAtOnce(0, 2);
                place2.setAtOnce(1, 2);
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(place1, place2);
            }
            this.setAsCompleted();
        });
        AnimationZoneExchange aniExchange = new AnimationZoneExchange(zone1, zone2);
        aniExchange.setAnimationTracker(tracker);
        aniExchange.play();
    }
}

