/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import open.batoru.core.Game;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.events.EventCoin;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Coin3D;
import open.batoru.game.overlay.log.events.LogEventCoin;
import open.batoru.ui.UI;

public class ActionGainCoins
extends GameAction<Boolean> {
    private final Game.GamePlayerRole rolePlayer;
    private final int count;

    public ActionGainCoins(Game.GamePlayerRole rolePlayer, int count) {
        this.rolePlayer = rolePlayer;
        this.count = count;
    }

    @Override
    protected void dispatch() {
        if (this.count == 0 || this.count > 0 && Game.getCurrentGame().getGameRules().getPlayerRuleChecks(this.rolePlayer).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_GAIN_COINS).check(this.rolePlayer, this, new Object[0]) == RuleCheck.RuleCheckState.BLOCK) {
            this.setAsCompleted();
            return;
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer);
        int oldValue = field.getData().getCoins();
        int newValue = field.getData().setCoins(oldValue + this.count);
        if (newValue != oldValue) {
            this.getDataTable().add(true);
            if (this.getSourceCost() != null) {
                this.getSourceCost().addPaidData(new AbilityCost.EmptyPayable());
            }
            EventCoin eventCoin = new EventCoin(newValue - oldValue, this.rolePlayer, this.getSourceCardIndex(), this.getSourceAbility(), this.getSourceCost());
            this.setLogEvent(new LogEventCoin(eventCoin), this.getSourceCardIndex() == null);
            Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(eventCoin);
            if (newValue > oldValue) {
                for (int i = oldValue; i < newValue; ++i) {
                    Coin3D coin = new Coin3D();
                    field.getLRIGZone().getSpinnerCoins().addSpinNode(coin);
                }
            } else {
                for (int i = newValue; i < oldValue; ++i) {
                    field.getLRIGZone().getSpinnerCoins().removeSpinNode();
                }
            }
            field.getLRIGZone().getSpinnerCoins().playRearrangeAnimation();
        }
        this.setAsCompleted();
    }
}

