/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.game.PlayerField;
import open.batoru.game.animations.AnimationTexturedMeshFlash;
import open.batoru.game.overlay.OverlayWinScreen;
import open.batoru.networking.PacketParser;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class ActionGameEnd
extends GameAction<Void> {
    private final Game.GamePlayerRole rolePlayerWinner;

    public ActionGameEnd(Game.GamePlayerRole rolePlayerWinner) {
        this.rolePlayerWinner = rolePlayerWinner;
    }

    @Override
    protected void dispatch() {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Game.GamePlayerRole.getOpponentRole(this.rolePlayerWinner));
        if (this.isDataReceived() || Game.getCurrentGame().getGameRules().getPlayerRuleChecks(Game.GamePlayerRole.getOpponentRole(this.rolePlayerWinner)).getRuleCheck(PlayerRuleCheckRegistry.PlayerRuleCheckType.CAN_LOSE_GAME).check(this.rolePlayerWinner) == RuleCheck.RuleCheckState.BLOCK) {
            field.getLifeClothZone().flashZoneMesh(Color.GREEN);
            this.setAsCompleted();
            return;
        }
        AnimationTexturedMeshFlash aniFlash = new AnimationTexturedMeshFlash(field.getLifeClothZone().getZoneMesh(), Color.WHITE, Color.RED, false);
        aniFlash.play();
        ActionGameEnd.executeGameEnd(LanguageParser.getString(this.rolePlayerWinner == Game.getCurrentGame().getPlayerRole() ? "UI_GAME_WINSCREEN_WIN" : "UI_GAME_WINSCREEN_LOSE"));
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            this.requestData();
        } else {
            this.receiveReplayData(Game.getCurrentGame().getSourceReplayChecksum());
        }
        this.setAsCompleted();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        this.receiveReplayData(pp.getDataArgument(1));
    }

    private void receiveReplayData(String checksum) {
        OverlayWinScreen overlayWinScreen = UI.getTabGame().getFieldSceneOverlay().getWinScreen();
        if (overlayWinScreen == null) {
            return;
        }
        overlayWinScreen.receiveReplayData(checksum);
    }

    public static void executeGameEnd(String message) {
        ActionGameEnd.executeGameEnd(message, null);
    }

    public static void executeGameEnd(String message, String subtitle) {
        UI.getTabGame().getFieldSceneOverlay().hideDisconnectedScreen();
        UI.getTabGame().getFieldSceneOverlay().showWinScreen(message, subtitle);
        Game.getCurrentGame().getPlayerControl().setPlayerLock(true);
        Game.getCurrentGame().setGameState(Game.GameState.POST_GAME);
    }
}

