/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.core.gameplay.actions;

import java.util.ArrayList;
import java.util.List;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionEnerPay;
import open.batoru.core.gameplay.actions.ActionGainCoins;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.CardConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.events.EventEnter;
import open.batoru.data.ability.events.EventGrow;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Card3DSubstitute;
import open.batoru.game.animations.AnimationCardMove;
import open.batoru.game.animations.AnimationCardMoveRemoveEnerSubstitute;
import open.batoru.game.animations.AnimationCardMoveZoneDrop;
import open.batoru.game.animations.AnimationCardPayEner;
import open.batoru.game.animations.AnimationCardRotate;
import open.batoru.game.animations.AnimationFlashGrow;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.game.overlay.log.events.LogEventGrow;
import open.batoru.game.overlay.log.events.LogEventPayEner;
import open.batoru.networking.PacketParser;
import open.batoru.ui.UI;

public class ActionGrow
extends GameAction<CardIndex> {
    private CardIndex cardIndexNextLRIG;
    private Card3D card3DCurrentLRIG;
    private Card3D card3DNextLRIG;
    private List<ActionEnerPay.PaidEnerData> listPaidEnerData;
    private List<Card3DSubstitute> listEnerSubstitutes;

    public ActionGrow(CardIndex cardIndexNextLRIG, List<ActionEnerPay.PaidEnerData> listPaidEnerData) {
        this.cardIndexNextLRIG = cardIndexNextLRIG;
        this.listPaidEnerData = listPaidEnerData;
    }

    public ActionGrow(PacketParser pp) {
        this.setReceivedPacketData(pp);
    }

    public ActionGrow() {
    }

    public void setCard3DCurrentLRIG(Card3D card3DCurrentLRIG) {
        this.card3DCurrentLRIG = card3DCurrentLRIG;
    }

    @Override
    protected void dispatch() {
        if (this.cardIndexNextLRIG == null) {
            if (!this.isDataReceived()) {
                this.requestData();
            } else {
                this.setAsCompleted();
            }
            return;
        }
        if (this.card3DNextLRIG == null) {
            this.card3DNextLRIG = this.cardIndexNextLRIG.getSourceCard3D();
        }
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndexNextLRIG.getIndexedInstance().getCurrentOwner());
        UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.cardIndexNextLRIG);
        if (this.card3DNextLRIG.getCardIndex().getCardReference().getType() == CardConst.CardType.LRIG) {
            this.card3DCurrentLRIG = field.getLRIGZone().getTopCard();
        } else if (this.card3DCurrentLRIG == null) {
            if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft())) {
                CardIndex cardIndexLRIGAssistLeft = field.getLRIGAssistZoneLeft().getTopCard().getCardIndex();
                if (this.card3DNextLRIG.getCardIndex().getIndexedInstance().getLRIGType().matches(cardIndexLRIGAssistLeft.getIndexedInstance().getLRIGType()) && this.card3DNextLRIG.getCardIndex().getIndexedInstance().getLevel().getValue() == cardIndexLRIGAssistLeft.getIndexedInstance().getLevel().getValue() + 1) {
                    this.card3DCurrentLRIG = field.getLRIGAssistZoneLeft().getTopCard();
                }
            }
            if (this.card3DCurrentLRIG == null && FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
                CardIndex cardIndexLRIGAssistRight = field.getLRIGAssistZoneRight().getTopCard().getCardIndex();
                if (this.card3DNextLRIG.getCardIndex().getIndexedInstance().getLRIGType().matches(cardIndexLRIGAssistRight.getIndexedInstance().getLRIGType()) && this.card3DNextLRIG.getCardIndex().getIndexedInstance().getLevel().getValue() == cardIndexLRIGAssistRight.getIndexedInstance().getLevel().getValue() + 1) {
                    this.card3DCurrentLRIG = field.getLRIGAssistZoneRight().getTopCard();
                }
            }
            if (this.card3DCurrentLRIG == null) {
                this.setAsCompleted();
                return;
            }
        }
        if (!ActionGrow.canGrowInto(this.card3DCurrentLRIG.getCardIndex(), this.cardIndexNextLRIG)) {
            this.setAsCompleted();
            return;
        }
        this.getDataTable().add(this.cardIndexNextLRIG);
        boolean wasDowned = this.card3DCurrentLRIG.getCardIndex().getIndexedInstance().isState(16384);
        boolean wasInDrive = this.card3DCurrentLRIG.getCardIndex().getIndexedInstance().isState(0x200000);
        AnimationTracker tracker = new AnimationTracker(2 + (this.listPaidEnerData != null && !this.listPaidEnerData.isEmpty() ? this.listPaidEnerData.size() + 1 : 0) + (wasDowned ? 1 : 0));
        tracker.setOnTrackerAllFinished(() -> {
            if (wasDowned) {
                this.cardIndexNextLRIG.getIndexedInstance().getCardStateFlags().addValue(16384);
            }
            if (wasInDrive) {
                this.cardIndexNextLRIG.getIndexedInstance().getCardStateFlags().addValue(0x200000);
            }
            if (this.cardIndexNextLRIG.getLocation() == GameConst.CardLocation.LRIG && this.cardIndexNextLRIG.getCardReference().getCoins() > 0) {
                this.setOnActionCompleted(() -> {
                    ActionGainCoins action = new ActionGainCoins(this.cardIndexNextLRIG.getIndexedInstance().getCurrentOwner(), this.cardIndexNextLRIG.getCardReference().getCoins());
                    action.setSourceCardIndex(this.cardIndexNextLRIG);
                    Game.getCurrentGame().getActionQueue().addAction(action);
                });
            }
            EventGrow eventGrow = new EventGrow(this.cardIndexNextLRIG, this.card3DCurrentLRIG.getCardIndex(), this.getSourceAbility());
            this.setLogEvent(new LogEventGrow(eventGrow));
            Game.getCurrentGame().getGameRules().getRuleProcessor().setOnRuleProcessingFinished(() -> {
                Game.getCurrentGame().getGameRules().getEffectProcessor().processAbilities(eventGrow, new EventEnter(this.cardIndexNextLRIG, this.card3DCurrentLRIG.getCardIndex(), this.getSourceAbility()));
                if (this.cardIndexNextLRIG.getLocation() == GameConst.CardLocation.TRASH_LRIG) {
                    this.cardIndexNextLRIG.getIndexedInstance().getAbilityList().forEach(Ability::mute);
                }
            });
            if (this.listPaidEnerData != null) {
                this.listPaidEnerData.clear();
            }
            this.setAsCompleted();
        });
        if (this.cardIndexNextLRIG.getLocation() == GameConst.CardLocation.LRIG) {
            field.getFieldBackground().playAnimation(1000, this.card3DCurrentLRIG.getCardIndex().getIndexedInstance().getColor().getPrimaryValue(), this.cardIndexNextLRIG.getIndexedInstance().getColor().getPrimaryValue());
        }
        if (this.listPaidEnerData != null && !this.listPaidEnerData.isEmpty()) {
            this.listEnerSubstitutes = field.getEnerZone().getZoneCardList().stream().filter(Card3DSubstitute.class::isInstance).map(Card3DSubstitute.class::cast).toList();
            tracker.setMaxCount(tracker.getMaxCount() + this.listEnerSubstitutes.size());
            UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(new LogEventPayEner(this.cardIndexNextLRIG, this.listPaidEnerData));
            AnimationCardPayEner aniPay = new AnimationCardPayEner(this.listPaidEnerData, this.listEnerSubstitutes);
            aniPay.setAnimationTracker(tracker);
            aniPay.setOnAnimationFinished(() -> this.playGrowAnimations(tracker, wasDowned));
            aniPay.play();
        } else {
            this.playGrowAnimations(tracker, wasDowned);
        }
    }

    private void playGrowAnimations(AnimationTracker tracker, boolean wasDowned) {
        TrackableSequentialTransition seqAni = new TrackableSequentialTransition(tracker, wasDowned || this.listPaidEnerData != null && !this.listPaidEnerData.isEmpty() ? 3 : 2);
        AnimationFlashGrow aniFlash = new AnimationFlashGrow(this.card3DCurrentLRIG.getCardIndex().getImageSet(), this.cardIndexNextLRIG.getImageSet());
        aniFlash.setAnimationTracker(tracker);
        seqAni.getAnimationList(0).add(aniFlash);
        AnimationCardMove aniMove = new AnimationCardMove(this.card3DNextLRIG, this.card3DCurrentLRIG.getOwnerZone());
        aniMove.setAnimationTracker(tracker);
        seqAni.getAnimationList(1).add(aniMove);
        if (wasDowned) {
            aniMove.setDownedRotationOffset();
        }
        if (wasDowned) {
            AnimationCardRotate aniUp = new AnimationCardRotate(this.card3DCurrentLRIG, true);
            aniUp.setAnimationTracker(tracker);
            seqAni.getAnimationList(2).add(aniUp);
        }
        if (this.listPaidEnerData != null) {
            PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.cardIndexNextLRIG.getCurrentOwnerSafe());
            for (ActionEnerPay.PaidEnerData enerData : this.listPaidEnerData) {
                Card3D card3D = enerData.cardIndexSnapshot().getSourceCardIndex().getSourceCard3D();
                card3D.getCardMeshFace().removeTextureLayer("ener_tint");
                CardIndex cardIndex = card3D.getCardIndex();
                TrackableAnimation aniMoveEner = cardIndex.getLocation() == GameConst.CardLocation.ENER ? new AnimationCardMoveZoneDrop(card3D, field.getTrashZone(Deck.DeckType.MAIN)) : new AnimationCardMove(card3D, field.getTrashZone(Card3D.isMainDeckCard(card3D) ? Deck.DeckType.MAIN : Deck.DeckType.LRIG));
                aniMoveEner.setAnimationTracker(tracker);
                seqAni.getAnimationList(2).add(aniMoveEner);
            }
            if (this.listEnerSubstitutes != null) {
                for (Card3DSubstitute card3DSubstitute : this.listEnerSubstitutes) {
                    AnimationCardMoveRemoveEnerSubstitute aniMoveEner = new AnimationCardMoveRemoveEnerSubstitute(card3DSubstitute, field.getEnerZone());
                    aniMoveEner.setAnimationTracker(tracker);
                    seqAni.getAnimationList(2).add(aniMoveEner);
                }
            }
        }
        seqAni.play();
    }

    @Override
    protected void onDataReceived(PacketParser pp) {
        CardIndex.getCardFromPacketData(pp.getDataArgument(1)).ifPresent(card3D -> {
            this.cardIndexNextLRIG = card3D.getCardIndex();
        });
        if (pp.getDataArgsNum() > 2) {
            this.listPaidEnerData = new ArrayList<ActionEnerPay.PaidEnerData>();
            int argCurrentLRIGData = 0;
            for (int i = 2; i < pp.getDataArgsNum(); i += 2) {
                if (i + 1 == pp.getDataArgsNum()) {
                    argCurrentLRIGData = i;
                    break;
                }
                if (pp.getDataArgument(i).startsWith("!")) {
                    argCurrentLRIGData = i + 1;
                    break;
                }
                CardIndex cardIndex = Game.getCurrentGame().getIndexRegistry().getIndex(Integer.parseInt(pp.getDataArgument(i)));
                CardConst.CardColor cardColor = CardConst.CardColor.getColorByShortLabel(pp.getDataArgument(i + 1).charAt(0));
                this.listPaidEnerData.add(new ActionEnerPay.PaidEnerData(new CardIndexSnapshot(cardIndex), cardColor));
            }
            if (argCurrentLRIGData != 0) {
                CardIndex.getCardFromPacketData(pp.getDataArgument(argCurrentLRIGData)).ifPresent(card3D -> {
                    this.card3DCurrentLRIG = card3D;
                });
                Game.getCurrentGame().getGameRules().getEffectProcessor().updateConstantAbilities();
            }
        }
    }

    public static boolean canGrowInto(CardIndex cardIndexCurrentLRIG, CardIndex cardIndexNextLRIG) {
        return !(cardIndexNextLRIG.getIndexedInstance().getLevel().getValue() != cardIndexCurrentLRIG.getIndexedInstance().getLevel().getValue() + 1 || !cardIndexNextLRIG.getIndexedInstance().getLRIGType().matches(cardIndexCurrentLRIG.getIndexedInstance().getLRIGType()) && cardIndexNextLRIG.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.MUST_IGNORE_GROW_LRIG_TYPE).check(cardIndexNextLRIG) != RuleCheck.RuleCheckState.OK || cardIndexCurrentLRIG.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_GROW).check(cardIndexNextLRIG) != RuleCheck.RuleCheckState.OK || cardIndexNextLRIG.getIndexedInstance().getUseCondition() == GameConst.UseCondition.GROW && cardIndexNextLRIG.getIndexedInstance().getUseConditionTargetFilter().getValidTargetsCount(true) <= 0);
    }
}

